/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.gui;

import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import teamroots.embers.api.filter.EnumFilterSetting;
import teamroots.embers.api.filter.IFilterComparator;
import teamroots.embers.util.FilterUtil;
import teamroots.embers.util.Vec2i;

public class ContainerEye
extends Container {
    public static final int WIDTH = 176;
    public static final int HEIGHT = 205;
    public static final int VAR_FLAG = 0;
    public static final int VAR_INVERTED = 1;
    public static final int VAR_FILTER_OFFSET = 2;
    EnumHand hand;
    ItemStack stack;
    IInventory filterInventory = new InventoryBasic("EyeFilter", true, 2);
    ItemStack stack1;
    ItemStack stack2;
    boolean inverted;
    EnumFilterSetting flag = EnumFilterSetting.STRICT;
    IFilterComparator comparator;
    int filterOffset;

    public ContainerEye(EntityPlayer player) {
        this.stack = player.func_184614_ca();
        this.hand = EnumHand.MAIN_HAND;
        if (this.stack.func_190926_b()) {
            this.stack = player.func_184592_cb();
            this.hand = EnumHand.OFF_HAND;
        }
        this.readFromStack(this.stack);
        Vec2i leftItem = this.getButtonPosition(0, 0, 90.0f);
        Vec2i rightItem = this.getButtonPosition(0, 0, 270.0f);
        this.func_75146_a(new Slot(this.filterInventory, 0, leftItem.x - 8, leftItem.y - 8){

            public void func_75218_e() {
                super.func_75218_e();
                ContainerEye.this.filterOffset = 0;
                ContainerEye.this.refresh();
            }
        });
        this.func_75146_a(new Slot(this.filterInventory, 1, rightItem.x - 8, rightItem.y - 8){

            public void func_75218_e() {
                super.func_75218_e();
                ContainerEye.this.filterOffset = 0;
                ContainerEye.this.refresh();
            }
        });
        this.bindPlayerInventory(player.field_71071_by);
    }

    private void readFromStack(ItemStack stack) {
        NBTTagCompound compound = stack.func_77978_p();
        if (compound != null) {
            String comparatorName = compound.func_74779_i("comparator");
            this.stack1 = new ItemStack(compound.func_74775_l("stack1"));
            this.stack2 = new ItemStack(compound.func_74775_l("stack2"));
            this.comparator = FilterUtil.getComparator(comparatorName);
            this.filterOffset = compound.func_74762_e("offset");
            this.inverted = compound.func_74767_n("inverted");
            this.flag = EnumFilterSetting.get(compound.func_74762_e("setting"));
        }
    }

    public void triggerButton(EnumButton button) {
        switch (button) {
            case FINISH: {
                this.writeToStack();
                break;
            }
            case LEFT: {
                this.moveLeft();
                break;
            }
            case RIGHT: {
                this.moveRight();
                break;
            }
            case FLAG: {
                this.toggleFlag();
                break;
            }
            case INVERT: {
                this.toggleInvert();
            }
        }
    }

    public void writeToStack() {
        NBTTagCompound compound = this.stack.func_77978_p();
        if (compound == null) {
            compound = new NBTTagCompound();
        }
        compound.func_74778_a("comparator", this.comparator.getName());
        compound.func_74768_a("offset", this.filterOffset);
        compound.func_74757_a("inverted", this.inverted);
        compound.func_74768_a("setting", this.flag.ordinal());
        compound.func_74782_a("stack1", (NBTBase)this.stack1.serializeNBT());
        compound.func_74782_a("stack2", (NBTBase)this.stack2.serializeNBT());
        this.stack.func_77982_d(compound);
    }

    public void toggleInvert() {
        this.inverted = !this.inverted;
        this.func_75142_b();
    }

    public void toggleFlag() {
        this.flag = this.flag.rotate(1);
        this.func_75142_b();
    }

    public void moveLeft() {
        --this.filterOffset;
        this.refresh();
        this.func_75142_b();
    }

    public void moveRight() {
        ++this.filterOffset;
        this.refresh();
        this.func_75142_b();
    }

    private void refresh() {
        this.stack1 = this.filterInventory.func_70301_a(0);
        this.stack2 = this.filterInventory.func_70301_a(1);
        this.comparator = this.findComparator(this.stack1, this.stack2, this.filterOffset);
    }

    private IFilterComparator findComparator(ItemStack stack1, ItemStack stack2, int offset) {
        if (stack1.func_190926_b() && stack2.func_190926_b()) {
            return FilterUtil.ANY;
        }
        List<IFilterComparator> comparators = FilterUtil.getComparators(stack1, stack2);
        if (offset < 0) {
            offset = offset % comparators.size() + comparators.size();
        }
        return comparators.get(offset % comparators.size());
    }

    protected void broadcastData(IContainerListener crafting) {
        crafting.func_71112_a((Container)this, 0, this.flag.ordinal());
        crafting.func_71112_a((Container)this, 1, this.inverted ? 1 : 0);
        crafting.func_71112_a((Container)this, 2, this.filterOffset);
    }

    public void func_75132_a(IContainerListener listener) {
        super.func_75132_a(listener);
        this.broadcastData(listener);
    }

    public void func_75142_b() {
        super.func_75142_b();
        for (int i = 0; i < this.field_75149_d.size(); ++i) {
            IContainerListener icontainerlistener = (IContainerListener)this.field_75149_d.get(i);
            this.broadcastData(icontainerlistener);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_75137_b(int id, int data) {
        switch (id) {
            case 2: {
                this.filterOffset = data;
                break;
            }
            case 1: {
                this.inverted = data > 0;
                break;
            }
            case 0: {
                this.flag = EnumFilterSetting.get(data);
                break;
            }
            default: {
                super.func_75137_b(id, data);
            }
        }
        this.refresh();
    }

    public Vec2i getButtonPosition(int xPos, int yPos, float angle) {
        int xCenter = xPos + 88;
        int yCenter = yPos + 85 - 50;
        int xButton = xCenter + (int)(-Math.sin(Math.toRadians(angle)) * 106.0 / 2.0);
        int yButton = yCenter + (int)(-Math.cos(Math.toRadians(angle)) * 40.0);
        return new Vec2i(xButton, yButton);
    }

    public boolean func_94530_a(ItemStack stack, Slot slotIn) {
        return false;
    }

    public ItemStack func_82846_b(EntityPlayer playerIn, int index) {
        ItemStack itemstack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemstack1 = slot.func_75211_c();
            itemstack = itemstack1.func_77946_l();
            if (index < 2 ? !this.func_75135_a(itemstack1, 2, 38, true) : !this.func_75135_a(itemstack1, 0, 2, false)) {
                return ItemStack.field_190927_a;
            }
            if (itemstack1.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (itemstack1.func_190916_E() == itemstack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(playerIn, itemstack1);
        }
        return itemstack;
    }

    public void func_75134_a(EntityPlayer playerIn) {
    }

    protected void bindPlayerInventory(InventoryPlayer inventoryPlayer) {
        int i;
        int yInventory = 120;
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_75146_a(new Slot((IInventory)inventoryPlayer, j + i * 9 + 9, 8 + j * 18, yInventory + 4 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            if (inventoryPlayer.func_70301_a(i) == this.stack) {
                this.func_75146_a(new Slot((IInventory)inventoryPlayer, i, 8 + i * 18, yInventory + 4 + 58){

                    public boolean func_82869_a(EntityPlayer playerIn) {
                        return false;
                    }
                });
                continue;
            }
            this.func_75146_a(new Slot((IInventory)inventoryPlayer, i, 8 + i * 18, yInventory + 4 + 58));
        }
    }

    public boolean func_75145_c(EntityPlayer playerIn) {
        return !this.stack.func_190926_b() && playerIn.func_184586_b(this.hand) == this.stack;
    }

    public static enum EnumButton {
        FINISH,
        LEFT,
        RIGHT,
        FLAG,
        INVERT;

    }
}

