/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.compat.crafttweaker;

import com.google.common.collect.Lists;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import stanhebben.zenscript.annotations.NotNull;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;
import stanhebben.zenscript.value.IntRange;
import teamroots.embers.api.EmbersAPI;
import teamroots.embers.api.alchemy.AspectList;
import teamroots.embers.compat.crafttweaker.CTUtil;
import teamroots.embers.recipe.AlchemyRecipe;
import teamroots.embers.recipe.RecipeRegistry;

@ZenRegister
@ZenClass(value="mods.embers.Alchemy")
public class Alchemy {
    public static final String NAME = "Alchemy";
    public static final String CLASS = "mods.embers.Alchemy";

    @ZenMethod
    public static void addAspect(String name, IIngredient item) {
        CraftTweakerAPI.apply((IAction)new AddAspect(name, item));
    }

    @ZenMethod
    public static void add(IItemStack output, @NotNull IIngredient[] input, Map<String, IntRange> aspects) {
        AspectList minAspects = new AspectList();
        AspectList maxAspects = new AspectList();
        for (Map.Entry<String, IntRange> entry : aspects.entrySet()) {
            String aspect = entry.getKey();
            minAspects.addAspect(aspect, entry.getValue().getFrom());
            maxAspects.addAspect(aspect, entry.getValue().getTo());
        }
        AspectList.AspectRangeList aspectRange = new AspectList.AspectRangeList(minAspects, maxAspects);
        AlchemyRecipe recipe = new AlchemyRecipe(aspectRange, CTUtil.toIngredient(input[0]), Lists.newArrayList((Object[])new Ingredient[]{CTUtil.toIngredient(input[1]), CTUtil.toIngredient(input[2]), CTUtil.toIngredient(input[3]), CTUtil.toIngredient(input[4])}), CraftTweakerMC.getItemStack((IItemStack)output));
        CraftTweakerAPI.apply((IAction)new Add(recipe));
    }

    @ZenMethod
    public static void remove(IItemStack output) {
        CraftTweakerAPI.apply((IAction)new RemoveByOutput(CraftTweakerMC.getItemStack((IItemStack)output)));
    }

    @ZenMethod
    public static void removeAll() {
        CraftTweakerAPI.apply((IAction)new RemoveAll());
    }

    private static List<AlchemyRecipe> getRecipesByOutput(ItemStack stack) {
        return RecipeRegistry.alchemyRecipes.stream().filter(recipe -> ItemStack.func_179545_c((ItemStack)recipe.result, (ItemStack)stack)).collect(Collectors.toCollection(ArrayList::new));
    }

    public static class RemoveAll
    implements IAction {
        protected RemoveAll() {
        }

        public void apply() {
            RecipeRegistry.alchemyRecipes.clear();
        }

        public String describe() {
            return String.format("Removing all %s recipes", Alchemy.NAME);
        }
    }

    public static class RemoveByOutput
    implements IAction {
        ItemStack output;

        protected RemoveByOutput(ItemStack output) {
            this.output = output;
        }

        public void apply() {
            RecipeRegistry.alchemyRecipes.removeAll(Alchemy.getRecipesByOutput(this.output));
        }

        public String describe() {
            return String.format("Removing %s recipes with output: %s", Alchemy.NAME, this.output.toString());
        }
    }

    public static class Add
    implements IAction {
        AlchemyRecipe recipe;

        public Add(AlchemyRecipe recipe) {
            this.recipe = recipe;
        }

        public void apply() {
            RecipeRegistry.alchemyRecipes.add(this.recipe);
        }

        public String describe() {
            return String.format("Adding %s recipe: %s", Alchemy.NAME, this.recipe.toString());
        }
    }

    public static class AddAspect
    implements IAction {
        String name;
        IIngredient item;

        public AddAspect(String name, IIngredient item) {
            this.name = name;
            this.item = item;
        }

        public void apply() {
            EmbersAPI.registerAlchemyAspect(CTUtil.toIngredient(this.item), this.name);
        }

        public String describe() {
            return "Adding custom aspect '" + this.name + "'";
        }
    }
}

