/*
 * Decompiled with CFR 0.152.
 */
package com.harleyoconnor.dynamictreesnaturesaura.trees;

import com.ferreusveritas.dynamictrees.api.IGenFeature;
import com.ferreusveritas.dynamictrees.blocks.BlockSurfaceRoot;
import com.ferreusveritas.dynamictrees.systems.featuregen.FeatureGenRoots;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.trees.TreeFamily;
import com.harleyoconnor.dynamictreesnaturesaura.ModContent;
import java.util.List;
import java.util.function.BiFunction;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;

public class TreeAncient
extends TreeFamily {
    public static Block leavesBlock = Block.func_149684_b((String)"naturesaura:ancient_leaves");
    public static Block logBlock = Block.func_149684_b((String)"naturesaura:ancient_log");
    public static Block saplingBlock = Block.func_149684_b((String)"naturesaura:ancient_sapling");

    public TreeAncient() {
        super(new ResourceLocation("dynamictreesnaturesaura", "ancient"));
        this.setPrimitiveLog(logBlock.func_176223_P(), new ItemStack(logBlock, 1, 0));
        ModContent.ancientLeavesProperties.setTree((TreeFamily)this);
        ModContent.ancientRoot = new BlockSurfaceRoot(Material.field_151575_d, this.getName() + "root");
        this.addConnectableVanillaLeaves(state -> state.func_177230_c() == leavesBlock);
    }

    public void createSpecies() {
        this.setCommonSpecies(new SpeciesAncient(this));
    }

    public boolean isThick() {
        return true;
    }

    public boolean autoCreateBranch() {
        return true;
    }

    public BlockSurfaceRoot getSurfaceRoots() {
        return ModContent.ancientRoot;
    }

    public List<Block> getRegisterableBlocks(List<Block> blockList) {
        blockList.add((Block)ModContent.ancientRoot);
        return super.getRegisterableBlocks(blockList);
    }

    public class SpeciesAncient
    extends Species {
        private final int minTrunkRadiusForRoots = 6;

        public SpeciesAncient(TreeFamily treeFamily) {
            super(treeFamily.getName(), treeFamily, ModContent.ancientLeavesProperties);
            this.minTrunkRadiusForRoots = 6;
            this.setBasicGrowingParameters(0.6f, 24.0f, 3, 4, 0.8f);
            this.setupStandardSeedDropping();
            this.generateSeed();
            this.addGenFeature((IGenFeature)new FeatureGenRoots(this.minTrunkRadiusForRoots).setScaler(this.getRootScaler()));
        }

        protected BiFunction<Integer, Integer, Integer> getRootScaler() {
            return (inRadius, trunkRadius) -> {
                float scale = MathHelper.func_76131_a((float)(trunkRadius >= this.minTrunkRadiusForRoots ? (float)trunkRadius.intValue() / 10.0f : 0.0f), (float)0.0f, (float)1.0f);
                return (int)((float)inRadius.intValue() * scale);
            };
        }

        public boolean isThick() {
            return true;
        }

        public int maxBranchRadius() {
            return 16;
        }
    }
}

