/*
 * Decompiled with CFR 0.152.
 */
package com.harleyoconnor.dynamictreesnaturesaura.effects;

import com.ferreusveritas.dynamictrees.blocks.BlockDynamicLeaves;
import com.harleyoconnor.dynamictreesnaturesaura.ModContent;
import de.ellpeck.naturesaura.ModConfig;
import de.ellpeck.naturesaura.api.NaturesAuraAPI;
import de.ellpeck.naturesaura.api.aura.chunk.IAuraChunk;
import de.ellpeck.naturesaura.api.aura.chunk.IDrainSpotEffect;
import de.ellpeck.naturesaura.api.aura.type.IAuraType;
import de.ellpeck.naturesaura.blocks.BlockDecayedLeaves;
import de.ellpeck.naturesaura.blocks.ModBlocks;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

public class DynamicLeavesDecayEffect
implements IDrainSpotEffect {
    public static final ResourceLocation NAME = new ResourceLocation("naturesaura", "dynamic_leave_decay");
    private int amount;
    private int dist;

    private boolean calcValues(World world, BlockPos pos, Integer spot) {
        int aura;
        if (spot < 0 && (aura = IAuraChunk.getAuraInArea((World)world, (BlockPos)pos, (int)50)) < 0) {
            this.amount = Math.min(300, MathHelper.func_76123_f((float)((float)Math.abs(aura) / 100000.0f / (float)IAuraChunk.getSpotAmountInArea((World)world, (BlockPos)pos, (int)50))));
            if (this.amount > 1) {
                this.dist = MathHelper.func_76125_a((int)(Math.abs(aura) / 75000), (int)5, (int)75);
                return true;
            }
        }
        return false;
    }

    public int isActiveHere(EntityPlayer player, Chunk chunk, IAuraChunk auraChunk, BlockPos pos, Integer spot) {
        if (!this.calcValues(player.field_70170_p, pos, spot)) {
            return -1;
        }
        if (player.func_174818_b(pos) > (double)(this.dist * this.dist)) {
            return -1;
        }
        return 1;
    }

    public ItemStack getDisplayIcon() {
        return new ItemStack(ModBlocks.DECAYED_LEAVES);
    }

    public void update(World world, Chunk chunk, IAuraChunk auraChunk, BlockPos pos, Integer spot) {
        if (!this.calcValues(world, pos, spot)) {
            return;
        }
        for (int i = this.amount / 2 + world.field_73012_v.nextInt(this.amount / 2); i >= 0; --i) {
            BlockPos grassPos = new BlockPos((double)pos.func_177958_n() + world.field_73012_v.nextGaussian() * (double)this.dist, (double)pos.func_177956_o() + world.field_73012_v.nextGaussian() * (double)this.dist, (double)pos.func_177952_p() + world.field_73012_v.nextGaussian() * (double)this.dist);
            if (!(grassPos.func_177951_i((Vec3i)pos) <= (double)(this.dist * this.dist)) || !world.func_175667_e(grassPos)) continue;
            IBlockState state = world.func_180495_p(grassPos);
            Block block = state.func_177230_c();
            IBlockState newState = null;
            if (block instanceof BlockDecayedLeaves || block instanceof BlockDynamicLeaves) {
                newState = ModContent.decayedLeaves.func_176223_P();
            }
            if (newState == null) continue;
            world.func_175656_a(grassPos, newState);
        }
    }

    public boolean appliesHere(Chunk chunk, IAuraChunk auraChunk, IAuraType type) {
        return ModConfig.enabledFeatures.grassDieEffect && type.isSimilar((IAuraType)NaturesAuraAPI.TYPE_OVERWORLD);
    }

    public ResourceLocation getName() {
        return NAME;
    }
}

