/*
 * Decompiled with CFR 0.152.
 */
package com.harleyoconnor.dynamictreesnaturesaura;

import com.ferreusveritas.dynamictrees.ModItems;
import com.ferreusveritas.dynamictrees.ModRecipes;
import com.ferreusveritas.dynamictrees.api.TreeRegistry;
import com.ferreusveritas.dynamictrees.api.WorldGenRegistry;
import com.ferreusveritas.dynamictrees.api.client.ModelHelper;
import com.ferreusveritas.dynamictrees.api.treedata.ILeavesProperties;
import com.ferreusveritas.dynamictrees.blocks.BlockDynamicLeaves;
import com.ferreusveritas.dynamictrees.blocks.BlockSurfaceRoot;
import com.ferreusveritas.dynamictrees.blocks.LeavesPaging;
import com.ferreusveritas.dynamictrees.blocks.LeavesProperties;
import com.ferreusveritas.dynamictrees.items.DendroPotion;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.trees.TreeFamily;
import com.ferreusveritas.dynamictrees.trees.TreeOak;
import com.harleyoconnor.dynamictreesnaturesaura.ModConfig;
import com.harleyoconnor.dynamictreesnaturesaura.blocks.BlockDynamicLeavesAncient;
import com.harleyoconnor.dynamictreesnaturesaura.blocks.BlockDynamicLeavesDecayed;
import com.harleyoconnor.dynamictreesnaturesaura.blocks.BlockDynamicLeavesGolden;
import com.harleyoconnor.dynamictreesnaturesaura.trees.TreeAncient;
import de.ellpeck.naturesaura.blocks.ModBlocks;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.properties.IProperty;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMap;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.lang3.ArrayUtils;

@Mod.EventBusSubscriber(modid="dynamictreesnaturesaura")
@GameRegistry.ObjectHolder(value="dynamictreesnaturesaura")
public class ModContent {
    public static Item itemAncientSeed;
    public static BlockDynamicLeaves decayedLeaves;
    public static BlockDynamicLeaves goldenLeaves;
    public static BlockDynamicLeaves ancientLeaves;
    public static BlockSurfaceRoot ancientRoot;
    public static ILeavesProperties ancientLeavesProperties;
    public static ILeavesProperties goldenLeavesProperties;
    public static List<BlockDynamicLeaves> leaves;
    public static ArrayList<TreeFamily> trees;

    @SubscribeEvent
    public static void registerDataBasePopulators(WorldGenRegistry.BiomeDataBasePopulatorRegistryEvent event) {
    }

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        IForgeRegistry registry = event.getRegistry();
        decayedLeaves = new BlockDynamicLeavesDecayed();
        registry.register((IForgeRegistryEntry)decayedLeaves);
        goldenLeaves = new BlockDynamicLeavesGolden();
        registry.register((IForgeRegistryEntry)goldenLeaves);
        if (ModConfig.GOLD_LEAF_NEEDS_OAK) {
            goldenLeavesProperties = ModContent.setUpLeaves((Block)ModBlocks.GOLDEN_LEAVES, (String)"bare");
            goldenLeavesProperties.setDynamicLeavesState(goldenLeaves.func_176223_P().func_177226_a((IProperty)BlockDynamicLeaves.TREE, (Comparable)Integer.valueOf(0)));
            goldenLeaves.setProperties(0, goldenLeavesProperties);
        }
        ArrayList<TreeFamily> registeredFamilies = new ArrayList<TreeFamily>();
        for (Species species : Species.REGISTRY) {
            if (registeredFamilies.contains(species.getFamily())) continue;
            if (ModConfig.GOLD_LEAF_NEEDS_OAK) {
                if (species.getFamily() instanceof TreeOak) {
                    goldenLeavesProperties.setTree(species.getFamily());
                } else {
                    ILeavesProperties goldLeavesProperties = ModContent.setUpLeaves((Block)ModBlocks.GOLDEN_LEAVES, (String)"bare");
                    goldLeavesProperties.setTree(species.getFamily());
                    goldLeavesProperties.setDynamicLeavesState(goldenLeaves.func_176223_P().func_177226_a((IProperty)BlockDynamicLeaves.TREE, (Comparable)Integer.valueOf(0)));
                    ModContent.goldenLeaves.properties = (ILeavesProperties[])ArrayUtils.add((Object[])ModContent.decayedLeaves.properties, (Object)goldLeavesProperties);
                }
            }
            ILeavesProperties decayedLeavesProperties = ModContent.setUpLeaves((Block)ModBlocks.DECAYED_LEAVES, (String)"bare");
            decayedLeavesProperties.setTree(species.getFamily());
            decayedLeavesProperties.setDynamicLeavesState(decayedLeaves.func_176223_P().func_177226_a((IProperty)BlockDynamicLeaves.TREE, (Comparable)Integer.valueOf(0)));
            ModContent.decayedLeaves.properties = (ILeavesProperties[])ArrayUtils.add((Object[])ModContent.decayedLeaves.properties, (Object)decayedLeavesProperties);
            registeredFamilies.add(species.getFamily());
        }
        ancientLeaves = new BlockDynamicLeavesAncient();
        registry.register((IForgeRegistryEntry)ancientLeaves);
        ancientLeavesProperties = ModContent.setUpLeaves((Block)ModBlocks.ANCIENT_LEAVES, (String)"deciduous");
        ancientLeavesProperties.setDynamicLeavesState(ancientLeaves.func_176223_P().func_177226_a((IProperty)BlockDynamicLeaves.TREE, (Comparable)Integer.valueOf(0)));
        ancientLeaves.setProperties(0, ancientLeavesProperties);
        Collections.addAll(leaves, decayedLeaves, goldenLeaves, ancientLeaves);
        TreeAncient ancientTree = new TreeAncient();
        itemAncientSeed = ancientTree.getCommonSpecies().getSeedStack(1).func_77973_b();
        Collections.addAll(trees, new TreeFamily[]{ancientTree});
        trees.forEach(tree -> tree.registerSpecies(Species.REGISTRY));
        ArrayList treeBlocks = new ArrayList();
        trees.forEach(tree -> tree.getRegisterableBlocks((List)treeBlocks));
        treeBlocks.addAll(LeavesPaging.getLeavesMapForModId((String)"dynamictreesnaturesaura").values());
        registry.registerAll((IForgeRegistryEntry[])treeBlocks.toArray(new Block[treeBlocks.size()]));
    }

    public static ILeavesProperties setUpLeaves(Block primitiveLeavesBlock, String cellKit) {
        LeavesProperties leavesProperties = new LeavesProperties(primitiveLeavesBlock.func_176223_P(), new ItemStack(primitiveLeavesBlock, 1, 0), TreeRegistry.findCellKit((String)cellKit)){

            public ItemStack getPrimitiveLeavesItemStack() {
                return new ItemStack(primitiveLeavesBlock, 1, 0);
            }

            public int getLightRequirement() {
                return 1;
            }
        };
        return leavesProperties;
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        IForgeRegistry registry = event.getRegistry();
        ArrayList treeItems = new ArrayList();
        trees.forEach(tree -> tree.getRegisterableItems((List)treeItems));
        registry.registerAll((IForgeRegistryEntry[])treeItems.toArray(new Item[treeItems.size()]));
    }

    @SubscribeEvent
    public static void registerRecipes(RegistryEvent.Register<IRecipe> event) {
        ModContent.setUpSeedRecipes("ancient", new ItemStack(TreeAncient.saplingBlock, 1, 0));
    }

    public static void setUpSeedRecipes(String name, ItemStack treeSapling) {
        Species treeSpecies = TreeRegistry.findSpecies((ResourceLocation)new ResourceLocation("dynamictreesnaturesaura", name));
        ItemStack treeSeed = treeSpecies.getSeedStack(1);
        ItemStack treeTransformationPotion = ModItems.dendroPotion.setTargetTree(new ItemStack((Item)ModItems.dendroPotion, 1, DendroPotion.DendroPotionType.TRANSFORM.getIndex()), treeSpecies.getFamily());
        BrewingRecipeRegistry.addRecipe((ItemStack)new ItemStack((Item)ModItems.dendroPotion, 1, DendroPotion.DendroPotionType.TRANSFORM.getIndex()), (ItemStack)treeSeed, (ItemStack)treeTransformationPotion);
        ModRecipes.createDirtBucketExchangeRecipes((ItemStack)treeSapling, (ItemStack)treeSeed, (boolean)true);
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void registerModels(ModelRegistryEvent event) {
        for (TreeFamily tree : trees) {
            ModelHelper.regModel((Block)tree.getDynamicBranch());
            ModelHelper.regModel((Item)tree.getCommonSpecies().getSeed());
            ModelHelper.regModel((TreeFamily)tree);
        }
        LeavesPaging.getLeavesMapForModId((String)"dynamictreesnaturesaura").forEach((key, leaves) -> ModelLoader.setCustomStateMapper((Block)leaves, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockLeaves.field_176237_a}).func_178441_a()));
    }

    static {
        leaves = new ArrayList<BlockDynamicLeaves>();
        trees = new ArrayList();
    }
}

