/*
 * Decompiled with CFR 0.152.
 */
package yalter.mousetweaks.forge;

import com.google.common.base.MoreObjects;
import java.util.EnumSet;
import org.lwjgl.input.Mouse;
import yalter.mousetweaks.IMouseState;
import yalter.mousetweaks.MouseButton;

public class ForgeMouseState
implements IMouseState {
    private final EnumSet<MouseButton> pressedButtons = EnumSet.noneOf(MouseButton.class);
    private int scrollAmount = 0;
    public boolean simpleScrolling = false;

    @Override
    public void update() {
        MouseButton eventButton = ForgeMouseState.getEventButton();
        if (eventButton != null) {
            if (Mouse.getEventButtonState()) {
                this.pressedButtons.add(eventButton);
            } else {
                this.pressedButtons.remove((Object)eventButton);
            }
        } else {
            this.scrollAmount += Mouse.getEventDWheel();
        }
        this.pressedButtons.removeIf(mouseButton -> !Mouse.isButtonDown((int)mouseButton.getValue()));
    }

    private static MouseButton getEventButton() {
        int eventButton = Mouse.getEventButton();
        if (eventButton == 0) {
            return MouseButton.LEFT;
        }
        if (eventButton == 1) {
            return MouseButton.RIGHT;
        }
        return null;
    }

    @Override
    public void clear() {
        this.pressedButtons.clear();
        this.scrollAmount = 0;
    }

    @Override
    public boolean isButtonPressed(MouseButton mouseButton) {
        return this.pressedButtons.contains((Object)mouseButton);
    }

    @Override
    public int consumeScrollAmount() {
        int scrollAmount = this.scrollAmount;
        this.scrollAmount = 0;
        if (this.simpleScrolling) {
            return Mouse.getDWheel();
        }
        return scrollAmount;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("pressedButtons", (Object)this.pressedButtons.toArray()).add("scrollAmount", this.scrollAmount).toString();
    }
}

