/*
 * Decompiled with CFR 0.152.
 */
package com.arcaneware.unifier;

import com.arcaneware.unifier.config.Config;
import com.arcaneware.unifier.shared.SharedProxy;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.oredict.OreDictionary;

@Mod(modid="unifier", name="Unifier", version="3.0.4", dependencies="required-after:forge@[14.23.5.2784,]", acceptedMinecraftVersions="[1.12.2]", acceptableRemoteVersions="*")
public class OreUnifier {
    @Mod.Instance
    public static OreUnifier instance;
    @SidedProxy(serverSide="com.arcaneware.unifier.server.ServerProxy", clientSide="com.arcaneware.unifier.client.ClientProxy")
    public static SharedProxy sharedProxy;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent e) {
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)this);
        sharedProxy.preInit(e);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent e) {
        sharedProxy.init(e);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent e) {
        sharedProxy.postInit(e);
    }

    @Mod.EventHandler
    public void serverLoad(FMLServerStartingEvent e) {
        sharedProxy.serverLoad(e);
    }

    @Mod.EventHandler
    public void serverStop(FMLServerStoppingEvent e) {
        sharedProxy.serverStop(e);
    }

    @SubscribeEvent
    public void onItemToss(ItemTossEvent event) {
        sharedProxy.onItemToss(event);
    }

    @SubscribeEvent
    public void onItemPickup(EntityItemPickupEvent event) {
        sharedProxy.onItemPickup(event);
    }

    @SubscribeEvent
    public void inInventory(PlayerContainerEvent event) {
        sharedProxy.inInventory(event);
    }

    @SubscribeEvent
    public void onLivingDrops(LivingDropsEvent event) {
        sharedProxy.onLivingDrops(event);
    }

    @SubscribeEvent
    public void onBlockHarvest(BlockEvent.HarvestDropsEvent event) {
        sharedProxy.onBlockHarvest(event);
    }

    @SubscribeEvent
    public void onChunkLoad(ChunkEvent.Load event) {
        sharedProxy.onChunkLoad(event);
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        sharedProxy.onWorldTick(event);
    }

    private static boolean oreIdAllowed(String id) {
        String[] disIds = Config.instance().disallowedIds;
        for (int i = 0; i < disIds.length; ++i) {
            if (!id.equals(disIds[i])) continue;
            return false;
        }
        return true;
    }

    private static boolean oreNameAllowed(String oreName) {
        String[] disNames = Config.instance().disallowedNames;
        for (int i = 0; i < disNames.length; ++i) {
            if (!oreName.equals(disNames[i])) continue;
            return false;
        }
        return true;
    }

    private static boolean orePrefixAllowed(String oreName) {
        String[] allowPref = Config.instance().allowedPrefixes;
        for (int i = 0; i < allowPref.length; ++i) {
            if (!oreName.startsWith(allowPref[i])) continue;
            return true;
        }
        return false;
    }

    public static ItemStack unifiedStack(ItemStack originStack, ItemStack destinationStack) {
        String itemName = ((ResourceLocation)Item.field_150901_e.func_177774_c((Object)destinationStack.func_77973_b())).toString();
        if (!OreUnifier.sameMod(originStack, destinationStack) && OreUnifier.oreIdAllowed(itemName)) {
            ItemStack copy = destinationStack.func_77946_l();
            copy.func_190920_e(originStack.func_190916_E());
            copy.func_77982_d(originStack.func_77978_p());
            return copy;
        }
        return originStack;
    }

    public static ItemStack unify(ItemStack par1ItemStack) {
        if (par1ItemStack == null || par1ItemStack.func_77973_b() == null || par1ItemStack.func_190926_b()) {
            return par1ItemStack;
        }
        String itemName = ((ResourceLocation)Item.field_150901_e.func_177774_c((Object)par1ItemStack.func_77973_b())).toString();
        try {
            if (!OreUnifier.oreIdAllowed(itemName)) {
                return par1ItemStack;
            }
            int[] oreIds = OreDictionary.getOreIDs((ItemStack)par1ItemStack);
            if (oreIds.length < 1) {
                return par1ItemStack;
            }
            int oreId = -1;
            boolean checkPriority = true;
            for (int i = 0; i < oreIds.length; ++i) {
                String oreName = OreDictionary.getOreName((int)oreIds[i]);
                if (!OreUnifier.oreNameAllowed(oreName) || !OreUnifier.orePrefixAllowed(oreName)) continue;
                if (checkPriority) {
                    ItemStack priorityStack = OreUnifier.unifyPriorityStack(par1ItemStack, oreIds[i]);
                    if (priorityStack != null) {
                        return priorityStack;
                    }
                    if (i != oreIds.length - 1) continue;
                    i = 0;
                    checkPriority = false;
                    continue;
                }
                if (oreId != -1) continue;
                oreId = oreIds[i];
            }
            if (oreId != -1) {
                CopyOnWriteArrayList oresIter = new CopyOnWriteArrayList(OreDictionary.getOres((String)OreDictionary.getOreName((int)oreId)));
                if (oresIter.size() > 0) {
                    return OreUnifier.unifiedStack(par1ItemStack, (ItemStack)oresIter.get(0));
                }
                return par1ItemStack;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return par1ItemStack;
    }

    public static ItemStack unifyPriorityStack(ItemStack origin, int oreId) {
        CopyOnWriteArrayList oresIter = new CopyOnWriteArrayList(OreDictionary.getOres((String)OreDictionary.getOreName((int)oreId)));
        String[] priorityMods = Config.instance().priorityModIds;
        for (int i = 0; i < priorityMods.length; ++i) {
            for (ItemStack stack : oresIter) {
                String stackMod = OreUnifier.modName(stack);
                if (stackMod == null || !stackMod.equalsIgnoreCase(priorityMods[i])) continue;
                return OreUnifier.unifiedStack(origin, stack);
            }
        }
        return null;
    }

    public static void condense(IInventory inv, int offset, ItemStack stack, int stackSlot) {
        if (inv != null && stack != null) {
            for (int i = offset; i < stackSlot; ++i) {
                ItemStack slotStack = inv.func_70301_a(i);
                if (slotStack == null || !slotStack.func_77969_a(stack)) continue;
                int maxStack = Math.max(inv.func_70297_j_(), stack.func_77976_d());
                if (slotStack.func_190916_E() >= maxStack) continue;
                if (slotStack.func_190916_E() + stack.func_190916_E() > maxStack) {
                    stack.func_190920_e(stack.func_190916_E() - (maxStack - slotStack.func_190916_E()));
                    slotStack.func_190920_e(maxStack);
                } else if (slotStack.func_190916_E() + stack.func_190916_E() <= maxStack) {
                    slotStack.func_190920_e(slotStack.func_190916_E() + stack.func_190916_E());
                    stack.func_190920_e(0);
                }
                inv.func_70299_a(i, slotStack);
                if (stack.func_190916_E() > 0) {
                    inv.func_70299_a(stackSlot, stack);
                    continue;
                }
                inv.func_70304_b(stackSlot);
            }
        }
    }

    private static boolean sameMod(ItemStack originStack, ItemStack destinationStack) {
        String destMod = OreUnifier.modName(destinationStack);
        String originMod = OreUnifier.modName(originStack);
        return destMod != null && originMod != null && originMod.equalsIgnoreCase(destMod);
    }

    private static String modName(ItemStack stack) {
        String stackMod = ((ResourceLocation)Item.field_150901_e.func_177774_c((Object)stack.func_77973_b())).toString();
        if (stackMod != null) {
            stackMod = stackMod.substring(0, stackMod.indexOf(":"));
            return stackMod;
        }
        return null;
    }
}

