/*
 * Decompiled with CFR 0.152.
 */
package dynamictreestc.worldgen;

import com.ferreusveritas.dynamictrees.api.TreeRegistry;
import com.ferreusveritas.dynamictrees.api.worldgen.BiomePropertySelectors;
import com.ferreusveritas.dynamictrees.api.worldgen.IBiomeDataBasePopulator;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.worldgen.BiomeDataBase;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import thaumcraft.common.world.biomes.BiomeHandler;

public class BiomeDataBasePopulator
implements IBiomeDataBasePopulator {
    private static Species greatwood;
    private static Species silverwood;
    private static Species oakMagic;

    private static void createStaticAliases() {
        greatwood = TreeRegistry.findSpecies((ResourceLocation)new ResourceLocation("dynamictreestc", "greatwood"));
        silverwood = TreeRegistry.findSpecies((ResourceLocation)new ResourceLocation("dynamictreestc", "silverwood"));
        oakMagic = TreeRegistry.findSpecies((ResourceLocation)new ResourceLocation("dynamictreestc", "oakmagic"));
    }

    public void populate(BiomeDataBase dbase) {
        if (greatwood == null) {
            BiomeDataBasePopulator.createStaticAliases();
        }
        Biome.field_185377_q.forEach(biome -> {
            int biomeId = Biome.func_185362_a((Biome)biome);
            float greatwoodChance = BiomeHandler.getBiomeSupportsGreatwood((int)biomeId);
            if (biome != BiomeHandler.MAGICAL_FOREST && biome != BiomeHandler.ELDRITCH) {
                BiomePropertySelectors.RandomSpeciesSelector selector = new BiomePropertySelectors.RandomSpeciesSelector().add(640);
                boolean flag = false;
                if (greatwoodChance > 0.0f) {
                    selector.add(greatwood, 3).add(silverwood, 1);
                    flag = true;
                } else if (biomeId == 18 || biomeId == 28) {
                    selector.add(silverwood, 1);
                    flag = true;
                }
                if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.NETHER)) {
                    flag = false;
                }
                if (flag) {
                    dbase.setSpeciesSelector(biome, (BiomePropertySelectors.ISpeciesSelector)selector, BiomeDataBase.Operation.SPLICE_BEFORE);
                    dbase.setChanceSelector(biome, (rand, species, radius) -> {
                        if ((species == greatwood || species == silverwood) && radius < 3) {
                            return BiomePropertySelectors.EnumChance.CANCEL;
                        }
                        return BiomePropertySelectors.EnumChance.UNHANDLED;
                    }, BiomeDataBase.Operation.SPLICE_BEFORE);
                }
            }
        });
        dbase.setSpeciesSelector(BiomeHandler.MAGICAL_FOREST, (BiomePropertySelectors.ISpeciesSelector)new BiomePropertySelectors.RandomSpeciesSelector().add(oakMagic, 40).add(greatwood, 19).add(silverwood, 1), BiomeDataBase.Operation.REPLACE);
        dbase.setDensitySelector(BiomeHandler.MAGICAL_FOREST, (rand, noiseDensity) -> (noiseDensity * 0.25 + 0.75) * 0.5, BiomeDataBase.Operation.REPLACE);
        dbase.setChanceSelector(BiomeHandler.MAGICAL_FOREST, (rand, species, radius) -> {
            if (radius >= 3) {
                float chance = 2.0f / (float)radius;
                return (double)rand.nextFloat() < Math.sqrt(chance) * 1.125 + 0.25 ? BiomePropertySelectors.EnumChance.OK : BiomePropertySelectors.EnumChance.CANCEL;
            }
            return BiomePropertySelectors.EnumChance.CANCEL;
        }, BiomeDataBase.Operation.REPLACE);
        dbase.setCancelVanillaTreeGen(BiomeHandler.MAGICAL_FOREST, true);
    }
}

