/*
 * Decompiled with CFR 0.152.
 */
package dynamictreestc.trees;

import com.ferreusveritas.dynamictrees.api.IGenFeature;
import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.treedata.IDropCreator;
import com.ferreusveritas.dynamictrees.blocks.BlockBranch;
import com.ferreusveritas.dynamictrees.blocks.BlockBranchThick;
import com.ferreusveritas.dynamictrees.blocks.BlockSurfaceRoot;
import com.ferreusveritas.dynamictrees.systems.GrowSignal;
import com.ferreusveritas.dynamictrees.systems.dropcreators.DropCreatorSeed;
import com.ferreusveritas.dynamictrees.systems.featuregen.FeatureGenClearVolume;
import com.ferreusveritas.dynamictrees.systems.featuregen.FeatureGenFlareBottom;
import com.ferreusveritas.dynamictrees.systems.featuregen.FeatureGenMound;
import com.ferreusveritas.dynamictrees.systems.featuregen.FeatureGenRoots;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.trees.TreeFamily;
import dynamictreestc.ModContent;
import dynamictreestc.featuregen.FeatureGenShimmerleaf;
import java.util.List;
import java.util.Random;
import java.util.function.BiFunction;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.BlockGrass;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import thaumcraft.api.blocks.BlocksTC;
import thaumcraft.common.world.biomes.BiomeHandler;

public class TreeSilverwood
extends TreeFamily {
    BlockSurfaceRoot surfaceRootBlock;

    public TreeSilverwood() {
        super(new ResourceLocation("dynamictreestc", "silverwood"));
        IBlockState primLog = BlocksTC.logSilverwood.func_176223_P();
        this.setPrimitiveLog(primLog, new ItemStack(BlocksTC.logSilverwood));
        ModContent.silverwoodLeavesProperties.setTree((TreeFamily)this);
        this.surfaceRootBlock = new BlockSurfaceRoot(Material.field_151575_d, this.getName() + "root");
        this.addConnectableVanillaLeaves(state -> state.func_177230_c() == BlocksTC.leafSilverwood);
    }

    public void createSpecies() {
        this.setCommonSpecies(new SpeciesSilverwood(this));
    }

    public boolean isThick() {
        return true;
    }

    public BlockSurfaceRoot getSurfaceRoots() {
        return this.surfaceRootBlock;
    }

    public List<Block> getRegisterableBlocks(List<Block> blockList) {
        blockList.add((Block)this.surfaceRootBlock);
        return super.getRegisterableBlocks(blockList);
    }

    public BlockBranch createBranch() {
        String branchName = this.getName() + "branch";
        BlockBranchThick branch = new BlockBranchThick(branchName);
        branch.func_149715_a(0.3125f);
        branch.otherBlock.func_149715_a(0.3125f);
        return branch;
    }

    public class SpeciesSilverwood
    extends Species {
        SpeciesSilverwood(TreeFamily treeFamily) {
            super(treeFamily.getName(), treeFamily, ModContent.silverwoodLeavesProperties);
            this.setBasicGrowingParameters(1.15f, 12.0f, 6, 4, 0.75f);
            this.envFactor(BiomeDictionary.Type.COLD, 0.75f);
            this.envFactor(BiomeDictionary.Type.HOT, 0.75f);
            this.envFactor(BiomeDictionary.Type.DRY, 0.5f);
            this.envFactor(BiomeDictionary.Type.FOREST, 1.05f);
            this.envFactor(BiomeDictionary.Type.MAGICAL, 1.1f);
            this.generateSeed();
            this.addDropCreator((IDropCreator)new DropCreatorSeed(0.25f){

                public List<ItemStack> getHarvestDrop(World world, Species species, BlockPos leafPos, Random random, List<ItemStack> dropList, int soilLife, int fortune) {
                    int chance = 176;
                    if (fortune > 0 && (chance -= 2 << fortune) < 10) {
                        chance = 10;
                    }
                    if (random.nextInt(chance) == 0) {
                        dropList.add(species.getSeedStack(1));
                    }
                    return dropList;
                }

                public List<ItemStack> getLeavesDrop(IBlockAccess access, Species species, BlockPos breakPos, Random random, List<ItemStack> dropList, int fortune) {
                    int chance = 88;
                    if (fortune > 0 && (chance -= 2 << fortune) < 10) {
                        chance = 10;
                    }
                    if (random.nextInt(chance) == 0) {
                        dropList.add(species.getSeedStack(1));
                    }
                    return dropList;
                }
            });
            this.addGenFeature((IGenFeature)new FeatureGenClearVolume(6));
            this.addGenFeature((IGenFeature)new FeatureGenFlareBottom());
            this.addGenFeature((IGenFeature)new FeatureGenMound(5));
            this.addGenFeature((IGenFeature)new FeatureGenShimmerleaf());
            this.addGenFeature((IGenFeature)new FeatureGenRoots(13).setScaler(this.getRootScaler()));
        }

        public boolean isBiomePerfect(Biome biome) {
            return SpeciesSilverwood.isOneOfBiomes((Biome)biome, (Biome[])new Biome[]{BiomeHandler.MAGICAL_FOREST});
        }

        public boolean isAcceptableSoil(World world, BlockPos pos, IBlockState soilBlockState) {
            return super.isAcceptableSoil(world, pos, soilBlockState) || soilBlockState.func_177230_c() instanceof BlockDirt || soilBlockState.func_177230_c() instanceof BlockGrass;
        }

        protected EnumFacing newDirectionSelected(EnumFacing newDir, GrowSignal signal) {
            if (signal.isInTrunk() && newDir != EnumFacing.UP) {
                signal.energy *= 0.3f;
                if (signal.energy > 3.0f) {
                    signal.energy = 3.0f;
                }
            }
            return newDir;
        }

        protected BiFunction<Integer, Integer, Integer> getRootScaler() {
            return (inRadius, trunkRadius) -> {
                float scale = MathHelper.func_76131_a((float)(trunkRadius >= 13 ? (float)trunkRadius.intValue() / 24.0f : 0.0f), (float)0.0f, (float)1.0f);
                return (int)((float)inRadius.intValue() * scale);
            };
        }

        public boolean rot(World world, BlockPos pos, int neighborCount, int radius, Random random, boolean rapid) {
            if (super.rot(world, pos, neighborCount, radius, random, rapid)) {
                if (radius > 4 && TreeHelper.isRooty((IBlockState)world.func_180495_p(pos.func_177977_b())) && world.func_175642_b(EnumSkyBlock.SKY, pos) < 4) {
                    world.func_175656_a(pos, BlocksTC.vishroom.func_176223_P());
                }
                return true;
            }
            return false;
        }

        public boolean isThick() {
            return true;
        }
    }
}

