/*
 * Decompiled with CFR 0.152.
 */
package dynamictreestc.proxy;

import com.ferreusveritas.dynamictrees.api.TreeRegistry;
import com.ferreusveritas.dynamictrees.api.WorldGenRegistry;
import com.ferreusveritas.dynamictrees.api.treedata.IDropCreator;
import com.ferreusveritas.dynamictrees.trees.Species;
import dynamictreestc.dropcreators.DropCreatorFruit;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.registry.GameRegistry;
import thaumcraft.api.blocks.BlocksTC;
import thaumcraft.api.items.ItemsTC;
import thaumcraft.common.config.ModConfig;
import thaumcraft.common.world.ThaumcraftWorldGenerator;
import thaumcraft.common.world.biomes.BiomeHandler;

public class CommonProxy {
    public void preInit() {
        if (WorldGenRegistry.isWorldGenEnabled()) {
            GameRegistry.registerWorldGenerator((IWorldGenerator)new IWorldGenerator(){

                public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
                    int blacklist = BiomeHandler.getDimBlacklist((int)world.field_73011_w.getDimension());
                    if (blacklist == -1 && !world.func_72912_H().func_76067_t().func_77127_a().startsWith("flat")) {
                        Biome bgb = world.func_180494_b(new BlockPos(chunkX * 16 + 8, 50, chunkZ * 16 + 8));
                        if (BiomeHandler.getBiomeBlacklist((int)Biome.func_185362_a((Biome)bgb)) != -1) {
                            return;
                        }
                        int randPosX = chunkX * 16 + 8;
                        int randPosZ = chunkZ * 16 + 8;
                        BlockPos bp = world.func_175645_m(new BlockPos(randPosX, 0, randPosZ));
                        if (world.func_180494_b((BlockPos)bp).field_76752_A.func_177230_c() == Blocks.field_150354_m && world.func_180494_b(bp).func_180626_a(bp) > 1.0f && random.nextInt(30) == 0) {
                            ThaumcraftWorldGenerator.generateFlowers((World)world, (Random)random, (BlockPos)bp, (Block)BlocksTC.cinderpearl, (int)0);
                        }
                    }
                }
            }, (int)0);
            ModConfig.CONFIG_WORLD.generateTrees = false;
            ModConfig.CONFIG_WORLD.regenTrees = false;
        }
    }

    public void init() {
        Species silverwood = TreeRegistry.findSpecies((ResourceLocation)new ResourceLocation("dynamictreestc", "silverwood"));
        silverwood.addDropCreator((IDropCreator)new DropCreatorFruit(new ItemStack(ItemsTC.nuggets, 1, 5)).setRarity(0.75f));
        Species oakMagic = TreeRegistry.findSpecies((ResourceLocation)new ResourceLocation("dynamictreestc", "oakmagic"));
        TreeRegistry.findSpecies((ResourceLocation)new ResourceLocation("dynamictrees", "oak")).getFamily().addSpeciesLocationOverride((access, trunkPos) -> {
            if (access.func_180494_b(trunkPos) == BiomeHandler.MAGICAL_FOREST) {
                return oakMagic;
            }
            return Species.NULLSPECIES;
        });
    }

    public void postInit() {
    }
}

