/*
 * Decompiled with CFR 0.152.
 */
package dynamictreestc.featuregen;

import com.ferreusveritas.dynamictrees.api.IPostGenFeature;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.util.CoordUtils;
import com.ferreusveritas.dynamictrees.util.SafeChunkBounds;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;

public class FeatureGenWeb
implements IPostGenFeature {
    protected float verSpread = 60.0f;
    protected float rayDistance = 4.0f;
    protected Species species;
    protected Block webBlock = Blocks.field_150321_G;

    public FeatureGenWeb(Species species) {
        this.species = species;
    }

    public FeatureGenWeb setVerSpread(float verSpread) {
        this.verSpread = verSpread;
        return this;
    }

    public FeatureGenWeb setRayDistance(float rayDistance) {
        this.rayDistance = rayDistance;
        return this;
    }

    public boolean postGeneration(World world, BlockPos rootPos, Species species, Biome biome, int radius, List<BlockPos> endPoints, SafeChunkBounds safeBounds, IBlockState initialDirtState) {
        if (!endPoints.isEmpty()) {
            int qty = (int)((float)endPoints.size() * (world.field_73012_v.nextFloat() * 0.5f + 0.75f));
            for (int i = 0; i < qty; ++i) {
                BlockPos endPoint = endPoints.get(world.field_73012_v.nextInt(endPoints.size()));
                this.addWeb(world, species, rootPos, endPoint, safeBounds);
            }
            return true;
        }
        return false;
    }

    protected void addWeb(World world, Species species, BlockPos treePos, BlockPos branchPos, SafeChunkBounds safeBounds) {
        BlockPos webPos;
        RayTraceResult result = CoordUtils.branchRayTrace((World)world, (Species)species, (BlockPos)treePos, (BlockPos)branchPos, (float)90.0f, (float)this.verSpread, (float)this.rayDistance, (SafeChunkBounds)safeBounds);
        if (result != null && (webPos = result.func_178782_a().func_177972_a(result.field_178784_b)) != BlockPos.field_177992_a && world.func_175623_d(webPos)) {
            world.func_175656_a(webPos, this.webBlock.func_176223_P());
        }
    }
}

