/*
 * Decompiled with CFR 0.152.
 */
package dynamictreestc.featuregen;

import com.ferreusveritas.dynamictrees.api.IPostGenFeature;
import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.util.SafeChunkBounds;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import thaumcraft.api.blocks.BlocksTC;
import thaumcraft.common.world.biomes.BiomeHandler;

public class FeatureGenVishroom
implements IPostGenFeature {
    protected int maxAttempts = 1;
    protected int chance = 6;

    public FeatureGenVishroom setMaxAttempts(int max) {
        this.maxAttempts = max;
        return this;
    }

    public FeatureGenVishroom setChance(int chance) {
        this.chance = chance;
        return this;
    }

    public boolean postGeneration(World world, BlockPos rootPos, Species species, Biome biome, int radius, List<BlockPos> endPoints, SafeChunkBounds safeBounds, IBlockState initialDirtState) {
        boolean worldGen;
        boolean bl = worldGen = safeBounds != SafeChunkBounds.ANY;
        if (worldGen && biome == BiomeHandler.MAGICAL_FOREST && world.field_73012_v.nextInt(this.chance) == 0) {
            for (int i = 0; i < this.maxAttempts; ++i) {
                if (!this.placeVishroom(world, rootPos)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean placeVishroom(World world, BlockPos rootPos) {
        BlockPos treePos = rootPos.func_177984_a();
        int trunkRadius = TreeHelper.getRadius((IBlockAccess)world, (BlockPos)treePos);
        EnumFacing dir = EnumFacing.field_176754_o[world.field_73012_v.nextInt(4)];
        BlockPos pos = rootPos.func_177967_a(dir, trunkRadius > 8 ? 2 : 1);
        if (world.field_73012_v.nextInt(2) == 0) {
            pos = pos.func_177972_a(world.field_73012_v.nextBoolean() ? dir.func_176746_e() : dir.func_176735_f());
        }
        for (int i = 0; i < 3; ++i) {
            if (BlocksTC.vishroom.func_176196_c(world, pos)) {
                world.func_175656_a(pos, BlocksTC.vishroom.func_176223_P());
                return true;
            }
            pos = pos.func_177984_a();
        }
        return false;
    }
}

