/*
 * Decompiled with CFR 0.152.
 */
package dynamictreestc;

import com.ferreusveritas.dynamictrees.ModItems;
import com.ferreusveritas.dynamictrees.ModRecipes;
import com.ferreusveritas.dynamictrees.api.TreeRegistry;
import com.ferreusveritas.dynamictrees.api.WorldGenRegistry;
import com.ferreusveritas.dynamictrees.api.client.ModelHelper;
import com.ferreusveritas.dynamictrees.api.treedata.ILeavesProperties;
import com.ferreusveritas.dynamictrees.api.worldgen.IBiomeDataBasePopulator;
import com.ferreusveritas.dynamictrees.blocks.LeavesPaging;
import com.ferreusveritas.dynamictrees.blocks.LeavesProperties;
import com.ferreusveritas.dynamictrees.items.DendroPotion;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.trees.TreeFamily;
import dynamictreestc.blocks.BlockDynamicLeavesSilverwood;
import dynamictreestc.trees.TreeGreatwood;
import dynamictreestc.trees.TreeSilverwood;
import dynamictreestc.trees.species.SpeciesOakMagic;
import dynamictreestc.worldgen.BiomeDataBasePopulator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMap;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import thaumcraft.api.blocks.BlocksTC;

@Mod.EventBusSubscriber(modid="dynamictreestc")
@GameRegistry.ObjectHolder(value="dynamictreestc")
public class ModContent {
    public static BlockDynamicLeavesSilverwood silverwoodLeaves;
    public static ILeavesProperties greatwoodLeavesProperties;
    public static ILeavesProperties silverwoodLeavesProperties;
    public static ArrayList<TreeFamily> trees;

    @SubscribeEvent
    public static void registerDataBasePopulators(WorldGenRegistry.BiomeDataBasePopulatorRegistryEvent event) {
        event.register((IBiomeDataBasePopulator)new BiomeDataBasePopulator());
    }

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        IForgeRegistry registry = event.getRegistry();
        silverwoodLeaves = new BlockDynamicLeavesSilverwood();
        registry.register((IForgeRegistryEntry)silverwoodLeaves);
        greatwoodLeavesProperties = new LeavesProperties(BlocksTC.leafGreatwood.func_176223_P(), new ItemStack(BlocksTC.leafGreatwood), TreeRegistry.findCellKit((String)"deciduous")){

            public int getSmotherLeavesMax() {
                return 7;
            }

            public int getLightRequirement() {
                return 13;
            }
        };
        silverwoodLeavesProperties = new LeavesProperties(BlocksTC.leafSilverwood.func_176223_P(), new ItemStack(BlocksTC.leafSilverwood), TreeRegistry.findCellKit((String)"deciduous")){

            public int getSmotherLeavesMax() {
                return 8;
            }

            public int getLightRequirement() {
                return 13;
            }

            public int foliageColorMultiplier(IBlockState state, IBlockAccess world, BlockPos pos) {
                return 0xFFFFFF;
            }
        };
        LeavesPaging.getLeavesBlockForSequence((String)"dynamictreestc", (int)0, (ILeavesProperties)greatwoodLeavesProperties);
        silverwoodLeavesProperties.setDynamicLeavesState(silverwoodLeaves.func_176223_P());
        silverwoodLeaves.setProperties(0, silverwoodLeavesProperties);
        TreeFamily oakTree = TreeRegistry.findSpecies((ResourceLocation)new ResourceLocation("dynamictrees", "oak")).getFamily();
        Species.REGISTRY.register((IForgeRegistryEntry)new SpeciesOakMagic(oakTree));
        TreeGreatwood greatwoodTree = new TreeGreatwood();
        TreeSilverwood silverwoodTree = new TreeSilverwood();
        Collections.addAll(trees, new TreeFamily[]{greatwoodTree, silverwoodTree});
        trees.forEach(tree -> tree.registerSpecies(Species.REGISTRY));
        ArrayList treeBlocks = new ArrayList();
        trees.forEach(tree -> tree.getRegisterableBlocks((List)treeBlocks));
        treeBlocks.addAll(LeavesPaging.getLeavesMapForModId((String)"dynamictreestc").values());
        registry.registerAll((IForgeRegistryEntry[])treeBlocks.toArray(new Block[treeBlocks.size()]));
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        IForgeRegistry registry = event.getRegistry();
        ArrayList treeItems = new ArrayList();
        trees.forEach(tree -> tree.getRegisterableItems((List)treeItems));
        registry.registerAll((IForgeRegistryEntry[])treeItems.toArray(new Item[treeItems.size()]));
    }

    @SubscribeEvent
    public static void registerRecipes(RegistryEvent.Register<IRecipe> event) {
        Species greatwood = TreeRegistry.findSpecies((ResourceLocation)new ResourceLocation("dynamictreestc", "greatwood"));
        Species silverwood = TreeRegistry.findSpecies((ResourceLocation)new ResourceLocation("dynamictreestc", "silverwood"));
        ItemStack greatwoodSeed = greatwood.getSeedStack(1);
        ItemStack silverwoodSeed = silverwood.getSeedStack(1);
        ItemStack greatwoodTransformationPotion = ModItems.dendroPotion.setTargetTree(new ItemStack((Item)ModItems.dendroPotion, 1, DendroPotion.DendroPotionType.TRANSFORM.getIndex()), greatwood.getFamily());
        ItemStack silverwoodTransformationPotion = ModItems.dendroPotion.setTargetTree(new ItemStack((Item)ModItems.dendroPotion, 1, DendroPotion.DendroPotionType.TRANSFORM.getIndex()), silverwood.getFamily());
        BrewingRecipeRegistry.addRecipe((ItemStack)new ItemStack((Item)ModItems.dendroPotion, 1, DendroPotion.DendroPotionType.TRANSFORM.getIndex()), (ItemStack)greatwoodSeed, (ItemStack)greatwoodTransformationPotion);
        BrewingRecipeRegistry.addRecipe((ItemStack)new ItemStack((Item)ModItems.dendroPotion, 1, DendroPotion.DendroPotionType.TRANSFORM.getIndex()), (ItemStack)silverwoodSeed, (ItemStack)silverwoodTransformationPotion);
        ModRecipes.createDirtBucketExchangeRecipes((ItemStack)new ItemStack(BlocksTC.saplingGreatwood), (ItemStack)greatwoodSeed, (boolean)true);
        ModRecipes.createDirtBucketExchangeRecipes((ItemStack)new ItemStack(BlocksTC.saplingSilverwood), (ItemStack)silverwoodSeed, (boolean)true);
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void registerModels(ModelRegistryEvent event) {
        for (TreeFamily tree : trees) {
            ModelHelper.regModel((Block)tree.getDynamicBranch());
            ModelHelper.regModel((Item)tree.getCommonSpecies().getSeed());
            ModelHelper.regModel((TreeFamily)tree);
        }
        LeavesPaging.getLeavesMapForModId((String)"dynamictreestc").forEach((key, leaves) -> ModelLoader.setCustomStateMapper((Block)leaves, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockLeaves.field_176237_a}).func_178441_a()));
        ModelLoader.setCustomStateMapper((Block)silverwoodLeaves, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockLeaves.field_176237_a}).func_178441_a());
    }

    static {
        trees = new ArrayList();
    }
}

