/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.client.sound;

import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.util.SoundCategory;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import org.orecruncher.dsurround.ModBase;
import org.orecruncher.dsurround.client.handlers.EnvironStateHandler;
import org.orecruncher.dsurround.client.sound.ConfigSoundInstance;
import org.orecruncher.dsurround.client.sound.SoundEngine;
import org.orecruncher.lib.math.MathStuff;

@Mod.EventBusSubscriber(value={Side.CLIENT}, modid="dsurround")
public final class MusicFader {
    private static final float MIN_VOLUME_SCALE = 0.001f;
    private static final float FADE_AMOUNT = 0.02f;
    private static float currentScale = 1.0f;
    private static ConfigSoundInstance playingConfigSound;

    public static float getMusicScaling() {
        return currentScale;
    }

    @SubscribeEvent
    public static void onTick(@Nonnull TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            return;
        }
        float oldScale = currentScale;
        if (playingConfigSound != null && playingConfigSound.isDonePlaying()) {
            MusicFader.stopConfigSound(playingConfigSound);
        }
        if (playingConfigSound == null) {
            currentScale = EnvironStateHandler.EnvironState.getBattleScanner().inBattle() ? (currentScale -= 0.04f) : (currentScale += 0.02f);
        }
        if (Float.compare(oldScale, currentScale = MathStuff.clamp((float)currentScale, (float)0.001f, (float)1.0f)) != 0) {
            float mcScale = Minecraft.func_71410_x().field_71474_y.func_186711_a(SoundCategory.MUSIC);
            SoundEngine.instance().getSoundManager().func_188771_a(SoundCategory.MUSIC, mcScale);
        }
    }

    public static void playConfigSound(@Nonnull ConfigSoundInstance sound2) {
        if (sound2 != null) {
            SoundEngine.instance().stopAllSounds();
            currentScale = 0.001f;
            playingConfigSound = sound2;
            SoundEngine.instance().playSound(sound2);
        }
    }

    public static void stopConfigSound(@Nonnull ConfigSoundInstance sound2) {
        if (playingConfigSound != null) {
            if (playingConfigSound != sound2) {
                ModBase.log().warn("Inconsistent sound in MusicFader", new Object[0]);
            }
            SoundEngine.instance().stopSound(playingConfigSound);
            playingConfigSound = null;
        }
    }
}

