/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.spell;

import electroblob.wizardry.data.IStoredVariable;
import electroblob.wizardry.data.Persistence;
import electroblob.wizardry.data.WizardData;
import electroblob.wizardry.entity.living.EntitySpiritWolf;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.SpellModifiers;
import electroblob.wizardry.util.WizardryUtilities;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class SummonSpiritWolf
extends Spell {
    private static final String POTENCY_ATTRIBUTE_MODIFIER = "potency";
    public static final IStoredVariable<UUID> UUID_KEY = IStoredVariable.StoredVariable.ofUUID("spiritWolfUUID", Persistence.ALWAYS);

    public SummonSpiritWolf() {
        super("summon_spirit_wolf", EnumAction.BOW, false);
        this.addProperties("summon_radius");
        this.soundValues(0.7f, 1.2f, 0.4f);
        WizardData.registerStoredVariables(UUID_KEY);
    }

    @Override
    public boolean requiresPacket() {
        return false;
    }

    @Override
    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        WizardData data = WizardData.get(caster);
        if (!world.field_72995_K) {
            BlockPos pos;
            Entity oldWolf = WizardryUtilities.getEntityByUUID(world, data.getVariable(UUID_KEY));
            if (oldWolf != null) {
                oldWolf.func_70106_y();
            }
            if ((pos = WizardryUtilities.findNearbyFloorSpace((Entity)caster, 2, 4)) == null) {
                return false;
            }
            EntitySpiritWolf wolf = new EntitySpiritWolf(world);
            wolf.func_70107_b((double)pos.func_177958_n() + 0.5, pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
            wolf.func_70903_f(true);
            wolf.func_184754_b(caster.func_110124_au());
            wolf.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111121_a(new AttributeModifier(POTENCY_ATTRIBUTE_MODIFIER, (double)(modifiers.get(POTENCY_ATTRIBUTE_MODIFIER) - 1.0f), 2));
            wolf.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111121_a(new AttributeModifier(POTENCY_ATTRIBUTE_MODIFIER, (double)(modifiers.amplified(POTENCY_ATTRIBUTE_MODIFIER, 1.5f) - 1.0f), 2));
            wolf.func_70606_j(wolf.func_110138_aP());
            world.func_72838_d((Entity)wolf);
            data.setVariable(UUID_KEY, wolf.func_110124_au());
        }
        this.playSound(world, (EntityLivingBase)caster, ticksInUse, -1, modifiers, new String[0]);
        return true;
    }
}

