/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.spell;

import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.AllyDesignationSystem;
import electroblob.wizardry.util.SpellModifiers;
import electroblob.wizardry.util.WizardryUtilities;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public abstract class SpellAreaEffect
extends Spell {
    protected float particleDensity = 0.65f;

    public SpellAreaEffect(String name, EnumAction action) {
        this("ebwizardry", name, action);
    }

    public SpellAreaEffect(String modID, String name, EnumAction action) {
        super(modID, name, action, false);
        this.addProperties("effect_radius");
    }

    public SpellAreaEffect particleDensity(float particleDensity) {
        this.particleDensity = particleDensity;
        return this;
    }

    @Override
    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        List<EntityLivingBase> targets = WizardryUtilities.getEntitiesWithinRadius(this.getProperty("effect_radius").floatValue() * modifiers.get(WizardryItems.blast_upgrade), caster.field_70165_t, caster.field_70163_u, caster.field_70161_v, world);
        targets.removeIf(target -> !AllyDesignationSystem.isValidTarget((Entity)caster, (Entity)target));
        for (EntityLivingBase target2 : targets) {
            this.affectEntity(world, (EntityLivingBase)caster, target2, modifiers);
        }
        if (world.field_72995_K) {
            this.spawnParticleEffect(world, (EntityLivingBase)caster, modifiers);
        }
        this.playSound(world, (EntityLivingBase)caster, ticksInUse, -1, modifiers, new String[0]);
        return true;
    }

    protected abstract void affectEntity(World var1, EntityLivingBase var2, EntityLivingBase var3, SpellModifiers var4);

    protected void spawnParticleEffect(World world, EntityLivingBase caster, SpellModifiers modifiers) {
        double maxRadius = this.getProperty("effect_radius").floatValue() * modifiers.get(WizardryItems.blast_upgrade);
        int particleCount = (int)Math.round((double)this.particleDensity * Math.PI * maxRadius * maxRadius);
        for (int i = 0; i < particleCount; ++i) {
            double radius = 1.0 + world.field_73012_v.nextDouble() * (maxRadius - 1.0);
            float angle = world.field_73012_v.nextFloat() * (float)Math.PI * 2.0f;
            this.spawnParticle(world, caster.field_70165_t + radius * (double)MathHelper.func_76134_b((float)angle), caster.func_174813_aQ().field_72338_b, caster.field_70161_v + radius * (double)MathHelper.func_76126_a((float)angle));
        }
    }

    protected void spawnParticle(World world, double x, double y, double z) {
    }
}

