/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.spell;

import electroblob.wizardry.Wizardry;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.SpellModifiers;
import electroblob.wizardry.util.WizardryUtilities;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class SpeedTime
extends Spell {
    public static final String TIME_INCREMENT = "time_increment";
    public static final String EXTRA_TICKS = "extra_ticks";

    public SpeedTime() {
        super("speed_time", EnumAction.BOW, true);
        this.addProperties("effect_radius", TIME_INCREMENT, EXTRA_TICKS);
    }

    @Override
    protected SoundEvent[] createSounds() {
        return this.createContinuousSpellSounds();
    }

    @Override
    protected void playSound(World world, EntityLivingBase entity, int ticksInUse, int duration, SpellModifiers modifiers, String ... sounds) {
        this.playSoundLoop(world, entity, ticksInUse);
    }

    @Override
    protected void playSound(World world, double x, double y, double z, int ticksInUse, int duration, SpellModifiers modifiers, String ... sounds) {
        this.playSoundLoop(world, x, y, z, ticksInUse, duration);
    }

    @Override
    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        int i;
        boolean flag = false;
        if (Wizardry.settings.worldTimeManipulation) {
            world.func_72877_b(world.func_72820_D() + (long)(this.getProperty(TIME_INCREMENT).floatValue() * modifiers.get("potency")));
            flag = true;
        }
        double radius = this.getProperty("effect_radius").floatValue() * modifiers.get(WizardryItems.blast_upgrade);
        float potencyLevel = ((modifiers.get("potency") - 1.0f) * 2.0f + 1.0f) * this.getProperty(EXTRA_TICKS).floatValue();
        ArrayList<Entity> entities = new ArrayList<Entity>(world.field_72996_f);
        entities.removeIf(e -> e instanceof EntityPlayer);
        entities.removeIf(e -> (double)caster.func_70032_d(e) > radius);
        if (!entities.isEmpty()) {
            int i2 = 0;
            while ((float)i2 < potencyLevel) {
                entities.forEach(Entity::func_70071_h_);
                ++i2;
            }
            flag = true;
        }
        ArrayList<TileEntity> tileentities = new ArrayList<TileEntity>(world.field_175730_i);
        tileentities.removeIf(t -> caster.func_174818_b(t.func_174877_v()) > radius * radius);
        if (!tileentities.isEmpty()) {
            i = 0;
            while ((float)i < potencyLevel) {
                tileentities.forEach(t -> ((ITickable)t).func_73660_a());
                ++i;
            }
            flag = true;
        }
        if (!world.field_72995_K) {
            List<BlockPos> sphere = WizardryUtilities.getBlockSphere(caster.func_180425_c(), radius);
            for (BlockPos pos : sphere) {
                if (!world.func_180495_p(pos).func_177230_c().func_149653_t()) continue;
                int i3 = 0;
                while ((float)i3 < potencyLevel) {
                    world.func_180495_p(pos).func_177230_c().func_180645_a(world, pos, world.func_180495_p(pos), world.field_73012_v);
                    flag = true;
                    ++i3;
                }
            }
        }
        if (world.field_72995_K) {
            for (i = 1; i < 3; ++i) {
                double particleSpread = 2.0;
                double x = caster.field_70165_t + 2.0;
                double y = caster.func_174813_aQ().field_72338_b + (double)(caster.field_70131_O / 2.0f);
                double z = caster.field_70161_v;
                ParticleBuilder.create(ParticleBuilder.Type.SPARKLE, world.field_73012_v, x, y, z, particleSpread, false).vel(-0.25, 0.0, 0.0).time(16).clr(1.0f, 1.0f, 1.0f).spawn(world);
                ParticleBuilder.create(ParticleBuilder.Type.FLASH, world.field_73012_v, x, y, z, particleSpread, false).vel(-0.25, 0.0, 0.0).time(16).scale(0.5f).clr(0.6f + world.field_73012_v.nextFloat() * 0.4f, 0.6f + world.field_73012_v.nextFloat() * 0.4f, 0.6f + world.field_73012_v.nextFloat() * 0.4f).spawn(world);
            }
        }
        if (flag) {
            this.playSound(world, (EntityLivingBase)caster, ticksInUse, -1, modifiers, new String[0]);
        }
        return flag;
    }
}

