/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.spell;

import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.spell.SpellBuff;
import electroblob.wizardry.util.AllyDesignationSystem;
import electroblob.wizardry.util.MagicDamage;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.SpellModifiers;
import electroblob.wizardry.util.WizardryUtilities;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.EnumAction;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.world.World;

public class PlagueOfDarkness
extends Spell {
    public PlagueOfDarkness() {
        super("plague_of_darkness", EnumAction.BOW, false);
        this.addProperties("effect_radius", "damage", "effect_duration", "effect_strength");
        this.soundValues(1.0f, 1.1f, 0.2f);
    }

    @Override
    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        double radius = this.getProperty("effect_radius").floatValue() * modifiers.get(WizardryItems.blast_upgrade);
        List<EntityLivingBase> targets = WizardryUtilities.getEntitiesWithinRadius(radius, caster.field_70165_t, caster.field_70163_u, caster.field_70161_v, world);
        for (EntityLivingBase target : targets) {
            if (!AllyDesignationSystem.isValidTarget((Entity)caster, (Entity)target) || MagicDamage.isEntityImmune(MagicDamage.DamageType.WITHER, (Entity)target)) continue;
            target.func_70097_a(MagicDamage.causeDirectMagicDamage((Entity)caster, MagicDamage.DamageType.WITHER), this.getProperty("damage").floatValue() * modifiers.get("potency"));
            target.func_70690_d(new PotionEffect(MobEffects.field_82731_v, (int)(this.getProperty("effect_duration").floatValue() * modifiers.get(WizardryItems.duration_upgrade)), this.getProperty("effect_strength").intValue() + SpellBuff.getStandardBonusAmplifier(modifiers.get("potency"))));
        }
        if (world.field_72995_K) {
            int i = 0;
            while ((float)i < 40.0f * modifiers.get(WizardryItems.blast_upgrade)) {
                double particleX = caster.field_70165_t - 1.0 + 2.0 * world.field_73012_v.nextDouble();
                double particleZ = caster.field_70161_v - 1.0 + 2.0 * world.field_73012_v.nextDouble();
                ParticleBuilder.create(ParticleBuilder.Type.DARK_MAGIC).pos(particleX, caster.func_174813_aQ().field_72338_b, particleZ).vel(particleX - caster.field_70165_t, 0.0, particleZ - caster.field_70161_v).clr(0.1f, 0.0f, 0.0f).spawn(world);
                particleX = caster.field_70165_t - 1.0 + 2.0 * world.field_73012_v.nextDouble();
                particleZ = caster.field_70161_v - 1.0 + 2.0 * world.field_73012_v.nextDouble();
                ParticleBuilder.create(ParticleBuilder.Type.SPARKLE).pos(particleX, caster.func_174813_aQ().field_72338_b, particleZ).vel(particleX - caster.field_70165_t, 0.0, particleZ - caster.field_70161_v).time(30).clr(0.1f, 0.0f, 0.05f).spawn(world);
                particleX = caster.field_70165_t - 1.0 + 2.0 * world.field_73012_v.nextDouble();
                particleZ = caster.field_70161_v - 1.0 + 2.0 * world.field_73012_v.nextDouble();
                IBlockState block = WizardryUtilities.getBlockEntityIsStandingOn((Entity)caster);
                if (block != null) {
                    world.func_175688_a(EnumParticleTypes.BLOCK_DUST, particleX, caster.func_174813_aQ().field_72338_b, particleZ, particleX - caster.field_70165_t, 0.0, particleZ - caster.field_70161_v, new int[]{Block.func_176210_f((IBlockState)block)});
                }
                ++i;
            }
            ParticleBuilder.create(ParticleBuilder.Type.SPHERE).pos(caster.field_70165_t, caster.func_174813_aQ().field_72338_b + 0.1, caster.field_70161_v).scale((float)radius * 0.8f).clr(0.8f, 0.0f, 0.05f).spawn(world);
        }
        caster.func_184609_a(hand);
        this.playSound(world, (EntityLivingBase)caster, ticksInUse, -1, modifiers, new String[0]);
        return true;
    }
}

