/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.spell;

import electroblob.wizardry.item.ItemArtefact;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.SpellModifiers;
import java.util.Random;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;

public class InvokeWeather
extends Spell {
    public static final String THUNDERSTORM_CHANCE = "thunderstorm_chance";

    public InvokeWeather() {
        super("invoke_weather", EnumAction.BOW, false);
        this.addProperties(THUNDERSTORM_CHANCE);
        this.soundValues(0.5f, 1.0f, 0.0f);
    }

    @Override
    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        if (caster.field_71093_bK == 0) {
            if (!world.field_72995_K) {
                int standardWeatherTime = (300 + new Random().nextInt(600)) * 20;
                if (world.func_72896_J()) {
                    caster.func_146105_b((ITextComponent)new TextComponentTranslation("spell." + this.getUnlocalisedName() + ".sun", new Object[0]), true);
                    world.func_72912_H().func_176142_i(standardWeatherTime);
                    world.func_72912_H().func_76080_g(0);
                    world.func_72912_H().func_76090_f(0);
                    world.func_72912_H().func_76084_b(false);
                    world.func_72912_H().func_76069_a(false);
                } else {
                    caster.func_146105_b((ITextComponent)new TextComponentTranslation("spell." + this.getUnlocalisedName() + ".rain", new Object[0]), true);
                    world.func_72912_H().func_176142_i(0);
                    world.func_72912_H().func_76080_g(standardWeatherTime);
                    world.func_72912_H().func_76090_f(standardWeatherTime);
                    world.func_72912_H().func_76084_b(true);
                    world.func_72912_H().func_76069_a(ItemArtefact.isArtefactActive(caster, WizardryItems.charm_storm) || world.field_73012_v.nextFloat() < this.getProperty(THUNDERSTORM_CHANCE).floatValue());
                }
            }
            if (world.field_72995_K) {
                for (int i = 0; i < 10; ++i) {
                    double x = caster.field_70165_t + world.field_73012_v.nextDouble() * 2.0 - 1.0;
                    double y = caster.func_174813_aQ().field_72338_b + (double)caster.func_70047_e() - 0.5 + world.field_73012_v.nextDouble();
                    double z = caster.field_70161_v + world.field_73012_v.nextDouble() * 2.0 - 1.0;
                    ParticleBuilder.create(ParticleBuilder.Type.SPARKLE).pos(x, y, z).vel(0.0, 0.1, 0.0).clr(0.5f, 0.7f, 1.0f).spawn(world);
                }
            }
            this.playSound(world, (EntityLivingBase)caster, ticksInUse, -1, modifiers, new String[0]);
            return true;
        }
        return false;
    }
}

