/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.spell;

import electroblob.wizardry.block.BlockStatue;
import electroblob.wizardry.registry.WizardryBlocks;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.registry.WizardrySounds;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.AllyDesignationSystem;
import electroblob.wizardry.util.SpellModifiers;
import electroblob.wizardry.util.WizardryUtilities;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumAction;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public class IceAge
extends Spell {
    public IceAge() {
        super("ice_age", EnumAction.BOW, false);
        this.soundValues(0.7f, 1.0f, 0.0f);
        this.addProperties("effect_radius", "effect_duration");
    }

    @Override
    public boolean requiresPacket() {
        return false;
    }

    @Override
    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        float radius = this.getProperty("effect_radius").floatValue() * modifiers.get(WizardryItems.blast_upgrade);
        List<EntityLivingBase> targets = WizardryUtilities.getEntitiesWithinRadius(radius, caster.field_70165_t, caster.field_70163_u, caster.field_70161_v, world);
        for (EntityLivingBase target : targets) {
            if (!AllyDesignationSystem.isValidTarget((Entity)caster, (Entity)target) || world.field_72995_K || !(target instanceof EntityLiving) || !((BlockStatue)WizardryBlocks.ice_statue).convertToStatue((EntityLiving)target, (int)(this.getProperty("effect_duration").floatValue() * modifiers.get(WizardryItems.duration_upgrade)))) continue;
            target.func_184185_a(WizardrySounds.MISC_FREEZE, 1.0f, world.field_73012_v.nextFloat() * 0.4f + 0.8f);
        }
        if (!world.field_72995_K && WizardryUtilities.canDamageBlocks((EntityLivingBase)caster, world)) {
            for (int i = -((int)radius); i < (int)radius + 1; ++i) {
                for (int j = -((int)radius); j < (int)radius + 1; ++j) {
                    BlockPos pos = new BlockPos((Entity)caster).func_177982_a(i, 0, j);
                    Integer y = WizardryUtilities.getNearestSurface(world, new BlockPos((Vec3i)pos), EnumFacing.UP, (int)radius, true, WizardryUtilities.SurfaceCriteria.BUILDABLE);
                    if (y == null) continue;
                    pos = new BlockPos(pos.func_177958_n(), y.intValue(), pos.func_177952_p());
                    double dist = caster.func_70011_f((double)((int)caster.field_70165_t + i), (double)y.intValue(), (double)((int)caster.field_70161_v + j));
                    if (y == -1 || !((float)world.field_73012_v.nextInt((int)dist * 2 + 1) < radius) || !(dist < (double)radius)) continue;
                    if (world.func_180495_p(pos.func_177977_b()) == Blocks.field_150355_j.func_176223_P()) {
                        world.func_175656_a(pos.func_177977_b(), Blocks.field_150432_aD.func_176223_P());
                        continue;
                    }
                    if (world.func_180495_p(pos.func_177977_b()) == Blocks.field_150353_l.func_176223_P()) {
                        world.func_175656_a(pos.func_177977_b(), Blocks.field_150343_Z.func_176223_P());
                        continue;
                    }
                    if (world.func_180495_p(pos.func_177977_b()) == Blocks.field_150356_k.func_176223_P()) {
                        world.func_175656_a(pos.func_177977_b(), Blocks.field_150347_e.func_176223_P());
                        continue;
                    }
                    if (!Blocks.field_150431_aC.func_176196_c(world, pos)) continue;
                    world.func_175656_a(pos, Blocks.field_150431_aC.func_176223_P());
                }
            }
        }
        this.playSound(world, (EntityLivingBase)caster, ticksInUse, -1, modifiers, new String[0]);
        return true;
    }
}

