/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.spell;

import electroblob.wizardry.Wizardry;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.RayTracer;
import electroblob.wizardry.util.SpellModifiers;
import electroblob.wizardry.util.WizardryUtilities;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;

public class Blink
extends Spell {
    public Blink() {
        super("blink", EnumAction.NONE, false);
        this.addProperties("range");
    }

    @Override
    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        RayTraceResult rayTrace = RayTracer.standardBlockRayTrace(world, (EntityLivingBase)caster, this.getProperty("range").doubleValue() * (double)modifiers.get(WizardryItems.range_upgrade), false);
        if (world.field_72995_K) {
            for (int i = 0; i < 10; ++i) {
                double dx = caster.field_70165_t;
                double dy = caster.func_174813_aQ().field_72338_b + (double)(2.0f * world.field_73012_v.nextFloat());
                double dz = caster.field_70161_v;
                world.func_175688_a(EnumParticleTypes.PORTAL, dx, dy, dz, world.field_73012_v.nextDouble() - 0.5, world.field_73012_v.nextDouble() - 0.5, world.field_73012_v.nextDouble() - 0.5, new int[0]);
            }
            Wizardry.proxy.playBlinkEffect(caster);
        }
        if (rayTrace != null && rayTrace.field_72313_a == RayTraceResult.Type.BLOCK) {
            BlockPos pos = rayTrace.func_178782_a();
            if (rayTrace.field_178784_b == EnumFacing.DOWN) {
                pos = pos.func_177977_b();
            }
            if (rayTrace.field_178784_b == EnumFacing.UP && !world.func_180495_p(pos).func_185904_a().func_76230_c()) {
                pos = pos.func_177977_b();
            }
            if (world.func_180495_p(pos = pos.func_177972_a(rayTrace.field_178784_b)).func_185904_a().func_76230_c() || world.func_180495_p(pos.func_177984_a()).func_185904_a().func_76230_c()) {
                return false;
            }
            this.playSound(world, (EntityLivingBase)caster, ticksInUse, -1, modifiers, new String[0]);
            if (!world.field_72995_K) {
                caster.func_70634_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
            }
            this.playSound(world, (EntityLivingBase)caster, ticksInUse, -1, modifiers, new String[0]);
            caster.func_184609_a(hand);
            return true;
        }
        return false;
    }

    @Override
    public boolean cast(World world, EntityLiving caster, EnumHand hand, int ticksInUse, EntityLivingBase target, SpellModifiers modifiers) {
        float angle = (float)(Math.atan2(target.field_70161_v - caster.field_70161_v, target.field_70165_t - caster.field_70165_t) + world.field_73012_v.nextDouble() * Math.PI);
        double radius = caster.func_70011_f(target.field_70165_t, target.func_174813_aQ().field_72338_b, target.field_70161_v) + world.field_73012_v.nextDouble() * 3.0;
        int x = MathHelper.func_76128_c((double)(target.field_70165_t + (double)MathHelper.func_76126_a((float)angle) * radius));
        int z = MathHelper.func_76128_c((double)(target.field_70161_v - (double)MathHelper.func_76134_b((float)angle) * radius));
        Integer y = WizardryUtilities.getNearestFloor(world, new BlockPos((Entity)caster), (int)radius);
        if (world.field_72995_K) {
            for (int i = 0; i < 10; ++i) {
                double dx1 = caster.field_70165_t;
                double dy1 = caster.func_174813_aQ().field_72338_b + (double)(caster.field_70131_O * world.field_73012_v.nextFloat());
                double dz1 = caster.field_70161_v;
                world.func_175688_a(EnumParticleTypes.PORTAL, dx1, dy1, dz1, world.field_73012_v.nextDouble() - 0.5, world.field_73012_v.nextDouble() - 0.5, world.field_73012_v.nextDouble() - 0.5, new int[0]);
            }
        }
        if (y != null) {
            if (!world.func_180495_p(new BlockPos(x, y.intValue(), z)).func_185904_a().func_76230_c()) {
                Integer n = y;
                Integer n2 = y = Integer.valueOf(y - 1);
            }
            if (world.func_180495_p(new BlockPos(x, y + 1, z)).func_185904_a().func_76230_c() || world.func_180495_p(new BlockPos(x, y + 2, z)).func_185904_a().func_76230_c()) {
                return false;
            }
            this.playSound(world, (EntityLivingBase)caster, ticksInUse, -1, modifiers, new String[0]);
            if (!world.field_72995_K) {
                caster.func_70634_a((double)x + 0.5, (double)(y + 1), (double)z + 0.5);
            }
            this.playSound(world, (EntityLivingBase)caster, ticksInUse, -1, modifiers, new String[0]);
            caster.func_184609_a(hand);
            return true;
        }
        return false;
    }

    @Override
    public boolean canBeCastBy(EntityLiving npc, boolean override) {
        return true;
    }
}

