/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.registry;

import electroblob.wizardry.item.ItemManaFlask;
import electroblob.wizardry.misc.RecipeRechargeWithFlask;
import electroblob.wizardry.registry.WizardryBlocks;
import electroblob.wizardry.registry.WizardryItems;
import java.util.LinkedList;
import java.util.Queue;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistry;

@Mod.EventBusSubscriber
public final class WizardryRecipes {
    private static final Queue<Item> chargingRecipeQueue = new LinkedList<Item>();

    private WizardryRecipes() {
    }

    public static void addToManaFlaskCharging(Item item) {
        chargingRecipeQueue.offer(item);
    }

    @SubscribeEvent
    public static void registerRecipes(RegistryEvent.Register<IRecipe> event) {
        IForgeRegistry registry = event.getRegistry();
        FurnaceRecipes.func_77602_a().func_151393_a(WizardryBlocks.crystal_ore, new ItemStack(WizardryItems.magic_crystal), 0.5f);
        while (!chargingRecipeQueue.isEmpty()) {
            Item chargeable = chargingRecipeQueue.remove();
            registry.register(new RecipeRechargeWithFlask(chargeable, (ItemManaFlask)WizardryItems.small_mana_flask).setRegistryName(new ResourceLocation("ebwizardry", "recipes/small_flask_" + chargeable.getRegistryName().func_110623_a())));
            registry.register(new RecipeRechargeWithFlask(chargeable, (ItemManaFlask)WizardryItems.medium_mana_flask).setRegistryName(new ResourceLocation("ebwizardry", "recipes/medium_flask_" + chargeable.getRegistryName().func_110623_a())));
            registry.register(new RecipeRechargeWithFlask(chargeable, (ItemManaFlask)WizardryItems.large_mana_flask).setRegistryName(new ResourceLocation("ebwizardry", "recipes/large_flask_" + chargeable.getRegistryName().func_110623_a())));
        }
    }
}

