/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.registry;

import electroblob.wizardry.Wizardry;
import electroblob.wizardry.entity.EntityLevitatingBlock;
import electroblob.wizardry.entity.EntityMeteor;
import electroblob.wizardry.entity.EntityShield;
import electroblob.wizardry.entity.construct.EntityArrowRain;
import electroblob.wizardry.entity.construct.EntityBlackHole;
import electroblob.wizardry.entity.construct.EntityBlizzard;
import electroblob.wizardry.entity.construct.EntityBubble;
import electroblob.wizardry.entity.construct.EntityCombustionRune;
import electroblob.wizardry.entity.construct.EntityDecay;
import electroblob.wizardry.entity.construct.EntityEarthquake;
import electroblob.wizardry.entity.construct.EntityFireRing;
import electroblob.wizardry.entity.construct.EntityFireSigil;
import electroblob.wizardry.entity.construct.EntityForcefield;
import electroblob.wizardry.entity.construct.EntityFrostSigil;
import electroblob.wizardry.entity.construct.EntityHailstorm;
import electroblob.wizardry.entity.construct.EntityHammer;
import electroblob.wizardry.entity.construct.EntityHealAura;
import electroblob.wizardry.entity.construct.EntityIceSpike;
import electroblob.wizardry.entity.construct.EntityLightningSigil;
import electroblob.wizardry.entity.construct.EntityTornado;
import electroblob.wizardry.entity.living.EntityBlazeMinion;
import electroblob.wizardry.entity.living.EntityDecoy;
import electroblob.wizardry.entity.living.EntityEvilWizard;
import electroblob.wizardry.entity.living.EntityHuskMinion;
import electroblob.wizardry.entity.living.EntityIceGiant;
import electroblob.wizardry.entity.living.EntityIceWraith;
import electroblob.wizardry.entity.living.EntityLightningWraith;
import electroblob.wizardry.entity.living.EntityMagicSlime;
import electroblob.wizardry.entity.living.EntityPhoenix;
import electroblob.wizardry.entity.living.EntityShadowWraith;
import electroblob.wizardry.entity.living.EntitySilverfishMinion;
import electroblob.wizardry.entity.living.EntitySkeletonMinion;
import electroblob.wizardry.entity.living.EntitySpiderMinion;
import electroblob.wizardry.entity.living.EntitySpiritHorse;
import electroblob.wizardry.entity.living.EntitySpiritWolf;
import electroblob.wizardry.entity.living.EntityStormElemental;
import electroblob.wizardry.entity.living.EntityStrayMinion;
import electroblob.wizardry.entity.living.EntityVexMinion;
import electroblob.wizardry.entity.living.EntityWitherSkeletonMinion;
import electroblob.wizardry.entity.living.EntityWizard;
import electroblob.wizardry.entity.living.EntityZombieMinion;
import electroblob.wizardry.entity.projectile.EntityDarknessOrb;
import electroblob.wizardry.entity.projectile.EntityDart;
import electroblob.wizardry.entity.projectile.EntityEmber;
import electroblob.wizardry.entity.projectile.EntityFirebolt;
import electroblob.wizardry.entity.projectile.EntityFirebomb;
import electroblob.wizardry.entity.projectile.EntityForceArrow;
import electroblob.wizardry.entity.projectile.EntityForceOrb;
import electroblob.wizardry.entity.projectile.EntityIceCharge;
import electroblob.wizardry.entity.projectile.EntityIceLance;
import electroblob.wizardry.entity.projectile.EntityIceShard;
import electroblob.wizardry.entity.projectile.EntityIceball;
import electroblob.wizardry.entity.projectile.EntityLargeMagicFireball;
import electroblob.wizardry.entity.projectile.EntityLightningArrow;
import electroblob.wizardry.entity.projectile.EntityLightningDisc;
import electroblob.wizardry.entity.projectile.EntityMagicFireball;
import electroblob.wizardry.entity.projectile.EntityMagicMissile;
import electroblob.wizardry.entity.projectile.EntityPoisonBomb;
import electroblob.wizardry.entity.projectile.EntitySmokeBomb;
import electroblob.wizardry.entity.projectile.EntitySpark;
import electroblob.wizardry.entity.projectile.EntitySparkBomb;
import electroblob.wizardry.entity.projectile.EntityThunderbolt;
import java.util.Arrays;
import java.util.stream.Collectors;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityEntryBuilder;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber
public class WizardryEntities {
    private static int id = 0;

    private WizardryEntities() {
    }

    @SubscribeEvent
    public static void register(RegistryEvent.Register<EntityEntry> event) {
        IForgeRegistry registry = event.getRegistry();
        registry.register((IForgeRegistryEntry)WizardryEntities.createEntry(EntityZombieMinion.class, "zombie_minion", TrackingType.LIVING).build());
        registry.register((IForgeRegistryEntry)WizardryEntities.createEntry(EntityHuskMinion.class, "husk_minion", TrackingType.LIVING).build());
        registry.register((IForgeRegistryEntry)WizardryEntities.createEntry(EntitySkeletonMinion.class, "skeleton_minion", TrackingType.LIVING).build());
        registry.register((IForgeRegistryEntry)WizardryEntities.createEntry(EntityStrayMinion.class, "stray_minion", TrackingType.LIVING).build());
        registry.register((IForgeRegistryEntry)WizardryEntities.createEntry(EntitySpiderMinion.class, "spider_minion", TrackingType.LIVING).build());
        registry.register((IForgeRegistryEntry)WizardryEntities.createEntry(EntityBlazeMinion.class, "blaze_minion", TrackingType.LIVING).build());
        registry.register((IForgeRegistryEntry)WizardryEntities.createEntry(EntityWitherSkeletonMinion.class, "wither_skeleton_minion", TrackingType.LIVING).build());
        registry.register((IForgeRegistryEntry)WizardryEntities.createEntry(EntitySilverfishMinion.class, "silverfish_minion", TrackingType.LIVING).build());
        registry.register((IForgeRegistryEntry)WizardryEntities.createEntry(EntityVexMinion.class, "vex_minion", TrackingType.LIVING).build());
        registry.register((IForgeRegistryEntry)WizardryEntities.createEntry(EntityIceWraith.class, "ice_wraith", TrackingType.LIVING).egg(0xAAFAFF, 7393).spawn(EnumCreatureType.MONSTER, Wizardry.settings.iceWraithSpawnRate, 1, 1, (Iterable)ForgeRegistries.BIOMES.getValuesCollection().stream().filter(b -> !Arrays.asList(Wizardry.settings.mobSpawnBiomeBlacklist).contains(b.getRegistryName()) && BiomeDictionary.hasType((Biome)b, (BiomeDictionary.Type)BiomeDictionary.Type.SNOWY) && !BiomeDictionary.hasType((Biome)b, (BiomeDictionary.Type)BiomeDictionary.Type.FOREST)).collect(Collectors.toSet())).build());
        registry.register((IForgeRegistryEntry)WizardryEntities.createEntry(EntityLightningWraith.class, "lightning_wraith", TrackingType.LIVING).egg(3490379, 2603481).spawn(EnumCreatureType.MONSTER, Wizardry.settings.lightningWraithSpawnRate, 1, 1, (Iterable)ForgeRegistries.BIOMES.getValuesCollection().stream().filter(b -> !Arrays.asList(Wizardry.settings.mobSpawnBiomeBlacklist).contains(b.getRegistryName())).collect(Collectors.toSet())).build());
        registry.register((IForgeRegistryEntry)WizardryEntities.createEntry(EntitySpiritWolf.class, "spirit_wolf", TrackingType.LIVING).egg(12370664, 5530822).build());
        registry.register((IForgeRegistryEntry)WizardryEntities.createEntry(EntitySpiritHorse.class, "spirit_horse", TrackingType.LIVING).egg(5530822, 12370664).build());
        registry.register((IForgeRegistryEntry)WizardryEntities.createEntry(EntityPhoenix.class, "phoenix", TrackingType.LIVING).egg(16730368, 16639285).build());
        registry.register((IForgeRegistryEntry)WizardryEntities.createEntry(EntityIceGiant.class, "ice_giant", TrackingType.LIVING).egg(6008025, 0xEFFAFF).build());
        registry.register((IForgeRegistryEntry)WizardryEntities.createEntry(EntityMagicSlime.class, "magic_slime", TrackingType.LIVING).build());
        registry.register((IForgeRegistryEntry)WizardryEntities.createEntry(EntityDecoy.class, "decoy", TrackingType.LIVING).build());
        registry.register((IForgeRegistryEntry)WizardryEntities.createEntry(EntityShadowWraith.class, "shadow_wraith").tracker(80, 10, true).egg(1115932, 4330372).build());
        registry.register((IForgeRegistryEntry)WizardryEntities.createEntry(EntityStormElemental.class, "storm_elemental").tracker(80, 10, true).egg(1450280, 1266297).build());
        registry.register((IForgeRegistryEntry)WizardryEntities.createEntry(EntityWizard.class, "wizard", TrackingType.LIVING).egg(1648990, 15635218).build());
        registry.register((IForgeRegistryEntry)WizardryEntities.createEntry(EntityEvilWizard.class, "evil_wizard", TrackingType.LIVING).egg(2688004, 15635218).spawn(EnumCreatureType.MONSTER, Wizardry.settings.evilWizardSpawnRate, 1, 1, (Iterable)ForgeRegistries.BIOMES.getValuesCollection().stream().filter(b -> !Arrays.asList(Wizardry.settings.mobSpawnBiomeBlacklist).contains(b.getRegistryName())).collect(Collectors.toSet())).build());
        registry.register((IForgeRegistryEntry)WizardryEntities.createEntry(EntityMagicMissile.class, "magic_missile", TrackingType.PROJECTILE).build());
        registry.register((IForgeRegistryEntry)WizardryEntities.createEntry(EntityIceShard.class, "ice_shard", TrackingType.PROJECTILE).build());
        registry.register((IForgeRegistryEntry)WizardryEntities.createEntry(EntityLightningArrow.class, "lightning_arrow", TrackingType.PROJECTILE).build());
        registry.register((IForgeRegistryEntry)WizardryEntities.createEntry(EntityForceArrow.class, "force_arrow", TrackingType.PROJECTILE).build());
        registry.register((IForgeRegistryEntry)WizardryEntities.createEntry(EntityDart.class, "dart", TrackingType.PROJECTILE).build());
        registry.register((IForgeRegistryEntry)WizardryEntities.createEntry(EntityIceLance.class, "ice_lance", TrackingType.PROJECTILE).build());
        registry.register((IForgeRegistryEntry)WizardryEntities.createEntry(EntityFirebomb.class, "firebomb", TrackingType.PROJECTILE).build());
        registry.register((IForgeRegistryEntry)WizardryEntities.createEntry(EntityPoisonBomb.class, "poison_bomb", TrackingType.PROJECTILE).build());
        registry.register((IForgeRegistryEntry)WizardryEntities.createEntry(EntitySparkBomb.class, "spark_bomb", TrackingType.PROJECTILE).build());
        registry.register((IForgeRegistryEntry)WizardryEntities.createEntry(EntitySmokeBomb.class, "smoke_bomb", TrackingType.PROJECTILE).build());
        registry.register((IForgeRegistryEntry)WizardryEntities.createEntry(EntityIceCharge.class, "ice_charge", TrackingType.PROJECTILE).build());
        registry.register((IForgeRegistryEntry)WizardryEntities.createEntry(EntityForceOrb.class, "force_orb", TrackingType.PROJECTILE).build());
        registry.register((IForgeRegistryEntry)WizardryEntities.createEntry(EntitySpark.class, "spark", TrackingType.PROJECTILE).build());
        registry.register((IForgeRegistryEntry)WizardryEntities.createEntry(EntityDarknessOrb.class, "darkness_orb", TrackingType.PROJECTILE).build());
        registry.register((IForgeRegistryEntry)WizardryEntities.createEntry(EntityFirebolt.class, "firebolt", TrackingType.PROJECTILE).build());
        registry.register((IForgeRegistryEntry)WizardryEntities.createEntry(EntityThunderbolt.class, "thunderbolt", TrackingType.PROJECTILE).build());
        registry.register((IForgeRegistryEntry)WizardryEntities.createEntry(EntityLightningDisc.class, "lightning_disc", TrackingType.PROJECTILE).build());
        registry.register((IForgeRegistryEntry)WizardryEntities.createEntry(EntityEmber.class, "ember", TrackingType.PROJECTILE).build());
        registry.register((IForgeRegistryEntry)WizardryEntities.createEntry(EntityMagicFireball.class, "magic_fireball", TrackingType.PROJECTILE).build());
        registry.register((IForgeRegistryEntry)WizardryEntities.createEntry(EntityLargeMagicFireball.class, "large_magic_fireball", TrackingType.PROJECTILE).build());
        registry.register((IForgeRegistryEntry)WizardryEntities.createEntry(EntityIceball.class, "iceball", TrackingType.PROJECTILE).build());
        registry.register((IForgeRegistryEntry)WizardryEntities.createEntry(EntityMeteor.class, "meteor").tracker(160, 3, true).build());
        registry.register((IForgeRegistryEntry)WizardryEntities.createEntry(EntityHammer.class, "lightning_hammer").tracker(160, 3, true).build());
        registry.register((IForgeRegistryEntry)WizardryEntities.createEntry(EntityLevitatingBlock.class, "levitating_block").tracker(160, 3, true).build());
        registry.register((IForgeRegistryEntry)WizardryEntities.createEntry(EntityBlackHole.class, "black_hole", TrackingType.CONSTRUCT).build());
        registry.register((IForgeRegistryEntry)WizardryEntities.createEntry(EntityBlizzard.class, "blizzard", TrackingType.CONSTRUCT).build());
        registry.register((IForgeRegistryEntry)WizardryEntities.createEntry(EntityForcefield.class, "forcefield", TrackingType.CONSTRUCT).build());
        registry.register((IForgeRegistryEntry)WizardryEntities.createEntry(EntityFireSigil.class, "fire_sigil", TrackingType.CONSTRUCT).build());
        registry.register((IForgeRegistryEntry)WizardryEntities.createEntry(EntityFrostSigil.class, "frost_sigil", TrackingType.CONSTRUCT).build());
        registry.register((IForgeRegistryEntry)WizardryEntities.createEntry(EntityLightningSigil.class, "lightning_sigil", TrackingType.CONSTRUCT).build());
        registry.register((IForgeRegistryEntry)WizardryEntities.createEntry(EntityCombustionRune.class, "combustion_rune", TrackingType.CONSTRUCT).build());
        registry.register((IForgeRegistryEntry)WizardryEntities.createEntry(EntityFireRing.class, "ring_of_fire", TrackingType.CONSTRUCT).build());
        registry.register((IForgeRegistryEntry)WizardryEntities.createEntry(EntityHealAura.class, "healing_aura", TrackingType.CONSTRUCT).build());
        registry.register((IForgeRegistryEntry)WizardryEntities.createEntry(EntityDecay.class, "decay", TrackingType.CONSTRUCT).build());
        registry.register((IForgeRegistryEntry)WizardryEntities.createEntry(EntityArrowRain.class, "arrow_rain", TrackingType.CONSTRUCT).build());
        registry.register((IForgeRegistryEntry)WizardryEntities.createEntry(EntityEarthquake.class, "earthquake", TrackingType.CONSTRUCT).build());
        registry.register((IForgeRegistryEntry)WizardryEntities.createEntry(EntityHailstorm.class, "hailstorm", TrackingType.CONSTRUCT).build());
        registry.register((IForgeRegistryEntry)WizardryEntities.createEntry(EntityShield.class, "shield").tracker(160, 10, true).build());
        registry.register((IForgeRegistryEntry)WizardryEntities.createEntry(EntityBubble.class, "bubble").tracker(160, 3, false).build());
        registry.register((IForgeRegistryEntry)WizardryEntities.createEntry(EntityTornado.class, "tornado").tracker(160, 3, false).build());
        registry.register((IForgeRegistryEntry)WizardryEntities.createEntry(EntityIceSpike.class, "ice_spike").tracker(160, 1, true).build());
    }

    private static <T extends Entity> EntityEntryBuilder<T> createEntry(Class<T> entityClass, String name, TrackingType tracking) {
        return WizardryEntities.createEntry(entityClass, name).tracker(tracking.range, tracking.interval, tracking.trackVelocity);
    }

    private static <T extends Entity> EntityEntryBuilder<T> createEntry(Class<T> entityClass, String name) {
        ResourceLocation registryName = new ResourceLocation("ebwizardry", name);
        return EntityEntryBuilder.create().entity(entityClass).id(registryName, id++).name(registryName.toString());
    }

    static enum TrackingType {
        LIVING(80, 3, true),
        PROJECTILE(64, 10, true),
        CONSTRUCT(160, 10, false);

        int range;
        int interval;
        boolean trackVelocity;

        private TrackingType(int range, int interval, boolean trackVelocity) {
            this.range = range;
            this.interval = interval;
            this.trackVelocity = trackVelocity;
        }
    }
}

