/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.item;

import electroblob.wizardry.spell.Spell;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod.EventBusSubscriber
public interface IConjuredItem {
    public static final String DURATION_MULTIPLIER_KEY = "durationMultiplier";
    public static final String DAMAGE_MULTIPLIER = "damageMultiplier";
    public static final UUID POTENCY_MODIFIER = UUID.fromString("da067ea6-0b35-4140-8436-5476224de9dd");

    public static void setDurationMultiplier(ItemStack stack, float multiplier) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.func_77978_p().func_74776_a(DURATION_MULTIPLIER_KEY, multiplier);
    }

    public static void setDamageMultiplier(ItemStack stack, float multiplier) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.func_77978_p().func_74776_a(DAMAGE_MULTIPLIER, multiplier);
    }

    public static float getDamageMultiplier(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return 1.0f;
        }
        return stack.func_77978_p().func_74760_g(DAMAGE_MULTIPLIER);
    }

    default public int getMaxDamageFromNBT(ItemStack stack, Spell spell) {
        if (!spell.arePropertiesInitialised()) {
            return 600;
        }
        float baseDuration = spell.getProperty("item_lifetime").floatValue();
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b(DURATION_MULTIPLIER_KEY)) {
            return (int)(baseDuration * stack.func_77978_p().func_74760_g(DURATION_MULTIPLIER_KEY));
        }
        return (int)baseDuration;
    }

    default public void addAnimationPropertyOverrides() {
        if (!(this instanceof Item)) {
            throw new ClassCastException("Cannot set up conjuring animations for a non-item!");
        }
        Item item = (Item)this;
        final int frames = this.getAnimationFrames();
        item.func_185043_a(new ResourceLocation("conjure"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World world, @Nullable EntityLivingBase entity) {
                return stack.func_77952_i() < frames ? (float)stack.func_77952_i() / (float)frames : (float)(stack.func_77958_k() - stack.func_77952_i()) / (float)frames;
            }
        });
        item.func_185043_a(new ResourceLocation("conjuring"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World world, @Nullable EntityLivingBase entity) {
                return stack.func_77952_i() < frames || stack.func_77952_i() > stack.func_77958_k() - frames ? 1.0f : 0.0f;
            }
        });
    }

    default public int getAnimationFrames() {
        return 8;
    }

    @SubscribeEvent
    public static void onLivingDropsEvent(LivingDropsEvent event) {
        for (EntityItem item : event.getDrops()) {
            if (item == null || item.func_92059_d() == null || !(item.func_92059_d().func_77973_b() instanceof IConjuredItem)) continue;
            item.func_70106_y();
        }
    }

    @SubscribeEvent
    public static void onItemTossEvent(ItemTossEvent event) {
        if (event.getEntityItem().func_92059_d().func_77973_b() instanceof IConjuredItem) {
            event.setCanceled(true);
            event.getPlayer().field_71071_by.func_70441_a(event.getEntityItem().func_92059_d());
        }
    }
}

