/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.entity.projectile;

import electroblob.wizardry.Wizardry;
import electroblob.wizardry.entity.projectile.EntityMagicFireball;
import electroblob.wizardry.registry.Spells;
import electroblob.wizardry.util.WizardryUtilities;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.entity.projectile.EntityLargeFireball;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber
public class EntityLargeMagicFireball
extends EntityMagicFireball {
    public static final String EXPLOSION_POWER = "explosion_power";
    public float blastMultiplier = 1.0f;
    protected float explosionPower = -1.0f;

    public EntityLargeMagicFireball(World world) {
        super(world);
        this.func_70105_a(1.0f, 1.0f);
    }

    public void setExplosionPower(float explosionPower) {
        this.explosionPower = explosionPower;
    }

    public float getExplosionPower() {
        return this.explosionPower == -1.0f ? Spells.greater_fireball.getProperty(EXPLOSION_POWER).floatValue() : this.explosionPower;
    }

    @Override
    public float getDamage() {
        return this.damage == -1.0f ? Spells.greater_fireball.getProperty("damage").floatValue() : this.damage;
    }

    @Override
    protected void func_70184_a(RayTraceResult rayTrace) {
        if (!this.field_70170_p.field_72995_K) {
            boolean flag = this.func_85052_h() == null || WizardryUtilities.canDamageBlocks(this.func_85052_h(), this.field_70170_p);
            this.field_70170_p.func_72885_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.getExplosionPower() * this.blastMultiplier, flag, flag);
        }
        super.func_70184_a(rayTrace);
    }

    @Override
    public void writeSpawnData(ByteBuf buffer) {
        buffer.writeFloat(this.blastMultiplier);
        super.writeSpawnData(buffer);
    }

    @Override
    public void readSpawnData(ByteBuf buffer) {
        this.blastMultiplier = buffer.readFloat();
        super.readSpawnData(buffer);
    }

    @Override
    public void func_70037_a(NBTTagCompound nbttagcompound) {
        super.func_70037_a(nbttagcompound);
        this.blastMultiplier = nbttagcompound.func_74760_g("blastMultiplier");
    }

    @Override
    public void func_70014_b(NBTTagCompound nbttagcompound) {
        super.func_70014_b(nbttagcompound);
        nbttagcompound.func_74776_a("blastMultiplier", this.blastMultiplier);
    }

    @SubscribeEvent
    public static void onEntityJoinWorldEvent(EntityJoinWorldEvent event) {
        if (Wizardry.settings.replaceVanillaFireballs && event.getEntity() instanceof EntityLargeFireball) {
            event.setCanceled(true);
            EntityLargeMagicFireball fireball = new EntityLargeMagicFireball(event.getWorld());
            fireball.field_70192_c = ((EntityLargeFireball)event.getEntity()).field_70235_a;
            fireball.func_70107_b(event.getEntity().field_70165_t, event.getEntity().field_70163_u, event.getEntity().field_70161_v);
            fireball.setDamage(6.0f);
            fireball.setExplosionPower(((EntityLargeFireball)event.getEntity()).field_92057_e);
            fireball.setLifetime(75);
            fireball.field_70159_w = ((EntityLargeFireball)event.getEntity()).field_70232_b * 10.0;
            fireball.field_70181_x = ((EntityLargeFireball)event.getEntity()).field_70233_c * 10.0;
            fireball.field_70179_y = ((EntityLargeFireball)event.getEntity()).field_70230_d * 10.0;
            event.getWorld().func_72838_d((Entity)fireball);
        }
    }
}

