/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.entity.projectile;

import electroblob.wizardry.entity.projectile.EntityBomb;
import electroblob.wizardry.entity.projectile.EntityIceShard;
import electroblob.wizardry.registry.Spells;
import electroblob.wizardry.registry.WizardryPotions;
import electroblob.wizardry.registry.WizardrySounds;
import electroblob.wizardry.util.MagicDamage;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.WizardryUtilities;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;

public class EntityIceCharge
extends EntityBomb {
    public static final String ICE_SHARDS = "ice_shards";

    public EntityIceCharge(World world) {
        super(world);
    }

    @Override
    public int getLifetime() {
        return -1;
    }

    protected void func_70184_a(RayTraceResult rayTrace) {
        Entity entityHit = rayTrace.field_72308_g;
        if (entityHit != null) {
            float damage = Spells.ice_charge.getProperty("damage").floatValue() * this.damageMultiplier;
            entityHit.func_70097_a(MagicDamage.causeIndirectMagicDamage((Entity)this, (Entity)this.func_85052_h(), MagicDamage.DamageType.FROST).func_76349_b(), damage);
            if (entityHit instanceof EntityLivingBase && !MagicDamage.isEntityImmune(MagicDamage.DamageType.FROST, entityHit)) {
                ((EntityLivingBase)entityHit).func_70690_d(new PotionEffect(WizardryPotions.frost, Spells.ice_charge.getProperty("direct_effect_duration").intValue(), Spells.ice_charge.getProperty("direct_effect_strength").intValue()));
            }
        }
        if (this.field_70170_p.field_72995_K) {
            this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_LARGE, this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.0, 0.0, 0.0, new int[0]);
            int i = 0;
            while ((float)i < 30.0f * this.blastMultiplier) {
                ParticleBuilder.create(ParticleBuilder.Type.ICE, this.field_70146_Z, this.field_70165_t, this.field_70163_u, this.field_70161_v, 2.0f * this.blastMultiplier, false).time(35).gravity(true).spawn(this.field_70170_p);
                float brightness = 0.4f + this.field_70146_Z.nextFloat() * 0.5f;
                ParticleBuilder.create(ParticleBuilder.Type.DARK_MAGIC, this.field_70146_Z, this.field_70165_t, this.field_70163_u, this.field_70161_v, 2.0f * this.blastMultiplier, false).clr(brightness, brightness + 0.1f, 1.0f).spawn(this.field_70170_p);
                ++i;
            }
        }
        if (!this.field_70170_p.field_72995_K) {
            int i;
            this.func_184185_a(WizardrySounds.ENTITY_ICE_CHARGE_SMASH, 1.5f, this.field_70146_Z.nextFloat() * 0.4f + 0.6f);
            this.func_184185_a(WizardrySounds.ENTITY_ICE_CHARGE_ICE, 1.2f, this.field_70146_Z.nextFloat() * 0.4f + 1.2f);
            double radius = Spells.ice_charge.getProperty("effect_radius").floatValue() * this.blastMultiplier;
            List<EntityLivingBase> targets = WizardryUtilities.getEntitiesWithinRadius(radius, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70170_p);
            for (EntityLivingBase target : targets) {
                if (target == entityHit || target == this.func_85052_h() || MagicDamage.isEntityImmune(MagicDamage.DamageType.FROST, (Entity)target)) continue;
                target.func_70690_d(new PotionEffect(WizardryPotions.frost, Spells.ice_charge.getProperty("splash_effect_duration").intValue(), Spells.ice_charge.getProperty("splash_effect_strength").intValue()));
            }
            for (i = -1; i < 2; ++i) {
                for (int j = -1; j < 2; ++j) {
                    double dist;
                    BlockPos pos = new BlockPos(this.field_70165_t + (double)i, this.field_70163_u, this.field_70161_v + (double)j);
                    Integer y = WizardryUtilities.getNearestSurface(this.field_70170_p, pos, EnumFacing.UP, 7, true, WizardryUtilities.SurfaceCriteria.SOLID_LIQUID_TO_AIR);
                    if (y == null || this.field_70146_Z.nextInt((int)(dist = this.func_70011_f((pos = new BlockPos(pos.func_177958_n(), y.intValue(), pos.func_177952_p())).func_177958_n(), pos.func_177956_o(), pos.func_177952_p())) * 2 + 1) >= 1 || !(dist < 2.0)) continue;
                    if (this.field_70170_p.func_180495_p(pos.func_177977_b()).func_177230_c() == Blocks.field_150355_j) {
                        this.field_70170_p.func_175656_a(pos.func_177977_b(), Blocks.field_150432_aD.func_176223_P());
                        continue;
                    }
                    this.field_70170_p.func_175656_a(pos, Blocks.field_150431_aC.func_176223_P());
                }
            }
            for (i = 0; i < Spells.ice_charge.getProperty(ICE_SHARDS).intValue(); ++i) {
                double dx = this.field_70146_Z.nextDouble() - 0.5;
                double dy = this.field_70146_Z.nextDouble() - 0.5;
                double dz = this.field_70146_Z.nextDouble() - 0.5;
                EntityIceShard iceshard = new EntityIceShard(this.field_70170_p);
                iceshard.func_70107_b(this.field_70165_t + dx, this.field_70163_u + dy, this.field_70161_v + dz);
                iceshard.field_70159_w = dx * 1.5;
                iceshard.field_70181_x = dy * 1.5;
                iceshard.field_70179_y = dz * 1.5;
                iceshard.setCaster(this.func_85052_h());
                iceshard.damageMultiplier = this.damageMultiplier;
                this.field_70170_p.func_72838_d((Entity)iceshard);
            }
            this.func_70106_y();
        }
    }

    public boolean func_90999_ad() {
        return false;
    }
}

