/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.entity.living;

import electroblob.wizardry.Wizardry;
import electroblob.wizardry.entity.living.ISummonedCreature;
import java.util.Calendar;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityFlying;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.monster.AbstractSkeleton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;

public class EntitySkeletonMinion
extends AbstractSkeleton
implements ISummonedCreature {
    private int lifetime = -1;
    private UUID casterUUID;

    @Override
    public int getLifetime() {
        return this.lifetime;
    }

    @Override
    public void setLifetime(int lifetime) {
        this.lifetime = lifetime;
    }

    @Override
    public UUID func_184753_b() {
        return this.casterUUID;
    }

    @Override
    public void setOwnerId(UUID uuid) {
        this.casterUUID = uuid;
    }

    public EntitySkeletonMinion(World world) {
        super(world);
        this.field_70728_aV = 0;
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70715_bh.field_75782_a.clear();
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityLivingBase.class, 0, false, true, this.getTargetSelector()));
    }

    protected void func_180481_a(DifficultyInstance difficulty) {
        this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack((Item)Items.field_151031_f));
    }

    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        Calendar calendar;
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111121_a(new AttributeModifier("Random spawn bonus", this.field_70146_Z.nextGaussian() * 0.05, 1));
        if (this.field_70146_Z.nextFloat() < 0.05f) {
            this.func_184641_n(true);
        } else {
            this.func_184641_n(false);
        }
        if (this.func_184582_a(EntityEquipmentSlot.HEAD).func_190926_b() && (calendar = this.field_70170_p.func_83015_S()).get(2) + 1 == 10 && calendar.get(5) == 31 && this.field_70146_Z.nextFloat() < 0.25f) {
            this.func_184201_a(EntityEquipmentSlot.HEAD, new ItemStack(this.field_70146_Z.nextFloat() < 0.1f ? Blocks.field_150428_aP : Blocks.field_150423_aK));
            this.field_184655_bs[EntityEquipmentSlot.HEAD.func_188454_b()] = 0.0f;
        }
        return livingdata;
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187854_fc;
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return SoundEvents.field_187864_fh;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187856_fd;
    }

    protected SoundEvent func_190727_o() {
        return SoundEvents.field_187868_fj;
    }

    public void func_70604_c(EntityLivingBase entity) {
        if (this.shouldRevengeTarget(entity)) {
            super.func_70604_c(entity);
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.updateDelegate();
    }

    @Override
    public void onSpawn() {
        this.spawnParticleEffect();
    }

    @Override
    public void onDespawn() {
        this.spawnParticleEffect();
    }

    private void spawnParticleEffect() {
        if (this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 15; ++i) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_LARGE, this.field_70165_t + (double)this.field_70146_Z.nextFloat(), this.field_70163_u + 1.0 + (double)this.field_70146_Z.nextFloat(), this.field_70161_v + (double)this.field_70146_Z.nextFloat(), 0.0, 0.0, 0.0, new int[0]);
            }
        }
    }

    @Override
    public boolean hasParticleEffect() {
        return true;
    }

    protected boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        return this.interactDelegate(player, hand) || super.func_184645_a(player, hand);
    }

    public void func_70014_b(NBTTagCompound nbttagcompound) {
        super.func_70014_b(nbttagcompound);
        this.writeNBTDelegate(nbttagcompound);
    }

    public void func_70037_a(NBTTagCompound nbttagcompound) {
        super.func_70037_a(nbttagcompound);
        this.readNBTDelegate(nbttagcompound);
    }

    protected int func_70693_a(EntityPlayer player) {
        return 0;
    }

    protected boolean func_146066_aG() {
        return false;
    }

    protected Item func_146068_u() {
        return null;
    }

    protected ResourceLocation func_184647_J() {
        return null;
    }

    public boolean func_98052_bS() {
        return false;
    }

    protected boolean func_70692_ba() {
        return this.getCaster() == null && this.func_184753_b() == null;
    }

    public boolean func_70601_bi() {
        return this.field_70170_p.func_175659_aa() != EnumDifficulty.PEACEFUL;
    }

    public boolean func_70686_a(Class<? extends EntityLivingBase> entityType) {
        return !EntityFlying.class.isAssignableFrom(entityType) || this.func_184614_ca().func_77973_b() instanceof ItemBow;
    }

    public ITextComponent func_145748_c_() {
        if (this.getCaster() != null) {
            return new TextComponentTranslation("entity.ebwizardry:summonedcreature.nameplate", new Object[]{this.getCaster().func_70005_c_(), new TextComponentTranslation("entity." + this.func_70022_Q() + ".name", new Object[0])});
        }
        return super.func_145748_c_();
    }

    public boolean func_145818_k_() {
        return Wizardry.settings.summonedCreatureNames && this.getCaster() != null;
    }
}

