/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.world.feature;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockFence;
import net.minecraft.block.BlockLog;
import net.minecraft.block.BlockOldLog;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.structure.MapGenVillage;
import net.minecraft.world.gen.structure.StructureVillagePieces;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.BiomeEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import svenhjol.meson.Feature;

public class MoreVillageBiomes
extends Feature {
    public static Map<String, List<Biome>> biomes = new HashMap<String, List<Biome>>();
    public static List<Biome> allBiomes = new ArrayList<Biome>();
    public static String[] plainsBiomes;
    public static String[] jungleBiomes;
    public static String[] savannaBiomes;
    public static String[] coldBiomes;
    public static String[] desertBiomes;

    @Override
    public String getDescription() {
        return "Villages spawn in more biomes.  The type of biome determines what materials the village buildings are constructed from.";
    }

    @Override
    public void configure() {
        super.configure();
        coldBiomes = this.propStringList("Cold biomes", "Cold biomes where villages are constructed from Taiga wood.", new String[]{"taiga", "mutated_taiga", "mutated_taiga_cold", "ice_flats", "mutated_ice_flats"});
        jungleBiomes = this.propStringList("Jungle biomes", "Jungle biomes where villages are constructed from Jungle wood.", new String[]{"jungle", "mutated_jungle"});
        savannaBiomes = this.propStringList("Savanna biomes", "Savanna biomes where villages are constructed from Acacia wood.", new String[]{"savanna", "mutated_savanna"});
        plainsBiomes = this.propStringList("Plains biomes", "Plains biomes where villages are constructed from Oak wood.", new String[]{"plains", "mutated_plains", "swampland", "mutated_swampland"});
        desertBiomes = this.propStringList("Desert biomes", "Desert biomes where villages are made from sandstone.", new String[]{"desert", "mutated_desert"});
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        super.preInit(event);
        biomes.put("cold", this.makeBiomeList(coldBiomes));
        biomes.put("jungle", this.makeBiomeList(jungleBiomes));
        biomes.put("savanna", this.makeBiomeList(savannaBiomes));
        biomes.put("plains", this.makeBiomeList(plainsBiomes));
        biomes.put("desert", this.makeBiomeList(desertBiomes));
        for (String biomeSet : biomes.keySet()) {
            allBiomes.addAll((Collection<Biome>)biomes.get(biomeSet));
        }
        MapGenVillage.field_75055_e = allBiomes;
    }

    private List<Biome> makeBiomeList(String[] biomes) {
        ArrayList<Biome> biomeList = new ArrayList<Biome>();
        if (biomes.length > 0) {
            for (String b : biomes) {
                biomeList.add((Biome)Biome.field_185377_q.func_82594_a((Object)new ResourceLocation(b)));
            }
        }
        return biomeList;
    }

    @SubscribeEvent
    public void getVillageBlockID(BiomeEvent.GetVillageBlockID event) {
        IBlockState original = event.getOriginal();
        Block block = original.func_177230_c();
        Biome biome = event.getBiome();
        if (biome == null) {
            return;
        }
        IBlockState replacement = null;
        BlockPlanks.EnumType planks = null;
        BlockStairs stairs = null;
        BlockFence fence = null;
        BlockDoor door = null;
        if (biomes.get("cold").contains(biome) || biomes.get("jungle").contains(biome)) {
            planks = MoreVillageBiomes.getWoodForBiome(biome);
            fence = MoreVillageBiomes.getFenceForWood(planks);
            stairs = MoreVillageBiomes.getStairsForWood(planks);
            door = MoreVillageBiomes.getDoorForWood(planks);
        }
        if (block == Blocks.field_150344_f && planks != null) {
            replacement = original.func_177226_a((IProperty)BlockPlanks.field_176383_a, (Comparable)planks);
        }
        if (block == Blocks.field_150364_r && planks != null) {
            replacement = original.func_177226_a((IProperty)BlockOldLog.field_176301_b, (Comparable)planks).func_177226_a((IProperty)BlockLog.field_176299_a, original.func_177229_b((IProperty)BlockLog.field_176299_a));
        }
        if (block == Blocks.field_150476_ad && stairs != null) {
            replacement = stairs.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, original.func_177229_b((IProperty)BlockStairs.field_176309_a)).func_177226_a((IProperty)BlockStairs.field_176308_b, original.func_177229_b((IProperty)BlockStairs.field_176308_b)).func_177226_a((IProperty)BlockStairs.field_176310_M, original.func_177229_b((IProperty)BlockStairs.field_176310_M));
        }
        if (block == Blocks.field_180407_aO && fence != null) {
            replacement = fence.func_176223_P();
        }
        if (block instanceof BlockDoor && door != null) {
            replacement = door.func_176223_P();
        }
        if (replacement != null) {
            event.setReplacement(replacement);
            event.setResult(Event.Result.DENY);
        }
    }

    public static BlockPlanks.EnumType getWoodForBiome(Biome biome) {
        if (biomes.get("cold").contains(biome)) {
            return BlockPlanks.EnumType.SPRUCE;
        }
        if (biomes.get("jungle").contains(biome)) {
            return BlockPlanks.EnumType.JUNGLE;
        }
        if (biomes.get("savanna").contains(biome)) {
            return BlockPlanks.EnumType.ACACIA;
        }
        return BlockPlanks.EnumType.OAK;
    }

    public static BlockFence getFenceForWood(BlockPlanks.EnumType wood) {
        if (wood == BlockPlanks.EnumType.SPRUCE) {
            return (BlockFence)Blocks.field_180408_aP;
        }
        if (wood == BlockPlanks.EnumType.JUNGLE) {
            return (BlockFence)Blocks.field_180403_aR;
        }
        if (wood == BlockPlanks.EnumType.ACACIA) {
            return (BlockFence)Blocks.field_180405_aT;
        }
        return (BlockFence)Blocks.field_180407_aO;
    }

    public static BlockStairs getStairsForWood(BlockPlanks.EnumType wood) {
        if (wood == BlockPlanks.EnumType.SPRUCE) {
            return (BlockStairs)Blocks.field_150485_bF;
        }
        if (wood == BlockPlanks.EnumType.JUNGLE) {
            return (BlockStairs)Blocks.field_150481_bH;
        }
        if (wood == BlockPlanks.EnumType.ACACIA) {
            return (BlockStairs)Blocks.field_150400_ck;
        }
        return (BlockStairs)Blocks.field_150476_ad;
    }

    public static BlockDoor getDoorForWood(BlockPlanks.EnumType wood) {
        if (wood == BlockPlanks.EnumType.SPRUCE) {
            return Blocks.field_180414_ap;
        }
        if (wood == BlockPlanks.EnumType.JUNGLE) {
            return Blocks.field_180411_ar;
        }
        if (wood == BlockPlanks.EnumType.ACACIA) {
            return Blocks.field_180410_as;
        }
        return Blocks.field_180413_ao;
    }

    public static BlockDoor villageDoorsForBiome(StructureVillagePieces.Start start) {
        if (start == null || start.biome == null) {
            return Blocks.field_180413_ao;
        }
        Biome biome = start.biome;
        IBlockState door = Blocks.field_180413_ao.func_176223_P();
        BiomeEvent.GetVillageBlockID event = new BiomeEvent.GetVillageBlockID(biome, door);
        MinecraftForge.TERRAIN_GEN_BUS.post((Event)event);
        if (event.getResult() == Event.Result.DENY) {
            return (BlockDoor)event.getReplacement().func_177230_c();
        }
        if (biome == Biomes.field_150588_X) {
            door = Blocks.field_180410_as.func_176223_P();
        }
        if (biome == Biomes.field_76768_g) {
            door = Blocks.field_180414_ap.func_176223_P();
        }
        return (BlockDoor)door.func_177230_c();
    }

    @Override
    public boolean hasTerrainSubscriptions() {
        return true;
    }
}

