/*
 * Decompiled with CFR 0.152.
 */
package dev.necauqua.mods.cm.recipes;

import dev.necauqua.mods.cm.ChiseledMe;
import dev.necauqua.mods.cm.Log;
import dev.necauqua.mods.cm.advancements.AdvancementTriggers;
import it.unimi.dsi.fastutil.ints.IntList;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;

public final class WeirdBeaconRecipe
extends ShapedRecipes {
    @GameRegistry.ObjectHolder(value="chiseled_me:blue_star")
    private static Item BLUE_STAR;
    private static final ItemStack RESULT;

    private static NonNullList<Ingredient> createIngredients() {
        NonNullList ingredients = NonNullList.func_191196_a();
        NBTTagCompound nbt = new NBTTagCompound();
        NBTTagCompound blockTag = new NBTTagCompound();
        blockTag.func_74774_a("chiseled_me:color", (byte)3);
        nbt.func_74782_a("BlockEntityTag", (NBTBase)blockTag);
        RESULT.func_77982_d(nbt);
        Ingredient glass = Ingredient.func_193367_a((Item)Item.func_150898_a((Block)Blocks.field_150359_w));
        Ingredient obsidian = Ingredient.func_193367_a((Item)Item.func_150898_a((Block)Blocks.field_150343_Z));
        ingredients.add((Object)glass);
        ingredients.add((Object)glass);
        ingredients.add((Object)glass);
        ingredients.add((Object)glass);
        ingredients.add((Object)Ingredient.func_193367_a((Item)BLUE_STAR));
        ingredients.add((Object)glass);
        ingredients.add((Object)obsidian);
        ingredients.add((Object)obsidian);
        ingredients.add((Object)obsidian);
        return ingredients;
    }

    public WeirdBeaconRecipe() {
        super("", 3, 3, WeirdBeaconRecipe.createIngredients(), RESULT);
        this.setRegistryName(ChiseledMe.ns("weird_beacon"));
    }

    public NonNullList<ItemStack> func_179532_b(InventoryCrafting inv) {
        AdvancementTriggers.WEIRD_BEACON_CRAFT.trigger(ForgeHooks.getCraftingPlayer());
        return super.func_179532_b(inv);
    }

    @SubscribeEvent
    public static void on(RegistryEvent.Register<IRecipe> e) {
        e.getRegistry().register((IForgeRegistryEntry)new WeirdBeaconRecipe());
        ShapedRecipes beaconRecipe = (ShapedRecipes)CraftingManager.field_193380_a.func_82594_a((Object)new ResourceLocation("beacon"));
        if (beaconRecipe == null) {
            Log.warn("Did not found the vanilla beacon recipe to fix");
            return;
        }
        NonNullList ingredients = beaconRecipe.func_192400_c();
        final Ingredient ore = (Ingredient)ingredients.get(4);
        Ingredient fixed = new Ingredient(ore.func_193365_a()){

            public ItemStack[] func_193365_a() {
                return ore.func_193365_a();
            }

            @SideOnly(value=Side.CLIENT)
            public IntList func_194139_b() {
                return ore.func_194139_b();
            }

            public boolean apply(@Nullable ItemStack stack) {
                return (stack == null || stack.func_77973_b() != BLUE_STAR) && ore.apply(stack);
            }
        };
        ingredients.set(4, (Object)fixed);
    }

    static {
        RESULT = new ItemStack((Block)Blocks.field_150461_bJ);
    }
}

