/*
 * Decompiled with CFR 0.152.
 */
package dev.necauqua.mods.cm.recipes;

import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import dev.necauqua.mods.cm.ChiseledMe;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.EnchantmentPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.NBTPredicate;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.advancements.critereon.ItemPredicates;
import net.minecraftforge.common.crafting.IIngredientFactory;
import net.minecraftforge.common.crafting.JsonContext;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public final class PotionIngredientFactory
implements IIngredientFactory {
    private static final Map<String, Item> potionTypes = new HashMap<String, Item>();

    private static Item getPotionItem(JsonObject json) {
        String potionType = JsonUtils.func_151219_a((JsonObject)json, (String)"potion_type", (String)"regular");
        Item item = potionTypes.get(potionType);
        if (item == null) {
            throw new JsonSyntaxException("Expected potion_type to be one of regular, splash or lingering, was " + potionType);
        }
        return item;
    }

    private static PotionType getPotion(@Nullable JsonContext context, JsonObject json) {
        String s = JsonUtils.func_151200_h((JsonObject)json, (String)"potion");
        String potionName = context == null ? s : context.appendModId(s);
        PotionType potion = PotionType.func_185168_a((String)potionName);
        if (potion == null) {
            throw new JsonSyntaxException("No potion registered for name " + potionName);
        }
        return potion;
    }

    @Nonnull
    public Ingredient parse(JsonContext context, JsonObject json) {
        final Item item = PotionIngredientFactory.getPotionItem(json);
        final PotionType potion = PotionIngredientFactory.getPotion(context, json);
        return new Ingredient(new ItemStack[]{PotionUtils.func_185188_a((ItemStack)new ItemStack(item), (PotionType)potion)}){

            public boolean apply(@Nullable ItemStack stack) {
                return stack != null && stack.func_77973_b() == item && PotionUtils.func_185191_c((ItemStack)stack) == potion;
            }
        };
    }

    @SubscribeEvent
    public static void itemPredicateHack(RegistryEvent.Register<IRecipe> e) {
        ItemPredicates.register((ResourceLocation)ChiseledMe.ns("potion"), json -> {
            Item item = PotionIngredientFactory.getPotionItem(json);
            PotionType potion = PotionIngredientFactory.getPotion(null, json);
            return new ItemPredicate(item, null, MinMaxBounds.field_192516_a, MinMaxBounds.field_192516_a, new EnchantmentPredicate[0], potion, NBTPredicate.field_193479_a);
        });
    }

    static {
        potionTypes.put("regular", (Item)Items.field_151068_bn);
        potionTypes.put("splash", (Item)Items.field_185155_bH);
        potionTypes.put("lingering", (Item)Items.field_185156_bI);
    }
}

