/*
 * Decompiled with CFR 0.152.
 */
package dev.necauqua.mods.cm.advancements;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import dev.necauqua.mods.cm.ChiseledMe;
import dev.necauqua.mods.cm.advancements.AdvancementTrigger;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.advancements.ICriterionTrigger;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;

public final class SizeTrigger
extends AdvancementTrigger<Instance> {
    private static final ResourceLocation ID = ChiseledMe.ns("size");
    private static final Map<String, SizeMatcher> MATCHERS = new HashMap<String, SizeMatcher>();
    public static final SizeTrigger INSTANCE = new SizeTrigger();

    @ChiseledMe.Init
    private static void init() {
        CriteriaTriggers.func_192118_a((ICriterionTrigger)INSTANCE);
    }

    private SizeTrigger() {
        super(ID);
    }

    public Instance deserializeInstance(JsonObject json, JsonDeserializationContext context) {
        float size = JsonUtils.func_151217_k((JsonObject)json, (String)"size");
        String matchStr = JsonUtils.func_151219_a((JsonObject)json, (String)"match", (String)"exact");
        SizeMatcher matcher = MATCHERS.get(matchStr);
        if (matcher == null) {
            throw new JsonSyntaxException("Expected match to be one of " + String.join((CharSequence)", ", MATCHERS.keySet()) + ", was " + matchStr);
        }
        return new Instance(size, matcher);
    }

    public void trigger(EntityPlayer player, double fromSize, double toSize) {
        this.trigger(player, instance -> instance.matches(fromSize, toSize));
    }

    static {
        MATCHERS.put("exact", (fromSize, toSize, condition) -> toSize == condition);
        MATCHERS.put("crossing", (fromSize, toSize, condition) -> fromSize < toSize ? fromSize <= condition && condition <= toSize : toSize <= condition && condition <= fromSize);
        MATCHERS.put("lt", (fromSize, toSize, condition) -> toSize < condition);
        MATCHERS.put("gt", (fromSize, toSize, condition) -> toSize > condition);
        MATCHERS.put("le", (fromSize, toSize, condition) -> toSize <= condition);
        MATCHERS.put("ge", (fromSize, toSize, condition) -> toSize >= condition);
    }

    public static final class Instance
    implements ICriterionInstance {
        private final float size;
        private final SizeMatcher matcher;

        public Instance(float size, SizeMatcher matcher) {
            this.size = size;
            this.matcher = matcher;
        }

        public boolean matches(double fromSize, double toSize) {
            return this.matcher.match(fromSize, toSize, this.size);
        }

        public ResourceLocation func_192244_a() {
            return ID;
        }
    }

    @FunctionalInterface
    public static interface SizeMatcher {
        public boolean match(double var1, double var3, double var5);
    }
}

