/*
 * Decompiled with CFR 0.152.
 */
package dev.necauqua.mods.cm;

import dev.necauqua.mods.cm.Log;
import dev.necauqua.mods.cm.SidedHandler;
import dev.necauqua.mods.cm.SizeofCommand;
import dev.necauqua.mods.cm.item.ItemMod;
import dev.necauqua.mods.cm.item.ItemRecalibrator;
import java.io.IOException;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.command.ICommand;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.GameRules;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import net.minecraftforge.fml.common.event.FMLFingerprintViolationEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod(modid="chiseled_me", version="1.12-3.0.0.0-git-a115511", acceptedMinecraftVersions="[1.12,1.12.2]", updateJSON="https://raw.githubusercontent.com/necauqua/chiseled-me.wiki/master/updates.json", certificateFingerprint="c677c954974252994736eb15e855e1e6fc5a2e62", useMetadata=true)
public final class ChiseledMe {
    public static final String MODID = "chiseled_me";
    public static final float LOWER_LIMIT = 2.4414062E-4f;
    public static final float UPPER_LIMIT = 16.0f;
    public static final String ENTITY_SIZE_RULE = "chiseled_me:defaultEntitySize";
    public static final String PLAYER_SIZE_RULE = "chiseled_me:defaultPlayerSize";
    public static final CreativeTabs TAB = new CreativeTabs("chiseled_me"){

        @Nonnull
        public ItemStack func_78016_d() {
            return RECALIBRATOR.create(ItemRecalibrator.RecalibrationType.REDUCTION, (byte)1);
        }
    };
    private static final ItemRecalibrator RECALIBRATOR = new ItemRecalibrator();
    private static final ItemMod BLUE_STAR = new ItemMod("blue_star").setGlowing();
    private static final Item[] ITEMS = new Item[]{RECALIBRATOR, BLUE_STAR, new ItemMod("pym_container"), new ItemMod("pym_container_x").func_77625_d(16), new ItemMod("pym_essence").func_77625_d(42), new ItemMod("pym_essence_x").func_77625_d(13), new ItemMod("pym_essence_b").func_77625_d(7)};

    @Mod.EventHandler
    public void on(FMLPreInitializationEvent e) {
        try {
            for (ASMDataTable.ASMData asmData : e.getAsmData().getAll(Init.class.getName())) {
                String objectName = asmData.getObjectName();
                String name = objectName.substring(0, objectName.indexOf(40));
                Method method = Class.forName(asmData.getClassName()).getDeclaredMethod(name, new Class[0]);
                Log.debug("Found init method " + method);
                method.setAccessible(true);
                method.invoke(null, new Object[0]);
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException e1) {
            throw new AssertionError("This should not happen", e1);
        }
        catch (InvocationTargetException e1) {
            ChiseledMe.rethrow(e1.getCause());
        }
        try {
            for (String s : e.getAsmData().getAll(SubscribeEvent.class.getName()).stream().map(ASMDataTable.ASMData::getClassName).filter(cls -> cls.startsWith("dev.necauqua.mods.cm")).collect(Collectors.toSet())) {
                MinecraftForge.EVENT_BUS.register(Class.forName(s));
            }
        }
        catch (ClassNotFoundException ex) {
            throw new AssertionError("This should not happen", ex);
        }
    }

    @Mod.EventHandler
    public void on(FMLInitializationEvent e) {
        try {
            Class.forName("micdoodle8.mods.galacticraft.core.GalacticraftCore").getField("isHeightConflictingModInstalled").set(null, true);
            Launch.classLoader.getClassBytes("micdoodle8.mods.galacticraft.core.entities.player.GCEntityClientPlayerMP");
        }
        catch (IOException | ClassNotFoundException | IllegalAccessException | NoSuchFieldException exception) {
            // empty catch block
        }
    }

    @Mod.EventHandler
    public void on(FMLFingerprintViolationEvent e) {
        Log.warn("FINGERPRINT VIOLATED: you're running some unauthorized modification of the mod, be warned. No support will be provided for any issues encountered while using this jar.");
    }

    @SubscribeEvent
    public static void on(RegistryEvent.Register<Item> e) {
        e.getRegistry().registerAll((IForgeRegistryEntry[])ITEMS);
        OreDictionary.registerOre((String)"netherStar", (Item)BLUE_STAR);
    }

    @SubscribeEvent
    public static void on(ModelRegistryEvent e) {
        Arrays.stream(ITEMS).forEach(SidedHandler.instance::registerDefaultModel);
    }

    @SubscribeEvent
    public static void on(PlayerEvent.NameFormat e) {
        UUID id = e.getEntityPlayer().func_146103_bH().getId();
        if (id.getMostSignificantBits() == -464271648828012347L && id.getLeastSignificantBits() == -8770929174043197891L) {
            e.setDisplayname("\u00a7o\u00a7dnecauqua\u00a7r");
        }
    }

    @Mod.EventHandler
    public void on(FMLServerStartingEvent e) {
        e.registerServerCommand((ICommand)new SizeofCommand());
        GameRules gameRules = e.getServer().func_71218_a(0).func_82736_K();
        gameRules.func_180262_a(ENTITY_SIZE_RULE, "1", GameRules.ValueType.ANY_VALUE);
        gameRules.func_180262_a(PLAYER_SIZE_RULE, "1", GameRules.ValueType.ANY_VALUE);
    }

    public static ResourceLocation ns(String id) {
        return new ResourceLocation(MODID, id);
    }

    private static <E extends Throwable> void rethrow(Throwable exception) throws E {
        throw exception;
    }

    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Init {
    }
}

