/*
 * Decompiled with CFR 0.152.
 */
package subaraki.paintings.mod.entity;

import com.mcf.davidee.paintinggui.wrapper.PaintingWrapper;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityHanging;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;

public class EntityNewPainting
extends EntityHanging
implements IEntityAdditionalSpawnData {
    public String art = PaintingWrapper.createDefault("").getTitle();

    public EntityNewPainting(World worldIn) {
        super(worldIn);
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack(Items.field_151159_an, 1);
    }

    public void updateBB() {
        this.func_174859_a(this.field_174860_b);
    }

    public void func_70107_b(double x, double y, double z) {
        this.field_174861_a = new BlockPos(x, y, z);
        this.field_70160_al = true;
    }

    public void func_70014_b(NBTTagCompound compound) {
        compound.func_74778_a("Motive", this.art);
        super.func_70014_b(compound);
    }

    public void func_70037_a(NBTTagCompound compound) {
        String motive = compound.func_74779_i("Motive");
        if (PaintingWrapper.PAINTINGS.containsKey(motive)) {
            this.art = motive;
        } else if (!motive.equals("Default")) {
            this.art = PaintingWrapper.createDefault(motive).getTitle();
        }
        super.func_70037_a(compound);
    }

    public int func_82329_d() {
        return PaintingWrapper.PAINTINGS.get(this.art).getX();
    }

    public int func_82330_g() {
        return PaintingWrapper.PAINTINGS.get(this.art).getY();
    }

    public void func_110128_b(@Nullable Entity brokenEntity) {
        if (this.field_70170_p.func_82736_K().func_82766_b("doEntityDrops")) {
            this.func_184185_a(SoundEvents.field_187691_dJ, 1.0f, 1.0f);
            if (brokenEntity instanceof EntityPlayer) {
                EntityPlayer entityplayer = (EntityPlayer)brokenEntity;
                if (entityplayer.field_71075_bZ.field_75098_d) {
                    return;
                }
            }
            this.func_70099_a(new ItemStack(Items.field_151159_an), 0.0f);
        }
    }

    public void func_184523_o() {
        this.func_184185_a(SoundEvents.field_187694_dK, 1.0f, 1.0f);
    }

    public void writeSpawnData(ByteBuf buffer) {
        ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)this.art);
        buffer.writeByte(this.field_174860_b.func_176736_b());
        buffer.writeFloat(this.field_70177_z);
        buffer.writeDouble((double)this.field_174861_a.func_177958_n());
        buffer.writeDouble((double)this.field_174861_a.func_177956_o());
        buffer.writeDouble((double)this.field_174861_a.func_177952_p());
    }

    public void readSpawnData(ByteBuf additionalData) {
        if (additionalData.isReadable()) {
            String original;
            String arttitle = ByteBufUtils.readUTF8String((ByteBuf)additionalData);
            this.art = arttitle.toLowerCase().contains("errored") ? (PaintingWrapper.PAINTINGS.containsKey(original = arttitle.split("errored")[1]) ? original : arttitle) : (PaintingWrapper.PAINTINGS.containsKey(arttitle) ? arttitle : PaintingWrapper.createDefault(arttitle).getTitle());
            this.field_174860_b = EnumFacing.func_176731_b((int)additionalData.readByte());
            this.field_70177_z = additionalData.readFloat();
            this.func_70107_b(additionalData.readDouble(), additionalData.readDouble(), additionalData.readDouble());
            this.updateBB();
        }
    }

    protected void func_174856_o() {
        if (this.field_174860_b != null) {
            double hangX = (double)this.func_174857_n().func_177958_n() + 0.5;
            double hangY = (double)this.func_174857_n().func_177956_o() + 0.5;
            double hangZ = (double)this.func_174857_n().func_177952_p() + 0.5;
            double offsetWidth = this.func_82329_d() % 32 == 0 ? 0.5 : 0.0;
            double offsetHeight = this.func_82330_g() % 32 == 0 ? 0.5 : 0.0;
            hangX -= (double)this.field_174860_b.func_82601_c() * 0.46875;
            hangZ -= (double)this.field_174860_b.func_82599_e() * 0.46875;
            EnumFacing enumfacing = this.field_174860_b.func_176735_f();
            this.field_70165_t = hangX += offsetWidth * (double)enumfacing.func_82601_c();
            this.field_70163_u = hangY += offsetHeight;
            this.field_70161_v = hangZ += offsetWidth * (double)enumfacing.func_82599_e();
            double widthX = this.func_82329_d();
            double height = this.func_82330_g();
            double widthZ = this.func_82329_d();
            if (this.field_174860_b.func_176740_k() == EnumFacing.Axis.Z) {
                widthZ = 1.0;
            } else {
                widthX = 1.0;
            }
            this.func_174826_a(new AxisAlignedBB(hangX - (widthX /= 32.0), hangY - (height /= 32.0), hangZ - (widthZ /= 32.0), hangX + widthX, hangY + height, hangZ + widthZ));
        }
    }
}

