/*
 * Decompiled with CFR 0.152.
 */
package dynamictreesbop.trees.species;

import biomesoplenty.api.biome.BOPBiomes;
import com.ferreusveritas.dynamictrees.ModBlocks;
import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.treedata.IDropCreator;
import com.ferreusveritas.dynamictrees.items.Seed;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.trees.TreeFamily;
import dynamictreesbop.ModContent;
import dynamictreesbop.dropcreators.DropCreatorInvoluntarySeed;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;

public class SpeciesOakTwiglet
extends Species {
    public SpeciesOakTwiglet(TreeFamily treeFamily) {
        super(new ResourceLocation("dynamictreesbop", "oaktwiglet"), treeFamily, ModContent.leaves.get("oaksparse"));
        this.setBasicGrowingParameters(0.3f, 2.5f, 1, 2, 1.0f);
        this.envFactor(BiomeDictionary.Type.SNOWY, 0.25f);
        this.envFactor(BiomeDictionary.Type.DRY, 0.75f);
        this.envFactor(BiomeDictionary.Type.PLAINS, 1.05f);
        this.setRequiresTileEntity(true);
        this.addDropCreator((IDropCreator)new DropCreatorInvoluntarySeed());
        this.remDropCreator(new ResourceLocation("dynamictrees", "logs"));
        this.leavesProperties.setTree(treeFamily);
    }

    protected void setStandardSoils() {
        this.addAcceptableSoils(new String[]{"dirtlike", "hardclaylike"});
    }

    public Species.LogsAndSticks getLogsAndSticks(float volume) {
        return super.getLogsAndSticks(volume * 16.0f);
    }

    public boolean isBiomePerfect(Biome biome) {
        return SpeciesOakTwiglet.isOneOfBiomes((Biome)biome, (Biome[])new Biome[]{(Biome)BOPBiomes.chaparral.orNull(), (Biome)BOPBiomes.lush_desert.orNull()});
    }

    public ItemStack getSeedStack(int qty) {
        return this.getFamily().getCommonSpecies().getSeedStack(qty);
    }

    public Seed getSeed() {
        return this.getFamily().getCommonSpecies().getSeed();
    }

    public boolean rot(World world, BlockPos pos, int neighborCount, int radius, Random random, boolean rapid) {
        if (super.rot(world, pos, neighborCount, radius, random, rapid)) {
            if (TreeHelper.isRooty((IBlockState)world.func_180495_p(pos.func_177977_b())) && world.func_175642_b(EnumSkyBlock.SKY, pos) < 4) {
                world.func_175656_a(pos, random.nextInt(3) == 0 ? ModBlocks.blockStates.redMushroom : ModBlocks.blockStates.brownMushroom);
            }
            return true;
        }
        return false;
    }
}

