/*
 * Decompiled with CFR 0.152.
 */
package dynamictreesbop.trees.species;

import biomesoplenty.api.biome.BOPBiomes;
import biomesoplenty.api.enums.BOPTrees;
import biomesoplenty.api.item.BOPItems;
import biomesoplenty.common.block.BlockBOPLeaves;
import com.ferreusveritas.dynamictrees.ModBlocks;
import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.treedata.IDropCreator;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.trees.TreeFamily;
import dynamictreesbop.ModContent;
import dynamictreesbop.dropcreators.DropCreatorFruit;
import dynamictreesbop.items.ItemMapleSeed;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;

public class SpeciesMaple
extends Species {
    public SpeciesMaple(TreeFamily treeFamily) {
        super(new ResourceLocation("dynamictreesbop", "maple"), treeFamily, ModContent.leaves.get("maple"));
        this.setBasicGrowingParameters(0.15f, 14.0f, 4, 4, 1.05f);
        this.envFactor(BiomeDictionary.Type.HOT, 0.5f);
        this.envFactor(BiomeDictionary.Type.DRY, 0.5f);
        this.envFactor(BiomeDictionary.Type.FOREST, 1.05f);
        ItemMapleSeed seed = new ItemMapleSeed(this.getRegistryName().func_110623_a() + "seed");
        this.setSeedStack(new ItemStack((Item)seed));
        this.addDropCreator((IDropCreator)new DropCreatorFruit(BOPItems.persimmon));
        this.setupStandardSeedDropping();
        this.setRequiresTileEntity(true);
        this.leavesProperties.setTree(treeFamily);
        treeFamily.addConnectableVanillaLeaves(state -> state.func_177230_c() instanceof BlockBOPLeaves && state.func_177229_b(((BlockBOPLeaves)state.func_177230_c()).variantProperty) == BOPTrees.MAPLE);
    }

    public boolean isBiomePerfect(Biome biome) {
        return SpeciesMaple.isOneOfBiomes((Biome)biome, (Biome[])new Biome[]{(Biome)BOPBiomes.seasonal_forest.orNull(), (Biome)BOPBiomes.maple_woods.orNull()});
    }

    public int maxBranchRadius() {
        return 8;
    }

    public boolean rot(World world, BlockPos pos, int neighborCount, int radius, Random random, boolean rapid) {
        if (super.rot(world, pos, neighborCount, radius, random, rapid)) {
            if (radius > 4 && TreeHelper.isRooty((IBlockState)world.func_180495_p(pos.func_177977_b())) && world.func_175642_b(EnumSkyBlock.SKY, pos) < 4) {
                world.func_175656_a(pos, random.nextInt(3) == 0 ? ModBlocks.blockStates.redMushroom : ModBlocks.blockStates.brownMushroom);
                world.func_175656_a(pos.func_177977_b(), ModBlocks.blockStates.podzol);
            }
            return true;
        }
        return false;
    }
}

