/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.gottschcore.random;

import java.util.Map;
import java.util.NavigableMap;
import java.util.Random;
import java.util.TreeMap;

public class RandomWeightedCollection<T> {
    private final NavigableMap<Integer, T> map = new TreeMap<Integer, T>();
    private Random random;
    private int total = 0;

    public RandomWeightedCollection() {
        this.setRandom(new Random());
    }

    public RandomWeightedCollection(Random random) {
        this.setRandom(random);
    }

    public void add(int weight, T item) {
        if (weight <= 0) {
            return;
        }
        this.total += weight;
        this.map.put(this.total, item);
    }

    public T next() {
        if (this.map.isEmpty() || this.total < 1) {
            return null;
        }
        int value = this.getRandom().nextInt(this.total);
        return this.map.ceilingEntry(value).getValue();
    }

    public void clear() {
        this.map.clear();
        this.setTotal(0);
    }

    public int size() {
        if (this.map == null) {
            return 0;
        }
        return this.map.size();
    }

    public Random getRandom() {
        return this.random;
    }

    public void setRandom(Random random) {
        this.random = random;
    }

    private int getTotal() {
        return this.total;
    }

    private void setTotal(int total) {
        this.total = total;
    }

    public Map<Integer, T> getMap() {
        return this.map;
    }
}

