/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.gottschcore.enums;

import com.someguyssoftware.gottschcore.enums.Alignment;
import com.someguyssoftware.gottschcore.enums.IEnum;
import com.someguyssoftware.gottschcore.enums.Rotate;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.util.EnumFacing;

public enum Direction implements IEnum
{
    UP(0, "Up", Alignment.VERTICAL),
    DOWN(1, "Down", Alignment.VERTICAL),
    NORTH(2, "North", Alignment.HORIZONTAL),
    EAST(3, "East", Alignment.HORIZONTAL),
    SOUTH(4, "South", Alignment.HORIZONTAL),
    WEST(5, "West", Alignment.HORIZONTAL);

    private static final Map<Integer, IEnum> codes;
    private static final Map<String, IEnum> values;
    private Integer code;
    private String value;
    private Alignment alignment;

    private Direction(Integer code, String value) {
        this.code = code;
        this.value = value;
    }

    private Direction(Integer code, String value, Alignment plane) {
        this.code = code;
        this.value = value;
        this.alignment = plane;
    }

    public boolean isSamePlane(Alignment plane) {
        return this.getAlignment() == plane;
    }

    public Direction rotate(Rotate r) {
        switch (r) {
            case NO_ROTATE: {
                return this;
            }
            case ROTATE_90: {
                switch (this) {
                    case NORTH: {
                        return EAST;
                    }
                    case EAST: {
                        return SOUTH;
                    }
                    case SOUTH: {
                        return WEST;
                    }
                    case WEST: {
                        return NORTH;
                    }
                }
                return this;
            }
            case ROTATE_180: {
                switch (this) {
                    case NORTH: {
                        return SOUTH;
                    }
                    case EAST: {
                        return WEST;
                    }
                    case SOUTH: {
                        return NORTH;
                    }
                    case WEST: {
                        return EAST;
                    }
                }
                return this;
            }
            case ROTATE_270: {
                switch (this) {
                    case NORTH: {
                        return WEST;
                    }
                    case EAST: {
                        return NORTH;
                    }
                    case SOUTH: {
                        return EAST;
                    }
                    case WEST: {
                        return SOUTH;
                    }
                }
                return this;
            }
        }
        return this;
    }

    public Rotate getRotation(Direction direction) {
        switch (direction) {
            case NORTH: {
                switch (this) {
                    case NORTH: {
                        return Rotate.NO_ROTATE;
                    }
                    case EAST: {
                        return Rotate.ROTATE_270;
                    }
                    case SOUTH: {
                        return Rotate.ROTATE_180;
                    }
                    case WEST: {
                        return Rotate.ROTATE_90;
                    }
                }
                return Rotate.NO_ROTATE;
            }
            case EAST: {
                switch (this) {
                    case NORTH: {
                        return Rotate.ROTATE_90;
                    }
                    case EAST: {
                        return Rotate.NO_ROTATE;
                    }
                    case SOUTH: {
                        return Rotate.ROTATE_270;
                    }
                    case WEST: {
                        return Rotate.ROTATE_180;
                    }
                }
                return Rotate.NO_ROTATE;
            }
            case SOUTH: {
                switch (this) {
                    case NORTH: {
                        return Rotate.ROTATE_180;
                    }
                    case EAST: {
                        return Rotate.ROTATE_90;
                    }
                    case SOUTH: {
                        return Rotate.NO_ROTATE;
                    }
                    case WEST: {
                        return Rotate.ROTATE_270;
                    }
                }
                return Rotate.NO_ROTATE;
            }
            case WEST: {
                switch (this) {
                    case NORTH: {
                        return Rotate.ROTATE_270;
                    }
                    case EAST: {
                        return Rotate.ROTATE_180;
                    }
                    case SOUTH: {
                        return Rotate.ROTATE_90;
                    }
                    case WEST: {
                        return Rotate.NO_ROTATE;
                    }
                }
                return Rotate.NO_ROTATE;
            }
        }
        return Rotate.NO_ROTATE;
    }

    public static Direction fromFacing(EnumFacing facing) {
        switch (facing) {
            case NORTH: {
                return NORTH;
            }
            case EAST: {
                return EAST;
            }
            case SOUTH: {
                return SOUTH;
            }
            case WEST: {
                return WEST;
            }
            case UP: {
                return UP;
            }
            case DOWN: {
                return DOWN;
            }
        }
        return NORTH;
    }

    public EnumFacing toFacing() {
        switch (this) {
            case NORTH: {
                return EnumFacing.NORTH;
            }
            case EAST: {
                return EnumFacing.EAST;
            }
            case SOUTH: {
                return EnumFacing.SOUTH;
            }
            case WEST: {
                return EnumFacing.WEST;
            }
            case UP: {
                return EnumFacing.UP;
            }
            case DOWN: {
                return EnumFacing.DOWN;
            }
        }
        return EnumFacing.NORTH;
    }

    @Override
    public String getName() {
        return this.name();
    }

    @Override
    public Integer getCode() {
        return this.code;
    }

    @Override
    public void setCode(Integer code) {
        this.code = code;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public void setValue(String value) {
        this.value = value;
    }

    public static Direction getByCode(Integer code) {
        return (Direction)codes.get(code);
    }

    public static Direction getByValue(String value) {
        return (Direction)values.get(value);
    }

    @Override
    public Map<Integer, IEnum> getCodes() {
        return codes;
    }

    @Override
    public Map<String, IEnum> getValues() {
        return values;
    }

    public Map<String, IEnum> getValuesByAlignment(Alignment alignment) {
        HashMap<String, IEnum> map = new HashMap<String, IEnum>();
        for (Map.Entry<String, IEnum> e : this.getValues().entrySet()) {
            if (((Direction)e.getValue()).getAlignment() != alignment) continue;
            map.put(e.getKey(), e.getValue());
        }
        return map;
    }

    public Alignment getAlignment() {
        return this.alignment;
    }

    public void setAlignment(Alignment alignment) {
        this.alignment = alignment;
    }

    static {
        codes = new HashMap<Integer, IEnum>();
        values = new HashMap<String, IEnum>();
        for (Direction ps : EnumSet.allOf(Direction.class)) {
            codes.put(ps.getCode(), ps);
            values.put(ps.getValue(), ps);
        }
    }
}

