/*
 * Decompiled with CFR 0.152.
 */
package malte0811.industrialwires.compat;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.tool.ToolboxHandler;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import crafttweaker.CraftTweakerAPI;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergyTile;
import ic2.api.item.IBoxable;
import ic2.api.item.IC2Items;
import ic2.core.block.TileEntityBlock;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import malte0811.industrialwires.compat.CTMarxGenerator;
import malte0811.industrialwires.compat.CompatCapabilities;
import malte0811.industrialwires.compat.IBlockAction;
import malte0811.industrialwires.hv.MarxOreHandler;
import malte0811.industrialwires.mech_mb.MechPartCommutator;
import mrtjp.projectred.api.ProjectRedAPI;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.eventhandler.Event;
import pl.asie.charset.api.wires.IBundledEmitter;
import pl.asie.charset.api.wires.IBundledReceiver;

public class Compat {
    public static final String IC2_ID = "ic2";
    public static final String CRAFTTWEAKER_ID = "crafttweaker";
    public static final String CHARSET_ID = "charset";
    public static BiFunction<ItemStack, Template.BlockInfo, ItemStack> stackFromInfo = (s, i) -> s;
    public static BiFunction<String, String, List<ItemStack>> getIC2Item = (s, s2) -> ImmutableList.of();
    static Consumer<MarxOreHandler.OreInfo> addMarx = o -> {};
    static Consumer<MarxOreHandler.OreInfo> removeMarx = o -> {};
    public static Consumer<TileEntity> loadIC2Tile = te -> {};
    public static Consumer<TileEntity> unloadIC2Tile = te -> {};
    public static IBlockAction<EnumFacing, byte[]> getBundledRS = (w, p, f) -> new byte[16];
    public static IBlockAction<Void, Void> updateBundledRS = (w, p, f) -> null;
    public static boolean enableOtherRS = false;
    private static Map<String, Class<? extends CompatModule>> modules = ImmutableMap.of((Object)"ic2", CompatIC2.class, (Object)"crafttweaker", CompatCT.class, (Object)"projectred-core", CompatProjectRed.class, (Object)"charset", CompatCharset.class);
    private static Method preInit;
    private static Method init;

    public static void preInit() {
        for (Map.Entry<String, Class<? extends CompatModule>> e : modules.entrySet()) {
            if (!Loader.isModLoaded((String)e.getKey())) continue;
            try {
                preInit.invoke((Object)e.getValue().newInstance(), new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e1) {
                e1.printStackTrace();
            }
        }
    }

    public static void init() {
        for (Map.Entry<String, Class<? extends CompatModule>> e : modules.entrySet()) {
            if (!Loader.isModLoaded((String)e.getKey())) continue;
            try {
                init.invoke((Object)e.getValue().newInstance(), new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e1) {
                e1.printStackTrace();
            }
        }
    }

    static {
        try {
            preInit = CompatModule.class.getMethod("preInit", new Class[0]);
            init = CompatModule.class.getMethod("init", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
    }

    public static class CompatCharset
    extends CompatModule {
        @Override
        public void preInit() {
            enableOtherRS = true;
        }

        @Override
        public void init() {
            super.init();
            IBlockAction<EnumFacing, byte[]> old = getBundledRS;
            getBundledRS = (w, p, f) -> {
                byte[] oldIn = (byte[])old.run(w, p, (EnumFacing)f);
                TileEntity te = w.func_175625_s(p.func_177972_a(f));
                if (te != null && te.hasCapability(CompatCapabilities.Charset.EMITTER_CAP, f.func_176734_d())) {
                    IBundledEmitter emitter = (IBundledEmitter)te.getCapability(CompatCapabilities.Charset.EMITTER_CAP, f.func_176734_d());
                    assert (emitter != null);
                    byte[] charIn = emitter.getBundledSignal();
                    if (charIn != null) {
                        for (int i = 0; i < 16; ++i) {
                            if (charIn[i] <= oldIn[i]) continue;
                            oldIn[i] = charIn[i];
                        }
                    }
                }
                return oldIn;
            };
            IBlockAction<Void, Void> oldUpdate = updateBundledRS;
            updateBundledRS = (w, p, __) -> {
                oldUpdate.run(w, p, (Void)__);
                for (EnumFacing face : EnumFacing.field_82609_l) {
                    TileEntity te = w.func_175625_s(p.func_177972_a(face.func_176734_d()));
                    if (te == null || !te.hasCapability(CompatCapabilities.Charset.RECEIVER_CAP, face)) continue;
                    IBundledReceiver receiver = (IBundledReceiver)te.getCapability(CompatCapabilities.Charset.RECEIVER_CAP, face);
                    assert (receiver != null);
                    receiver.onBundledInputChange();
                }
                return null;
            };
        }
    }

    public static class CompatProjectRed
    extends CompatModule {
        @Override
        public void preInit() {
            enableOtherRS = true;
        }

        @Override
        public void init() {
            super.init();
            IBlockAction<EnumFacing, byte[]> oldGet = getBundledRS;
            getBundledRS = (w, p, f) -> {
                byte[] oldIn = (byte[])oldGet.run(w, p, (EnumFacing)f);
                byte[] prIn = ProjectRedAPI.transmissionAPI.getBundledInput(w, p, f);
                if (prIn != null) {
                    for (int i = 0; i < 16; ++i) {
                        oldIn[i] = (byte)Math.ceil((double)(prIn[i] & 0xFF) / 17.0);
                    }
                }
                return oldIn;
            };
            IBlockAction<Void, Void> oldUpdate = updateBundledRS;
            updateBundledRS = (w, p, f) -> {
                oldUpdate.run(w, p, (Void)f);
                w.func_175685_c(p, w.func_180495_p(p).func_177230_c(), true);
                return null;
            };
        }
    }

    public static class CompatIC2
    extends CompatModule {
        @Override
        public void preInit() {
            loadIC2Tile = te -> {
                if (!te.func_145831_w().field_72995_K) {
                    MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent((IEnergyTile)te));
                }
            };
            unloadIC2Tile = te -> {
                if (!te.func_145831_w().field_72995_K) {
                    MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent((IEnergyTile)te));
                }
            };
            getIC2Item = (type, variant) -> ImmutableList.of((Object)IC2Items.getItem((String)type, (String)variant));
        }

        @Override
        public void init() {
            Item tinnedFood = IC2Items.getItem((String)"filled_tin_can").func_77973_b();
            ItemStack emptyMug = IC2Items.getItem((String)"mug", (String)"empty");
            ToolboxHandler.addFoodType(s -> s.func_77973_b() == tinnedFood);
            ToolboxHandler.addFoodType(s -> s.func_77973_b() == emptyMug.func_77973_b() && !ItemStack.func_77989_b((ItemStack)emptyMug, (ItemStack)ApiUtils.copyStackWithAmount((ItemStack)s, (int)1)));
            Item cable = IC2Items.getItem((String)"cable", (String)"type:copper,insulation:0").func_77973_b();
            ToolboxHandler.addWiringType((s, w) -> s.func_77973_b() == cable);
            ToolboxHandler.addToolType(s -> {
                Item a = s.func_77973_b();
                return a instanceof IBoxable && ((IBoxable)a).canBeStoredInToolbox(s);
            });
            MechPartCommutator.originalStack = IC2Items.getItem((String)"te", (String)"kinetic_generator");
            try {
                Class<?> teb = Class.forName("ic2.core.block.TileEntityBlock");
                Method getPickBlock = teb.getDeclaredMethod("getPickBlock", EntityPlayer.class, RayTraceResult.class);
                getPickBlock.setAccessible(true);
                ResourceLocation IC2_TE = new ResourceLocation(Compat.IC2_ID, "te");
                stackFromInfo = (stack, info) -> {
                    try {
                        TileEntity te;
                        if (info.field_186244_c != null && IC2_TE.equals((Object)info.field_186243_b.func_177230_c().getRegistryName()) && (te = TileEntity.func_190200_a(null, (NBTTagCompound)info.field_186244_c)) instanceof TileEntityBlock) {
                            stack = (ItemStack)getPickBlock.invoke((Object)te, new Object[]{null, null});
                        }
                    }
                    catch (IllegalAccessException | NullPointerException | InvocationTargetException x) {
                        x.printStackTrace();
                    }
                    return stack;
                };
            }
            catch (Exception x) {
                x.printStackTrace();
            }
        }
    }

    public static class CompatCT
    extends CompatModule {
        @Override
        public void preInit() {
            CraftTweakerAPI.registerClass(CTMarxGenerator.class);
        }
    }

    static abstract class CompatModule {
        CompatModule() {
        }

        public void preInit() {
        }

        public void init() {
        }
    }
}

