/*
 * Decompiled with CFR 0.152.
 */
package malte0811.industrialwires.blocks.hv;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.TargetingInfo;
import blusunrize.immersiveengineering.api.energy.wires.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.energy.wires.ImmersiveNetHandler;
import blusunrize.immersiveengineering.api.energy.wires.WireType;
import blusunrize.immersiveengineering.api.energy.wires.redstone.IRedstoneConnector;
import blusunrize.immersiveengineering.api.energy.wires.redstone.RedstoneWireNetwork;
import blusunrize.immersiveengineering.common.IESaveData;
import blusunrize.immersiveengineering.common.blocks.BlockTypes_MetalsIE;
import blusunrize.immersiveengineering.common.blocks.metal.BlockTypes_Connector;
import blusunrize.immersiveengineering.common.blocks.metal.BlockTypes_MetalDecoration0;
import blusunrize.immersiveengineering.common.blocks.metal.BlockTypes_MetalDecoration1;
import blusunrize.immersiveengineering.common.blocks.metal.BlockTypes_MetalDecoration2;
import blusunrize.immersiveengineering.common.blocks.metal.BlockTypes_MetalDevice0;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.chickenbones.Matrix4;
import com.elytradev.mirage.event.GatherLightsEvent;
import com.elytradev.mirage.lighting.Light;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.WeakHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import malte0811.industrialwires.IEObjects;
import malte0811.industrialwires.IMixedConnector;
import malte0811.industrialwires.IWConfig;
import malte0811.industrialwires.IWDamageSources;
import malte0811.industrialwires.IWPotions;
import malte0811.industrialwires.IndustrialWires;
import malte0811.industrialwires.blocks.IBlockBoundsIW;
import malte0811.industrialwires.blocks.ISyncReceiver;
import malte0811.industrialwires.blocks.IWProperties;
import malte0811.industrialwires.blocks.TileEntityIWMultiblock;
import malte0811.industrialwires.hv.IMarxTarget;
import malte0811.industrialwires.hv.MarxOreHandler;
import malte0811.industrialwires.network.MessageTileSyncIW;
import malte0811.industrialwires.util.ConversionUtil;
import malte0811.industrialwires.util.JouleEnergyStorage;
import malte0811.industrialwires.util.MiscUtils;
import malte0811.industrialwires.wires.EnergyType;
import malte0811.industrialwires.wires.MixedWireType;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

@Mod.EventBusSubscriber
public class TileEntityMarx
extends TileEntityIWMultiblock
implements ITickable,
ISyncReceiver,
IBlockBoundsIW,
IImmersiveConnectable,
IMixedConnector,
IRedstoneConnector {
    private static final Set<TileEntityMarx> FIRING_GENERATORS = Collections.newSetFromMap(new WeakHashMap());
    private double rcTimeConst;
    private double timeFactor;
    private double timeFactorBottom;
    private static final double CAPACITANCE = 1.6E-6;
    private static final double MAX_VOLTAGE = 250000.0;
    public IWProperties.MarxType type = IWProperties.MarxType.NO_MODEL;
    private int stageCount = 0;
    public FiringState state = FiringState.CHARGING;
    public Discharge dischargeData;
    private JouleEnergyStorage storage = new JouleEnergyStorage(50000.0, 640000.0);
    private boolean hasConnection;
    private double[] capVoltages;
    private int voltageControl = 0;
    private boolean loaded = false;
    private double leftover;
    private long lastUpdate = -1L;
    private AxisAlignedBB renderAabb = null;
    private AxisAlignedBB collisionAabb = null;
    private RedstoneWireNetwork net = new RedstoneWireNetwork();

    TileEntityMarx(EnumFacing facing, IWProperties.MarxType type, boolean mirrored) {
        this.facing = facing;
        this.type = type;
        this.mirrored = mirrored;
    }

    public TileEntityMarx() {
    }

    @Override
    public void writeNBT(NBTTagCompound out, boolean updatePacket) {
        super.writeNBT(out, updatePacket);
        MiscUtils.writeConnsToNBT(out, this);
        out.func_74768_a("type", this.type.ordinal());
        out.func_74768_a("stages", this.stageCount);
        out.func_74757_a("hasConn", this.hasConnection);
        this.storage.writeToNbt(out, "energy");
        NBTTagList voltages = new NBTTagList();
        if (this.capVoltages != null) {
            for (int i = 0; i < this.stageCount; ++i) {
                voltages.func_74742_a((NBTBase)new NBTTagDouble(this.capVoltages[i]));
            }
        }
        out.func_74782_a("capVoltages", (NBTBase)voltages);
    }

    @Override
    public void readNBT(NBTTagCompound in, boolean updatePacket) {
        super.readNBT(in, updatePacket);
        MiscUtils.loadConnsFromNBT(in, this);
        this.type = IWProperties.MarxType.values()[in.func_74762_e("type")];
        this.setStageCount(in.func_74762_e("stages"));
        NBTTagList voltages = in.func_150295_c("capVoltages", 6);
        this.capVoltages = new double[this.stageCount];
        for (int i = 0; i < this.stageCount; ++i) {
            this.capVoltages[i] = voltages.func_150309_d(i);
        }
        this.storage.readFromNBT(in.func_74775_l("energy"));
        this.hasConnection = in.func_74767_n("hasConn");
        this.collisionAabb = null;
        this.renderAabb = null;
    }

    @Override
    @Nonnull
    protected BlockPos getOrigin() {
        return this.func_174877_v().func_177973_b(this.offset).func_177967_a(this.facing.func_176734_d(), 3);
    }

    @Override
    public IBlockState getOriginalBlock() {
        int forward = this.getForward();
        int right = this.getRight();
        int up = this.offset.func_177956_o();
        if (forward == 0) {
            return IEObjects.blockMetalDevice0.func_176223_P().func_177226_a((IProperty)IEObjects.blockMetalDevice0.property, (Comparable)BlockTypes_MetalDevice0.CAPACITOR_HV);
        }
        if (forward == -1) {
            return IEObjects.blockConnectors.func_176223_P().func_177226_a((IProperty)IEObjects.blockConnectors.property, (Comparable)BlockTypes_Connector.RELAY_HV).func_177226_a((IProperty)IEProperties.FACING_ALL, (Comparable)this.facing);
        }
        if (forward == 4 && up == 0 && right == 1) {
            return IEObjects.blockStorage.func_176223_P().func_177226_a((IProperty)IEObjects.blockStorage.property, (Comparable)BlockTypes_MetalsIE.STEEL);
        }
        if (forward > 0) {
            if (right == 0 && up == 0 || right == 1 && up == this.stageCount - 1) {
                return IEObjects.blockMetalDecoration1.func_176223_P().func_177226_a((IProperty)IEObjects.blockMetalDecoration1.property, (Comparable)BlockTypes_MetalDecoration1.STEEL_FENCE);
            }
            return IEObjects.blockMetalDecoration2.func_176223_P().func_177226_a((IProperty)IEObjects.blockMetalDecoration2.property, (Comparable)BlockTypes_MetalDecoration2.STEEL_WALLMOUNT).func_177226_a((IProperty)IEProperties.INT_4, (Comparable)Integer.valueOf(1 - right)).func_177226_a((IProperty)IEProperties.FACING_ALL, (Comparable)this.facing.func_176734_d());
        }
        if (forward == -2) {
            return IEObjects.blockMetalDecoration0.func_176223_P().func_177226_a((IProperty)IEObjects.blockMetalDecoration0.property, (Comparable)BlockTypes_MetalDecoration0.HEAVY_ENGINEERING);
        }
        if (right == 0) {
            return IEObjects.blockConnectors.func_176223_P().func_177226_a((IProperty)IEObjects.blockConnectors.property, (Comparable)BlockTypes_Connector.CONNECTOR_REDSTONE).func_177226_a((IProperty)IEProperties.FACING_ALL, (Comparable)this.facing);
        }
        return IEObjects.blockConnectors.func_176223_P().func_177226_a((IProperty)IEObjects.blockConnectors.property, (Comparable)BlockTypes_Connector.CONNECTOR_HV).func_177226_a((IProperty)IEProperties.FACING_ALL, (Comparable)this.facing);
    }

    @Override
    public void disassemble() {
        boolean active = this.formed && !this.field_145850_b.field_72995_K;
        IndustrialWires.logger.info("Calling disassemble for {}, active {}", (Object)this.field_174879_c, (Object)active);
        super.disassemble();
        if (active) {
            int forward = -1;
            BlockPos master = this.field_174879_c.func_177973_b(this.offset);
            ItemStack coil = new ItemStack(IEObjects.itemWireCoil, 1, 2);
            WireType type = WireType.STEEL;
            TargetingInfo dummy = new TargetingInfo(EnumFacing.DOWN, 0.0f, 0.0f, 0.0f);
            for (int up = 0; up < this.stageCount - 1; ++up) {
                for (int right = 0; right < 2; ++right) {
                    BlockPos lowerPos = MiscUtils.offset(master, this.facing, this.mirrored, right, -1, up);
                    BlockPos upperPos = lowerPos.func_177984_a();
                    IndustrialWires.logger.info("Lower: {}, upper: {}, master: {}", (Object)lowerPos, (Object)upperPos, (Object)master);
                    TileEntity lowerTE = this.field_145850_b.func_175625_s(lowerPos);
                    if (!(lowerTE instanceof IImmersiveConnectable)) {
                        this.field_145850_b.func_72838_d((Entity)new EntityItem(this.field_145850_b, (double)lowerPos.func_177958_n() + 0.5, (double)lowerPos.func_177956_o() + 0.5, (double)lowerPos.func_177952_p() + 0.5, coil));
                        continue;
                    }
                    TileEntity upperTE = this.field_145850_b.func_175625_s(upperPos);
                    if (!(upperTE instanceof IImmersiveConnectable)) {
                        this.field_145850_b.func_72838_d((Entity)new EntityItem(this.field_145850_b, (double)lowerPos.func_177958_n() + 0.5, (double)lowerPos.func_177956_o() + 0.5, (double)lowerPos.func_177952_p() + 0.5, coil));
                        continue;
                    }
                    IImmersiveConnectable lowerIIC = (IImmersiveConnectable)lowerTE;
                    IImmersiveConnectable upperIIC = (IImmersiveConnectable)upperTE;
                    ImmersiveNetHandler.Connection conn = ImmersiveNetHandler.INSTANCE.addAndGetConnection(this.field_145850_b, lowerPos, upperPos, 1, type);
                    lowerIIC.connectCable(type, dummy, upperIIC);
                    upperIIC.connectCable(type, dummy, lowerIIC);
                    ImmersiveNetHandler.INSTANCE.addBlockData(this.field_145850_b, conn);
                    IESaveData.setDirty((int)this.field_145850_b.field_73011_w.getDimension());
                    lowerTE.func_70296_d();
                    IBlockState state = this.field_145850_b.func_180495_p(lowerPos);
                    this.field_145850_b.func_184138_a(lowerPos, state, state, 3);
                    upperTE.func_70296_d();
                    state = this.field_145850_b.func_180495_p(upperPos);
                    this.field_145850_b.func_184138_a(upperPos, state, state, 3);
                }
            }
        }
    }

    public void func_73660_a() {
        ApiUtils.checkForNeedlessTicking((TileEntity)this);
        FIRING_GENERATORS.remove(this);
        switch (this.state) {
            case NEXT_TICK: {
                if (this.field_145850_b.field_72995_K) {
                    FIRING_GENERATORS.add(this);
                    IndustrialWires.proxy.playMarxBang(this, this.getMiddle(), (float)this.getNormedEnergy(this.dischargeData.energy));
                } else {
                    this.fire();
                }
                this.state = FiringState.FIRE;
                break;
            }
            case FIRE: {
                this.state = FiringState.CHARGING;
            }
        }
        if (!this.field_145850_b.field_72995_K && this.type == IWProperties.MarxType.BOTTOM) {
            double tmp;
            double energyUsed;
            if (this.capVoltages == null || this.capVoltages.length != this.stageCount) {
                this.capVoltages = new double[this.stageCount];
            }
            double oldTopVoltage = this.capVoltages[this.stageCount - 1];
            double oldBottomVoltage = this.capVoltages[0];
            for (int i = this.stageCount - 1; i > 0; --i) {
                double oldVoltage = this.capVoltages[i];
                double u0 = this.capVoltages[i - 1];
                this.capVoltages[i] = u0 - (u0 - oldVoltage) * this.timeFactor;
                int n = i - 1;
                this.capVoltages[n] = this.capVoltages[n] - (this.capVoltages[i] - oldVoltage);
            }
            double setVoltage = 250000.0 * (double)this.voltageControl / 255.0;
            double u0 = Math.min(setVoltage, 10.0 * this.storage.getEnergyStoredJ());
            if (u0 < 0.0) {
                u0 = 0.0;
            }
            if (u0 < this.capVoltages[0] && setVoltage > this.capVoltages[0]) {
                u0 = this.capVoltages[0];
            }
            if ((energyUsed = 0.5 * ((tmp = u0 - (u0 - oldBottomVoltage) * this.timeFactorBottom) * tmp - oldBottomVoltage * oldBottomVoltage) * 1.6E-6) > 0.0 && this.storage.extract(energyUsed, 1.0, true) == energyUsed) {
                this.storage.extract(energyUsed, 1.0, false);
                this.capVoltages[0] = tmp;
            } else if (energyUsed <= 0.0) {
                this.capVoltages[0] = tmp;
            }
            int delta = (int)(this.lastUpdate + 15L - this.field_145850_b.func_82737_E());
            if (Math.abs(this.getRSSignalFromVoltage(oldBottomVoltage) - this.getRSSignalFromVoltage(this.capVoltages[0])) > delta) {
                this.net.updateValues();
            } else if (Math.abs(this.getRSSignalFromVoltage(oldTopVoltage) - this.getRSSignalFromVoltage(this.capVoltages[this.stageCount - 1])) > delta) {
                this.net.updateValues();
            }
            if (this.capVoltages[0] > 241666.66666666666) {
                this.state = FiringState.NEXT_TICK;
            }
        }
        this.leftover = this.storage.getMaxInPerTick();
    }

    private void fire() {
        if (!this.field_145850_b.field_72995_K) {
            double energyStored = 0.0;
            boolean failed = this.capVoltages[0] < 125000.0;
            double totalVoltage = 0.0;
            for (int i = 0; i < this.stageCount; ++i) {
                energyStored += 0.5 * this.capVoltages[i] * this.capVoltages[i] * 1.6E-6;
                totalVoltage += this.capVoltages[i];
                this.capVoltages[i] = 0.0;
            }
            if (totalVoltage < 25000.0 * (double)this.stageCount) {
                return;
            }
            boolean bl = totalVoltage < 75000.0 * (double)this.stageCount;
            this.net.updateValues();
            NBTTagCompound data = new NBTTagCompound();
            if (failed |= bl) {
                energyStored = -energyStored;
            } else {
                int seed = Utils.RAND.nextInt();
                this.genDischarge((float)energyStored, seed);
                data.func_74768_a("randSeed", seed);
                this.handleEntities(energyStored);
                this.handleOreProcessing(energyStored);
            }
            data.func_74780_a("energy", energyStored);
            IndustrialWires.packetHandler.sendToDimension((IMessage)new MessageTileSyncIW(this, data), this.field_145850_b.field_73011_w.getDimension());
        }
    }

    private void handleOreProcessing(double energyStored) {
        BlockPos bottom = this.getBottomElectrode();
        ArrayList<BlockPos> toBreak = new ArrayList<BlockPos>(this.stageCount - 2);
        int ores = 0;
        for (int i = 1; i < this.stageCount - 1; ++i) {
            BlockPos blockHere = bottom.func_177981_b(i);
            if (this.field_145850_b.func_175623_d(blockHere)) continue;
            toBreak.add(blockHere);
            ++ores;
        }
        if (ores > 0) {
            double energyPerOre = energyStored / (double)ores;
            for (BlockPos here : toBreak) {
                ItemStack[] out;
                TileEntity te;
                IBlockState state = this.field_145850_b.func_180495_p(here);
                if (state.func_185887_b(this.field_145850_b, here) < 0.0f || this.field_145850_b.func_175623_d(here) || (te = this.field_145850_b.func_175625_s(here)) instanceof IMarxTarget && ((IMarxTarget)te).onHit(energyPerOre, this)) continue;
                for (ItemStack stack : out = MarxOreHandler.getYield(this.field_145850_b, here, energyPerOre)) {
                    EntityItem item = new EntityItem(this.field_145850_b, (double)here.func_177958_n() + 0.5, (double)here.func_177956_o() + 0.5, (double)here.func_177952_p() + 0.5, stack);
                    double maxMotion = 0.3;
                    item.field_70159_w = 0.6 * (Utils.RAND.nextDouble() - 0.5);
                    item.field_70181_x = 0.6 * (Utils.RAND.nextDouble() - 0.5);
                    item.field_70179_y = 0.6 * (Utils.RAND.nextDouble() - 0.5);
                    this.field_145850_b.func_72838_d((Entity)item);
                }
                this.field_145850_b.func_175698_g(here);
            }
        }
    }

    private void handleEntities(double energyStored) {
        double damageDistSqu = Math.sqrt(energyStored / 50000.0);
        double tinnitusDistSqu = Math.sqrt(energyStored) / 50.0;
        Vec3d v0 = this.getMiddle();
        AxisAlignedBB aabb = new AxisAlignedBB(v0.field_72450_a, v0.field_72448_b, v0.field_72449_c, v0.field_72450_a, v0.field_72448_b, v0.field_72449_c);
        aabb = aabb.func_72314_b(0.0, (double)this.stageCount / 2.0 - 1.0, 0.0);
        aabb = aabb.func_186662_g(tinnitusDistSqu);
        List fools = this.field_145850_b.func_72872_a(Entity.class, aabb);
        damageDistSqu *= damageDistSqu;
        tinnitusDistSqu *= tinnitusDistSqu;
        if (IWConfig.HVStuff.marxSoundDamage == 2) {
            damageDistSqu = tinnitusDistSqu;
            tinnitusDistSqu = -1.0;
        }
        for (Entity entity : fools) {
            boolean earMuff;
            double y;
            double distSqu = entity.func_70092_e(v0.field_72450_a, y = entity.field_70163_u < (double)(this.field_174879_c.func_177956_o() + 1) ? (double)(this.field_174879_c.func_177956_o() + 1) : (entity.field_70163_u > (double)(this.field_174879_c.func_177956_o() + this.stageCount - 2) ? (double)(this.field_174879_c.func_177956_o() + this.stageCount - 2) : entity.field_70163_u), v0.field_72449_c);
            if (distSqu <= damageDistSqu) {
                float dmg = (float)((double)(10 * this.stageCount) * (1.0 - distSqu / damageDistSqu));
                entity.func_70097_a((DamageSource)IWDamageSources.dmg_marx, dmg);
            }
            if (!(distSqu <= tinnitusDistSqu) || !(entity instanceof EntityPlayer)) continue;
            ItemStack helmet = (ItemStack)((EntityPlayer)entity).field_71071_by.field_70460_b.get(3);
            boolean bl = earMuff = helmet.func_77973_b() == IEObjects.itemEarmuffs;
            if (!earMuff && helmet.func_77942_o()) {
                earMuff = helmet.func_77978_p().func_74764_b("IE:Earmuffs");
            }
            if (earMuff) continue;
            double multipl = Math.min(5.0, Math.sqrt(this.stageCount));
            int duration = (int)(400.0 * (1.0 + multipl * (1.0 - distSqu / tinnitusDistSqu)));
            if (IWConfig.HVStuff.marxSoundDamage == 0) {
                ((EntityPlayer)entity).func_70690_d(new PotionEffect((Potion)IWPotions.tinnitus, duration));
                continue;
            }
            ((EntityPlayer)entity).func_70690_d(new PotionEffect(Potion.func_180142_b((String)"nausea"), duration));
        }
    }

    private int getRSSignalFromVoltage(double voltage) {
        return (int)(Math.round(255.0 * voltage / 250000.0) & 0xFFL);
    }

    @Override
    public Vec3i getSize() {
        return new Vec3i(this.stageCount, 8, 2);
    }

    @Override
    public void onSync(NBTTagCompound nbt) {
        float energy = nbt.func_74760_g("energy");
        if (energy > 0.0f) {
            this.genDischarge(energy, nbt.func_74762_e("randSeed"));
        } else {
            if (this.dischargeData == null) {
                this.dischargeData = new Discharge(this.stageCount);
            }
            this.dischargeData.energy = energy;
        }
        this.state = FiringState.NEXT_TICK;
    }

    private void genDischarge(float energy, int seed) {
        if (this.dischargeData == null) {
            this.dischargeData = new Discharge(this.stageCount);
        }
        this.dischargeData.energy = energy;
        this.dischargeData.diameter = (float)this.getNormedEnergy(this.dischargeData.energy);
        this.dischargeData.genMarxPoint(seed);
    }

    private double getNormedEnergy(double total) {
        return total * 2.0 / ((double)this.stageCount * 250000.0 * 250000.0 * 1.6E-6);
    }

    @Nonnull
    public AxisAlignedBB getRenderBoundingBox() {
        if (this.renderAabb == null) {
            this.renderAabb = this.type == IWProperties.MarxType.BOTTOM ? new AxisAlignedBB(this.field_174879_c, MiscUtils.offset(this.field_174879_c, this.facing, this.mirrored, 2, 4, this.stageCount)) : new AxisAlignedBB(this.field_174879_c, this.field_174879_c);
        }
        return this.renderAabb;
    }

    @Override
    public AxisAlignedBB getBoundingBox() {
        if (this.collisionAabb == null) {
            int forward = this.getForward();
            int right = this.getRight();
            int up = this.offset.func_177956_o();
            AxisAlignedBB ret = Block.field_185505_j;
            switch (forward) {
                case -3: {
                    if (right == 1) {
                        ret = new AxisAlignedBB(0.3125, 0.3125, 0.25, 0.6875, 0.6875, 1.0);
                        break;
                    }
                    ret = new AxisAlignedBB(0.3125, 0.3125, 0.4375, 0.6875, 0.6875, 1.0);
                    break;
                }
                case -1: {
                    if (up == 0) {
                        ret = new AxisAlignedBB(0.375, 0.0, 0.0, 0.625, 1.0, 1.0);
                        break;
                    }
                    if (up == this.stageCount - 1) {
                        ret = new AxisAlignedBB(0.375, 0.0, 0.5625, 0.625, 0.3125, 1.0);
                        break;
                    }
                    ret = new AxisAlignedBB(0.375, 0.0, 0.5625, 0.625, 1.0, 1.0);
                    break;
                }
                case 1: {
                    if (right == 0) {
                        if (up != 0) {
                            ret = new AxisAlignedBB(0.0, 0.0, 0.0, 0.5625, up == this.stageCount - 1 ? 0.5 : 1.0, 0.4375);
                            break;
                        }
                        ret = new AxisAlignedBB(0.4375, 0.0, 0.0, 0.5625, 0.3125, 1.0);
                        break;
                    }
                    if (this.stageCount - 1 == up) {
                        ret = new AxisAlignedBB(0.4375, 0.1875, 0.0, 0.5625, 0.3125, 1.0);
                        break;
                    }
                    ret = new AxisAlignedBB(0.4375, 0.0, 0.0, 1.0, 1.0, 0.4375);
                    break;
                }
                case -2: {
                    break;
                }
                case 0: {
                    if (up != this.stageCount - 1) break;
                    ret = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0);
                    break;
                }
                default: {
                    if (right == 0) {
                        if (forward < 4) {
                            ret = new AxisAlignedBB(0.4375, 0.0, 0.0, 0.5625, 0.3125, 1.0);
                            break;
                        }
                        ret = new AxisAlignedBB(0.0, 0.0, 0.0, 0.5625, 0.3125, 0.5625);
                        break;
                    }
                    ret = up == 0 ? Block.field_185505_j : (forward < 4 ? new AxisAlignedBB(0.4375, 0.1875, 0.0, 0.5625, 0.3125, 1.0) : new AxisAlignedBB(0.375, 0.0625, 0.0, 0.625, 0.3125, 0.625));
                }
            }
            this.collisionAabb = MiscUtils.apply(this.getBaseTransform(), ret);
        }
        return this.collisionAabb;
    }

    private Matrix4 getBaseTransform() {
        Matrix4 transform = new Matrix4();
        transform.translate(0.5, 0.0, 0.5);
        transform.rotate((double)(-this.facing.func_185119_l()) * Math.PI / 180.0, 0.0, 1.0, 0.0);
        if (this.mirrored) {
            transform.scale(-1.0, 1.0, 1.0);
        }
        transform.translate(-0.5, 0.0, -0.5);
        return transform;
    }

    public boolean canConnect() {
        return this.getForward() == -3;
    }

    public boolean isEnergyOutput() {
        return this.getForward() == -3 && this.getRight() == 1;
    }

    public int outputEnergy(int amount, boolean simulate, int energyType) {
        TileEntityMarx master = this.master(this);
        if (master != null && amount > 0) {
            double ret = master.storage.insert(amount, ConversionUtil.joulesPerIf(), simulate, master.leftover);
            master.leftover -= ret;
            return (int)ret;
        }
        return 0;
    }

    @Override
    public double insertEnergy(double joules, boolean simulate, EnergyType type) {
        TileEntityMarx master = this.master(this);
        if (master != null) {
            double ret = master.storage.insert(joules, 1.0, simulate, master.leftover);
            if (!simulate) {
                master.leftover -= ret;
            }
            return joules - ret;
        }
        return 0.0;
    }

    public BlockPos getConnectionMaster(@Nullable WireType cableType, TargetingInfo target) {
        return this.field_174879_c;
    }

    public boolean canConnectCable(WireType cableType, TargetingInfo target, Vec3i offset) {
        if (this.hasConnection) {
            return false;
        }
        if (this.getRight() == 0) {
            return "REDSTONE".equals(cableType.getCategory());
        }
        return "HV".equals(cableType.getCategory()) || "IC_HV".equals(cableType.getCategory());
    }

    public void connectCable(WireType cableType, TargetingInfo target, IImmersiveConnectable other) {
        this.hasConnection = true;
        if ("REDSTONE".equals(cableType.getCategory())) {
            RedstoneWireNetwork.updateConnectors((BlockPos)this.field_174879_c, (World)this.field_145850_b, (RedstoneWireNetwork)this.getNetwork());
        }
    }

    public WireType getCableLimiter(TargetingInfo target) {
        return this.getRight() == 0 ? WireType.REDSTONE : MixedWireType.HV;
    }

    public boolean allowEnergyToPass(ImmersiveNetHandler.Connection con) {
        return true;
    }

    public void onEnergyPassthrough(int amount) {
    }

    public void removeCable(ImmersiveNetHandler.Connection connection) {
        this.hasConnection = false;
        if (this.field_145850_b != null) {
            IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
        }
    }

    public Vec3d getConnectionOffset(ImmersiveNetHandler.Connection con) {
        Matrix4 transf = this.getBaseTransform();
        if (this.getRight() == 0) {
            return transf.apply(new Vec3d(0.5, 0.5, 0.4375));
        }
        return transf.apply(new Vec3d(0.5, 0.5, 0.25));
    }

    public void func_145829_t() {
        super.func_145829_t();
        if (!this.field_145850_b.field_72995_K) {
            ApiUtils.addFutureServerTask((World)this.field_145850_b, () -> ImmersiveNetHandler.INSTANCE.onTEValidated((TileEntity)this));
        }
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        if (this.field_145850_b.field_72995_K && !IndustrialWires.proxy.isSingleplayer()) {
            ImmersiveNetHandler.INSTANCE.clearConnectionsOriginatingFrom(this.field_174879_c, this.field_145850_b);
        }
    }

    public boolean func_145842_c(int id, int type) {
        return MiscUtils.handleUpdate(id, this.field_174879_c, this.field_145850_b) || super.func_145842_c(id, type);
    }

    public void setNetwork(RedstoneWireNetwork net) {
        this.masterOr(this, this).net = net;
    }

    public RedstoneWireNetwork getNetwork() {
        TileEntityMarx master = this.masterOr(this, this);
        if (!this.loaded) {
            master.net.add((IRedstoneConnector)this);
            this.loaded = true;
        }
        return master.net;
    }

    public void onChange() {
        TileEntityMarx master = this.masterOr(this, this);
        master.voltageControl = master.net.channelValues[EnumDyeColor.WHITE.func_176765_a()] << 4 | master.net.channelValues[EnumDyeColor.YELLOW.func_176765_a()];
        if (master.net.channelValues[EnumDyeColor.LIGHT_BLUE.func_176765_a()] != 0) {
            master.tryTriggeredDischarge();
        }
        master.lastUpdate = this.field_145850_b.func_82737_E();
    }

    private void tryTriggeredDischarge() {
        this.state = FiringState.NEXT_TICK;
    }

    public World getConnectorWorld() {
        return this.field_145850_b;
    }

    public void updateInput(byte[] signals) {
        TileEntityMarx master = this.masterOr(this, this);
        if (master.capVoltages != null && master.capVoltages.length == this.stageCount) {
            int signalTop = this.getRSSignalFromVoltage(master.capVoltages[this.stageCount - 1]);
            int signalBottom = this.getRSSignalFromVoltage(master.capVoltages[0]);
            this.setSignal(EnumDyeColor.ORANGE, signalBottom >> 4 & 0xF, signals);
            this.setSignal(EnumDyeColor.MAGENTA, signalTop >> 4 & 0xF, signals);
            this.setSignal(EnumDyeColor.LIME, signalBottom & 0xF, signals);
            this.setSignal(EnumDyeColor.PINK, signalTop & 0xF, signals);
        }
    }

    private void setSignal(EnumDyeColor channel, int value, byte[] signals) {
        signals[channel.func_176765_a()] = (byte)Math.max(value, signals[channel.func_176765_a()]);
    }

    public void setStageCount(int stageCount) {
        this.stageCount = stageCount;
        this.rcTimeConst = 5.0 / (double)stageCount;
        this.timeFactor = Math.exp(-1.0 / (20.0 * this.rcTimeConst));
        this.timeFactorBottom = Math.exp(-1.0 / (20.0 * this.rcTimeConst * 2.0 / 3.0));
        this.collisionAabb = null;
        this.renderAabb = null;
    }

    public int getStageCount() {
        return this.stageCount;
    }

    private Vec3d getMiddle() {
        double middleY = (double)this.field_174879_c.func_177956_o() + (double)this.stageCount / 2.0;
        BlockPos electrodXZ = this.getBottomElectrode();
        return new Vec3d((double)electrodXZ.func_177958_n() + 0.5, middleY, (double)electrodXZ.func_177952_p() + 0.5);
    }

    private BlockPos getBottomElectrode() {
        return MiscUtils.offset(this.field_174879_c, this.facing, this.mirrored, 1, 4, 0);
    }

    @Optional.Method(modid="mirage")
    @SubscribeEvent
    public static void gatherLights(GatherLightsEvent event) {
        for (TileEntityMarx te : FIRING_GENERATORS) {
            Vec3d origin = te.getMiddle().func_178786_a(0.0, 0.5 * (double)te.stageCount - 1.0, 0.0);
            Light.Builder builder = Light.builder().color(1.0f, 1.0f, 1.0f).radius(5.0f);
            ArrayList<Light> toAdd = new ArrayList<Light>(te.stageCount * 2 - 3);
            if (te.dischargeData != null && te.dischargeData.energy > 0.0f) {
                toAdd.add(builder.pos(origin.func_72441_c(0.0, 0.0, 0.0)).build());
                toAdd.add(builder.pos(origin.func_72441_c(0.0, (double)(te.stageCount / 2), 0.0)).build());
                toAdd.add(builder.pos(origin.func_72441_c(0.0, (double)(te.stageCount - 2), 0.0)).build());
            }
            origin = new Vec3d((Vec3i)MiscUtils.offset(te.field_174879_c, te.facing, te.mirrored, 1, 0, 0)).func_72441_c(0.0, 0.75, 0.0).func_178787_e(new Vec3d(te.facing.func_176730_m()).func_186678_a(0.25));
            builder.radius(0.5f);
            for (int i = 0; i < te.stageCount - 1; i += te.stageCount / 5) {
                toAdd.add(builder.pos(origin.func_72441_c(0.0, (double)i, 0.0)).build());
            }
            event.getLightList().addAll(toAdd);
        }
    }

    public static final class Discharge {
        public float energy;
        public Vec3d[] vertices;
        public float diameter = 0.25f;
        final int stageCount;
        private final Vec3d side = new Vec3d(0.0, 0.0, 1.0);
        private Matrix4 transform = new Matrix4();

        Discharge(int stages) {
            this.stageCount = stages;
            int count = stages / 5 + 1;
            this.vertices = new Vec3d[2 * count];
            this.vertices[0] = new Vec3d(0.0, -0.5, 0.0);
            for (int i = 1; i < this.vertices.length; ++i) {
                this.vertices[i] = new Vec3d(0.0, 0.0, 0.0);
            }
            this.vertices[this.vertices.length - 1] = new Vec3d(0.0, (double)((float)this.stageCount - 1.9375f), 0.0);
        }

        void genMarxPoint(int randSeed) {
            this.genMarxPoint(0, this.vertices.length - 1, new Random(randSeed));
        }

        void genMarxPoint(int min, int max, Random rand) {
            int toGenerate = (min + max) / 2;
            Vec3d diff = this.vertices[max].func_178788_d(this.vertices[min]);
            Vec3d v0 = diff.func_72431_c(this.side);
            this.transform.setIdentity();
            double diffLength = diff.func_72433_c();
            double noise = Math.sqrt(diffLength) * rand.nextDouble() * 1.0 / (1.0 + Math.abs((double)this.stageCount / 2.0 - (double)toGenerate)) * 0.75;
            if ((max - min) % 2 == 1) {
                noise *= (double)(toGenerate - min) / (double)(max - min);
            }
            v0 = v0.func_186678_a((double)((float)(noise / v0.func_72433_c())));
            diff = diff.func_186678_a(1.0 / diffLength);
            this.transform.rotate(Math.PI * 2 * rand.nextDouble(), diff.field_72450_a, diff.field_72448_b, diff.field_72449_c);
            Vec3d center = this.vertices[max].func_178787_e(this.vertices[min]).func_186678_a(0.5);
            this.vertices[toGenerate] = this.transform.apply(v0);
            this.vertices[toGenerate] = center.func_178787_e(this.vertices[toGenerate]);
            if (toGenerate - min > 1) {
                this.genMarxPoint(min, toGenerate, rand);
            }
            if (max - toGenerate > 1) {
                this.genMarxPoint(toGenerate, max, rand);
            }
        }
    }

    public static enum FiringState {
        CHARGING,
        NEXT_TICK,
        FIRE;

    }
}

