/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.render;

import com.ferreusveritas.dynamictrees.client.QuadManipulator;
import com.ferreusveritas.dynamictrees.entities.EntityFallingTree;
import com.ferreusveritas.dynamictrees.models.ModelEntityFallingTree;
import com.ferreusveritas.dynamictrees.models.ModelTrackerCacheEntityFallingTree;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.pipeline.LightUtil;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderFallingTree
extends Render<EntityFallingTree> {
    protected RenderFallingTree(RenderManager renderManager) {
        super(renderManager);
    }

    protected ResourceLocation getEntityTexture(EntityFallingTree entity) {
        return TextureMap.field_110575_b;
    }

    public void doRender(EntityFallingTree entity, double x, double y, double z, float entityYaw, float partialTicks) {
        super.func_76986_a((Entity)entity, x, y, z, entityYaw, partialTicks);
        if (!entity.isClientBuilt() || !entity.shouldRender()) {
            return;
        }
        this.func_180548_c(entity);
        ModelEntityFallingTree treeModel = ModelTrackerCacheEntityFallingTree.getModel(entity);
        int brightnessIn = ModelEntityFallingTree.getBrightness(entity);
        GlStateManager.func_179140_f();
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        if (entity.onFire) {
            this.renderFire();
        }
        entity.currentAnimationHandler.renderTransform(entity, entityYaw, partialTicks);
        this.drawBakedQuads(treeModel.getQuads(), brightnessIn, treeModel.getLeavesColor());
        GlStateManager.func_179121_F();
        GlStateManager.func_179145_e();
    }

    private void renderFire() {
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)-0.5f, (float)0.0f, (float)-0.5f);
        BlockRendererDispatcher dispatcher = Minecraft.func_71410_x().func_175602_ab();
        IBlockState fire = Blocks.field_150480_ab.func_176223_P();
        IBakedModel model = dispatcher.func_184389_a(fire);
        this.drawBakedQuads(QuadManipulator.getQuads(model, fire), 255, -1);
        GlStateManager.func_179121_F();
    }

    public void drawBakedQuads(List<BakedQuad> inQuads, int brightnessIn, int color) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_176600_a);
        for (BakedQuad bakedquad : inQuads) {
            buffer.func_178981_a(bakedquad.func_178209_a());
            buffer.func_178962_a(brightnessIn, brightnessIn, brightnessIn, brightnessIn);
            if (bakedquad.func_178212_b()) {
                float r = (float)(color >> 16 & 0xFF) / 255.0f;
                float g = (float)(color >> 8 & 0xFF) / 255.0f;
                float b = (float)(color & 0xFF) / 255.0f;
                if (bakedquad.shouldApplyDiffuseLighting()) {
                    float diffuse = LightUtil.diffuseLight((EnumFacing)bakedquad.func_178210_d());
                    r *= diffuse;
                    g *= diffuse;
                    b *= diffuse;
                }
                buffer.func_178978_a(r, g, b, 4);
                buffer.func_178978_a(r, g, b, 3);
                buffer.func_178978_a(r, g, b, 2);
                buffer.func_178978_a(r, g, b, 1);
                continue;
            }
            if (!bakedquad.shouldApplyDiffuseLighting()) continue;
            float diffuse = LightUtil.diffuseLight((EnumFacing)bakedquad.func_178210_d());
            buffer.func_178978_a(diffuse, diffuse, diffuse, 4);
            buffer.func_178978_a(diffuse, diffuse, diffuse, 3);
            buffer.func_178978_a(diffuse, diffuse, diffuse, 2);
            buffer.func_178978_a(diffuse, diffuse, diffuse, 1);
        }
        tessellator.func_78381_a();
    }

    public static class Factory
    implements IRenderFactory<EntityFallingTree> {
        public Render<EntityFallingTree> createRenderFor(RenderManager manager) {
            return new RenderFallingTree(manager);
        }
    }
}

