/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.models;

import com.ferreusveritas.dynamictrees.blocks.BlockBranch;
import com.ferreusveritas.dynamictrees.client.QuadManipulator;
import com.ferreusveritas.dynamictrees.entities.EntityFallingTree;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.util.BranchDestructionData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ModelEntityFallingTree {
    protected final List<BakedQuad> quads;
    protected final int leavesColor;
    protected final int entityId;

    public ModelEntityFallingTree(EntityFallingTree entity) {
        World world = entity.func_130014_f_();
        BranchDestructionData destructionData = entity.getDestroyData();
        Species species = destructionData.species;
        this.leavesColor = species.getLeavesProperties().foliageColorMultiplier(species.getLeavesProperties().getDynamicLeavesState(), (IBlockAccess)world, destructionData.cutPos);
        this.quads = ModelEntityFallingTree.generateTreeQuads(entity);
        this.entityId = entity.func_145782_y();
    }

    public List<BakedQuad> getQuads() {
        return this.quads;
    }

    public int getLeavesColor() {
        return this.leavesColor;
    }

    public int getEntityId() {
        return this.entityId;
    }

    public static int getBrightness(EntityFallingTree entity) {
        BranchDestructionData destructionData = entity.getDestroyData();
        World world = entity.func_130014_f_();
        return world.func_180495_p(destructionData.cutPos).func_185889_a((IBlockAccess)world, destructionData.cutPos);
    }

    public static List<BakedQuad> generateTreeQuads(EntityFallingTree entity) {
        ArrayList<BakedQuad> treeQuads;
        block7: {
            IExtendedBlockState exState;
            BlockRendererDispatcher dispatcher = Minecraft.func_71410_x().func_175602_ab();
            BranchDestructionData destructionData = entity.getDestroyData();
            EnumFacing cutDir = destructionData.cutDir;
            treeQuads = new ArrayList<BakedQuad>();
            if (destructionData.getNumBranches() <= 0 || (exState = destructionData.getBranchBlockState(0)) == null) break block7;
            for (EnumFacing face : EnumFacing.field_82609_l) {
                exState = exState.withProperty(BlockBranch.CONNECTIONS[face.func_176745_a()], (Object)(face == cutDir.func_176734_d() ? 8 : 0));
            }
            int radius = ((BlockBranch)exState.func_177230_c()).getRadius((IBlockState)exState);
            float offset = (float)(8 - Math.min(radius, 8)) / 16.0f;
            IBakedModel branchModel = dispatcher.func_184389_a(exState.getClean());
            treeQuads.addAll(QuadManipulator.getQuads(branchModel, (IBlockState)exState, new Vec3d((Vec3i)BlockPos.field_177992_a.func_177972_a(cutDir)).func_186678_a((double)offset), new EnumFacing[]{cutDir}));
            for (int index = 0; index < destructionData.getNumBranches(); ++index) {
                exState = destructionData.getBranchBlockState(index);
                BlockPos relPos = destructionData.getBranchRelPos(index);
                treeQuads.addAll(QuadManipulator.getQuads(branchModel, (IBlockState)exState, new Vec3d((Vec3i)relPos)));
            }
            HashMap<BlockPos, IBlockState> leavesClusters = destructionData.species.getFamily().getFellingLeavesClusters(destructionData);
            if (leavesClusters != null) {
                for (Map.Entry entry : leavesClusters.entrySet()) {
                    IBlockState leafState = (IBlockState)entry.getValue();
                    if (leafState instanceof IExtendedBlockState) {
                        leafState = ((IExtendedBlockState)leafState).getClean();
                    }
                    treeQuads.addAll(QuadManipulator.getQuads(dispatcher.func_184389_a(leafState), (IBlockState)entry.getValue(), new Vec3d((Vec3i)entry.getKey())));
                }
            } else {
                IBlockState state = destructionData.species.getLeavesProperties().getDynamicLeavesState();
                for (BlockPos relPos : destructionData.getPositions(BranchDestructionData.PosType.LEAVES, false)) {
                    treeQuads.addAll(QuadManipulator.getQuads(dispatcher.func_184389_a(state), state, new Vec3d((Vec3i)relPos)));
                }
            }
        }
        return treeQuads;
    }
}

