/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.api;

import com.ferreusveritas.dynamictrees.ModBlocks;
import com.ferreusveritas.dynamictrees.api.IAgeable;
import com.ferreusveritas.dynamictrees.api.ICustomRootDecay;
import com.ferreusveritas.dynamictrees.api.network.MapSignal;
import com.ferreusveritas.dynamictrees.api.treedata.ITreePart;
import com.ferreusveritas.dynamictrees.blocks.BlockBranch;
import com.ferreusveritas.dynamictrees.blocks.BlockDynamicLeaves;
import com.ferreusveritas.dynamictrees.blocks.BlockRooty;
import com.ferreusveritas.dynamictrees.blocks.BlockTrunkShell;
import com.ferreusveritas.dynamictrees.blocks.NullTreePart;
import com.ferreusveritas.dynamictrees.systems.nodemappers.NodeTwinkle;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.util.Deprecatron;
import com.ferreusveritas.dynamictrees.util.SafeChunkBounds;
import com.ferreusveritas.dynamictrees.util.SimpleVoxmap;
import com.ferreusveritas.dynamictrees.worldgen.JoCode;
import java.util.Optional;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class TreeHelper {
    public static final ITreePart nullTreePart = new NullTreePart();

    public static void growPulse(World world, BlockPos rootPos) {
        IBlockState rootyState = world.func_180495_p(rootPos);
        BlockRooty dirt = TreeHelper.getRooty(rootyState);
        if (dirt != null) {
            dirt.updateTree(rootyState, world, rootPos, world.field_73012_v, false);
            TreeHelper.ageVolume(world, rootPos, 8, 32, 1, SafeChunkBounds.ANY);
        }
    }

    public static void ageVolume(World world, SimpleVoxmap leafMap, int iterations, SafeChunkBounds safeBounds) {
        SimpleVoxmap iterMap = leafMap != null ? new SimpleVoxmap(leafMap) : null;
        Iterable<BlockPos.MutableBlockPos> iterable = iterMap.getAllNonZero();
        for (int i = 0; i < iterations; ++i) {
            for (BlockPos.MutableBlockPos iPos : iterable) {
                IBlockState blockState = world.func_180495_p((BlockPos)iPos);
                Block block = blockState.func_177230_c();
                if (block instanceof BlockDynamicLeaves) {
                    byte prevHydro = leafMap.getVoxel((BlockPos)iPos);
                    int newHydro = ((IAgeable)block).age(world, (BlockPos)iPos, blockState, world.field_73012_v, safeBounds);
                    if (newHydro == -1) {
                        leafMap.setVoxel((BlockPos)iPos, (byte)0);
                        iterMap.setVoxel((BlockPos)iPos, (byte)0);
                        continue;
                    }
                    if (prevHydro == newHydro) {
                        iterMap.setVoxel((BlockPos)iPos, (byte)0);
                        continue;
                    }
                    leafMap.setVoxel((BlockPos)iPos, (byte)newHydro);
                    iterMap.setVoxel((BlockPos)iPos, (byte)newHydro);
                    for (EnumFacing dir : EnumFacing.values()) {
                        BlockPos dPos = iPos.func_177972_a(dir);
                        iterMap.setVoxel(dPos, leafMap.getVoxel(dPos));
                    }
                    continue;
                }
                if (block instanceof IAgeable) {
                    ((IAgeable)block).age(world, (BlockPos)iPos, blockState, world.field_73012_v, safeBounds);
                    continue;
                }
                leafMap.setVoxel((BlockPos)iPos, (byte)0);
                iterMap.setVoxel((BlockPos)iPos, (byte)0);
            }
        }
    }

    public static void ageVolume(World world, BlockPos treePos, int halfWidth, int height, int iterations, SafeChunkBounds safeBounds) {
        Iterable iterable = BlockPos.func_177975_b((BlockPos)treePos.func_177971_a((Vec3i)new BlockPos(-halfWidth, 0, -halfWidth)), (BlockPos)treePos.func_177971_a((Vec3i)new BlockPos(halfWidth, height, halfWidth)));
        for (int i = 0; i < iterations; ++i) {
            for (BlockPos.MutableBlockPos iPos : iterable) {
                IBlockState blockState = world.func_180495_p((BlockPos)iPos);
                Block block = blockState.func_177230_c();
                if (!(block instanceof IAgeable)) continue;
                ((IAgeable)block).age(world, (BlockPos)iPos, blockState, world.field_73012_v, safeBounds);
            }
        }
    }

    public static Optional<JoCode> getJoCode(World world, BlockPos pos) {
        return TreeHelper.getJoCode(world, pos, EnumFacing.SOUTH);
    }

    public static Optional<JoCode> getJoCode(World world, BlockPos pos, EnumFacing facing) {
        if (pos == null) {
            return Optional.empty();
        }
        BlockPos rootPos = TreeHelper.findRootNode(world.func_180495_p(pos = TreeHelper.dereferenceTrunkShell(world, pos)), world, pos);
        return rootPos != BlockPos.field_177992_a ? Optional.of(new JoCode(world, rootPos, facing)) : Optional.empty();
    }

    public static BlockPos dereferenceTrunkShell(World world, BlockPos pos) {
        BlockTrunkShell.ShellMuse muse;
        IBlockState blockState = world.func_180495_p(pos);
        if (blockState.func_177230_c() == ModBlocks.blockTrunkShell && (muse = ((BlockTrunkShell)blockState.func_177230_c()).getMuse((IBlockAccess)world, blockState, pos)) != null) {
            return muse.pos;
        }
        return pos;
    }

    public static Species getCommonSpecies(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos = TreeHelper.dereferenceTrunkShell(world, pos));
        if (state.func_177230_c() instanceof BlockBranch) {
            BlockBranch branch = (BlockBranch)state.func_177230_c();
            return branch.getFamily().getCommonSpecies();
        }
        return Species.NULLSPECIES;
    }

    public static Species getExactSpecies(World world, BlockPos pos) {
        IBlockState blockState = world.func_180495_p(pos = TreeHelper.dereferenceTrunkShell(world, pos));
        BlockPos rootPos = TreeHelper.findRootNode(blockState, world, pos);
        if (rootPos != BlockPos.field_177992_a) {
            IBlockState rootyState = world.func_180495_p(rootPos);
            return TreeHelper.getRooty(rootyState).getSpecies(rootyState, world, rootPos);
        }
        return Species.NULLSPECIES;
    }

    @Deprecated
    public static Species getExactSpecies(IBlockState unused, World world, BlockPos pos) {
        Deprecatron.Complain("getExactSpecies", "Deprecated use of getExactSpecies method. Will be removed in the future.");
        return TreeHelper.getExactSpecies(world, pos);
    }

    public static Species getBestGuessSpecies(World world, BlockPos pos) {
        Species species = TreeHelper.getExactSpecies(world, pos);
        return species == Species.NULLSPECIES ? TreeHelper.getCommonSpecies(world, pos) : species;
    }

    public static BlockPos findRootNode(IBlockState blockState, World world, BlockPos pos) {
        ITreePart treePart = TreeHelper.getTreePart(blockState);
        switch (treePart.getTreePartType()) {
            case BRANCH: {
                MapSignal signal = treePart.analyse(blockState, world, pos, null, new MapSignal());
                if (!signal.found) break;
                return signal.root;
            }
            case ROOT: {
                return pos;
            }
            default: {
                return BlockPos.field_177992_a;
            }
        }
        return BlockPos.field_177992_a;
    }

    public static void setCustomRootBlockDecay(ICustomRootDecay decay) {
        BlockRooty.customRootDecay = decay;
    }

    public static ICustomRootDecay getCustomRootBlockDecay() {
        return BlockRooty.customRootDecay;
    }

    public static void treeParticles(World world, BlockPos rootPos, EnumParticleTypes type, int num) {
        if (world.field_72995_K) {
            TreeHelper.startAnalysisFromRoot(world, rootPos, new MapSignal(new NodeTwinkle(type, num)));
        }
    }

    public static boolean startAnalysisFromRoot(World world, BlockPos rootPos, MapSignal signal) {
        BlockRooty dirt = TreeHelper.getRooty(world.func_180495_p(rootPos));
        if (dirt != null) {
            dirt.startAnalysis(world, rootPos, signal);
            return true;
        }
        return false;
    }

    public static final boolean isTreePart(Block block) {
        return block instanceof ITreePart;
    }

    public static final boolean isTreePart(IBlockState blockState) {
        return TreeHelper.isTreePart(blockState.func_177230_c());
    }

    public static final boolean isTreePart(IBlockAccess blockAccess, BlockPos pos) {
        return TreeHelper.isTreePart(blockAccess.func_180495_p(pos).func_177230_c());
    }

    public static final ITreePart getTreePart(Block block) {
        return TreeHelper.isTreePart(block) ? (ITreePart)block : nullTreePart;
    }

    public static final ITreePart getTreePart(IBlockState blockState) {
        return TreeHelper.getTreePart(blockState.func_177230_c());
    }

    public static final boolean isBranch(Block block) {
        return block instanceof BlockBranch;
    }

    public static final boolean isBranch(IBlockState state) {
        return state != null ? TreeHelper.isBranch(state.func_177230_c()) : false;
    }

    public static final BlockBranch getBranch(Block block) {
        return TreeHelper.isBranch(block) ? (BlockBranch)block : null;
    }

    public static final BlockBranch getBranch(ITreePart treepart) {
        return treepart instanceof BlockBranch ? (BlockBranch)treepart : null;
    }

    public static final BlockBranch getBranch(IBlockState state) {
        return TreeHelper.getBranch(state.func_177230_c());
    }

    public static final int getRadius(IBlockAccess access, BlockPos pos) {
        IBlockState state = access.func_180495_p(pos);
        return TreeHelper.getTreePart(state).getRadius(state);
    }

    public static final Optional<BlockBranch> getBranchOpt(Block block) {
        return TreeHelper.isBranch(block) ? Optional.of((BlockBranch)block) : Optional.empty();
    }

    public static final Optional<BlockBranch> getBranchOpt(IBlockState state) {
        Block block = state.func_177230_c();
        return TreeHelper.isBranch(block) ? Optional.of((BlockBranch)block) : Optional.empty();
    }

    public static final Optional<BlockBranch> getBranchOpt(ITreePart treepart) {
        return treepart instanceof BlockBranch ? Optional.of((BlockBranch)treepart) : Optional.empty();
    }

    public static final boolean isLeaves(Block block) {
        return block instanceof BlockDynamicLeaves;
    }

    public static final boolean isLeaves(IBlockState blockState) {
        return TreeHelper.isLeaves(blockState.func_177230_c());
    }

    public static final BlockDynamicLeaves getLeaves(Block block) {
        return TreeHelper.isLeaves(block) ? (BlockDynamicLeaves)block : null;
    }

    public static final BlockDynamicLeaves getLeaves(ITreePart treepart) {
        return treepart instanceof BlockDynamicLeaves ? (BlockDynamicLeaves)treepart : null;
    }

    public static final BlockDynamicLeaves getLeaves(IBlockState state) {
        return TreeHelper.getLeaves(state.func_177230_c());
    }

    public static final boolean isRooty(Block block) {
        return block instanceof BlockRooty;
    }

    public static final boolean isRooty(IBlockState blockState) {
        return TreeHelper.isRooty(blockState.func_177230_c());
    }

    public static final BlockRooty getRooty(Block block) {
        return TreeHelper.isRooty(block) ? (BlockRooty)block : null;
    }

    public static final BlockRooty getRooty(ITreePart treepart) {
        return treepart instanceof BlockRooty ? (BlockRooty)treepart : null;
    }

    public static final BlockRooty getRooty(IBlockState blockState) {
        return TreeHelper.getRooty(blockState.func_177230_c());
    }

    public static final Optional<BlockRooty> getRootyOpt(IBlockState blockState) {
        Block block = blockState.func_177230_c();
        return TreeHelper.isRooty(block) ? Optional.of((BlockRooty)block) : Optional.empty();
    }
}

