/*
 * Decompiled with CFR 0.152.
 */
package com.pahimar.ee3.util.serialize;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.pahimar.ee3.api.exchange.EnergyValue;
import com.pahimar.ee3.exchange.OreStack;
import com.pahimar.ee3.exchange.WrappedStack;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class EnergyValueMapSerializer
implements JsonSerializer<Map<WrappedStack, EnergyValue>>,
JsonDeserializer<Map<WrappedStack, EnergyValue>> {
    private static final String ENERGY_VALUE = "energyValue";
    private static final String TYPE_ITEM_STACK = "itemstack";
    private static final String TYPE_ORE_STACK = "orestack";
    private static final String TYPE_FLUID_STACK = "fluidstack";

    public Map<WrappedStack, EnergyValue> deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        TreeMap<WrappedStack, EnergyValue> valueMap = new TreeMap<WrappedStack, EnergyValue>();
        if (json.isJsonArray()) {
            JsonArray jsonArray = json.getAsJsonArray();
            for (JsonElement jsonElement : jsonArray) {
                if (!EnergyValueMapSerializer.validateValueMapping(jsonElement)) continue;
                JsonObject jsonValueMapping = jsonElement.getAsJsonObject();
                WrappedStack wrappedStack = null;
                EnergyValue energyValue = null;
                if (jsonValueMapping.get(ENERGY_VALUE).isJsonPrimitive() && jsonValueMapping.getAsJsonPrimitive(ENERGY_VALUE).isNumber()) {
                    try {
                        energyValue = new EnergyValue(jsonValueMapping.getAsJsonPrimitive(ENERGY_VALUE).getAsNumber());
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (jsonValueMapping.has(TYPE_ITEM_STACK)) {
                    try {
                        ItemStack itemStack = (ItemStack)context.deserialize(jsonValueMapping.get(TYPE_ITEM_STACK), ItemStack.class);
                        wrappedStack = WrappedStack.wrap(itemStack);
                    }
                    catch (JsonParseException itemStack) {}
                } else if (jsonValueMapping.has(TYPE_ORE_STACK)) {
                    try {
                        OreStack oreStack = (OreStack)context.deserialize(jsonValueMapping.get(TYPE_ORE_STACK), OreStack.class);
                        wrappedStack = WrappedStack.wrap(oreStack);
                    }
                    catch (JsonParseException oreStack) {}
                } else if (jsonValueMapping.has(TYPE_FLUID_STACK)) {
                    try {
                        FluidStack fluidStack = (FluidStack)context.deserialize(jsonValueMapping.get(TYPE_FLUID_STACK), FluidStack.class);
                        wrappedStack = WrappedStack.wrap(fluidStack);
                    }
                    catch (JsonParseException jsonParseException) {
                        // empty catch block
                    }
                }
                if (wrappedStack == null || energyValue == null) continue;
                valueMap.put(wrappedStack, energyValue);
            }
        }
        return valueMap;
    }

    public JsonElement serialize(Map<WrappedStack, EnergyValue> src, Type typeOfSrc, JsonSerializationContext context) {
        JsonArray jsonArray = new JsonArray();
        if (src != null) {
            src.keySet().stream().filter(wrappedStack -> wrappedStack != null && wrappedStack.getWrappedObject() != null).forEach(wrappedStack -> {
                JsonObject jsonMapping = new JsonObject();
                JsonElement jsonElement = context.serialize(wrappedStack.getWrappedObject());
                if (jsonElement.isJsonObject()) {
                    jsonMapping.add(wrappedStack.getWrappedObject().getClass().getSimpleName().toLowerCase(), context.serialize(wrappedStack.getWrappedObject()));
                    if (src.get(wrappedStack) != null) {
                        jsonMapping.addProperty(ENERGY_VALUE, (Number)Float.valueOf(((EnergyValue)src.get(wrappedStack)).getValue()));
                    } else {
                        jsonMapping.add(ENERGY_VALUE, (JsonElement)JsonNull.INSTANCE);
                    }
                    jsonArray.add((JsonElement)jsonMapping);
                }
            });
        }
        return jsonArray;
    }

    private static boolean validateValueMapping(JsonElement jsonElement) {
        JsonObject jsonObject;
        if (jsonElement.isJsonObject() && (jsonObject = jsonElement.getAsJsonObject()).entrySet().size() == 2 && jsonObject.has(ENERGY_VALUE) && jsonObject.get(ENERGY_VALUE).isJsonPrimitive()) {
            return jsonObject.has(TYPE_ITEM_STACK) && jsonObject.get(TYPE_ITEM_STACK).isJsonObject() || jsonObject.has(TYPE_ORE_STACK) && jsonObject.get(TYPE_ORE_STACK).isJsonObject() || jsonObject.has(TYPE_FLUID_STACK) && jsonObject.get(TYPE_FLUID_STACK).isJsonObject();
        }
        return false;
    }
}

