/*
 * Decompiled with CFR 0.152.
 */
package com.pahimar.ee3.util;

import java.util.UUID;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.nbt.NBTTagString;

public class NBTHelper {
    public static void clearStatefulNBTTags(ItemStack itemStack) {
        if (NBTHelper.hasKey(itemStack, "craftingGuiOpen")) {
            NBTHelper.removeTag(itemStack, "craftingGuiOpen");
        } else if (NBTHelper.hasKey(itemStack, "transmutationGuiOpen")) {
            NBTHelper.removeTag(itemStack, "transmutationGuiOpen");
        } else if (NBTHelper.hasKey(itemStack, "alchemicalBagGuiOpen")) {
            NBTHelper.removeTag(itemStack, "alchemicalBagGuiOpen");
        }
    }

    public static boolean hasKey(ItemStack itemStack, String keyName) {
        return itemStack != null && itemStack.field_77990_d != null && itemStack.field_77990_d.func_74764_b(keyName);
    }

    public static void removeTag(ItemStack itemStack, String keyName) {
        if (itemStack != null && itemStack.field_77990_d != null && keyName != null && !keyName.isEmpty()) {
            itemStack.field_77990_d.func_82580_o(keyName);
        }
    }

    public static boolean hasUUID(ItemStack itemStack) {
        return NBTHelper.getLong(itemStack, "UUIDMostSig") != null && NBTHelper.getLong(itemStack, "UUIDLeastSig") != null;
    }

    public static UUID getUUID(ItemStack itemStack) {
        if (NBTHelper.hasUUID(itemStack)) {
            return new UUID(NBTHelper.getLong(itemStack, "UUIDMostSig"), NBTHelper.getLong(itemStack, "UUIDLeastSig"));
        }
        return null;
    }

    public static void setUUID(ItemStack itemStack, UUID uuid) {
        if (itemStack != null) {
            NBTHelper.initNBTTagCompound(itemStack);
            if (uuid == null) {
                uuid = UUID.randomUUID();
            }
            NBTHelper.setLong(itemStack, "UUIDMostSig", uuid.getMostSignificantBits());
            NBTHelper.setLong(itemStack, "UUIDLeastSig", uuid.getLeastSignificantBits());
        }
    }

    private static void initNBTTagCompound(ItemStack itemStack) {
        if (itemStack != null && itemStack.field_77990_d == null) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
    }

    public static String getString(ItemStack itemStack, String keyName) {
        if (NBTHelper.hasKey(itemStack, keyName) && itemStack.func_77978_p().func_74781_a(keyName) instanceof NBTTagString) {
            return itemStack.field_77990_d.func_74779_i(keyName);
        }
        return null;
    }

    public static void setString(ItemStack itemStack, String keyName, String keyValue) {
        if (itemStack != null && keyName != null && !keyName.isEmpty()) {
            NBTHelper.initNBTTagCompound(itemStack);
            itemStack.field_77990_d.func_74778_a(keyName, keyValue);
        }
    }

    public static Boolean getBoolean(ItemStack itemStack, String keyName) {
        if (NBTHelper.hasKey(itemStack, keyName) && itemStack.func_77978_p().func_74781_a(keyName) instanceof NBTTagByte) {
            itemStack.field_77990_d.func_74767_n(keyName);
        }
        return null;
    }

    public static void setBoolean(ItemStack itemStack, String keyName, boolean keyValue) {
        if (itemStack != null && keyName != null && !keyName.isEmpty()) {
            NBTHelper.initNBTTagCompound(itemStack);
            itemStack.field_77990_d.func_74757_a(keyName, keyValue);
        }
    }

    public static Byte getByte(ItemStack itemStack, String keyName) {
        if (NBTHelper.hasKey(itemStack, keyName) && itemStack.func_77978_p().func_74781_a(keyName) instanceof NBTTagByte) {
            return itemStack.field_77990_d.func_74771_c(keyName);
        }
        return null;
    }

    public static void setByte(ItemStack itemStack, String keyName, byte keyValue) {
        if (itemStack != null && keyName != null && !keyName.isEmpty()) {
            NBTHelper.initNBTTagCompound(itemStack);
            itemStack.field_77990_d.func_74774_a(keyName, keyValue);
        }
    }

    public static Short getShort(ItemStack itemStack, String keyName) {
        if (NBTHelper.hasKey(itemStack, keyName) && itemStack.func_77978_p().func_74781_a(keyName) instanceof NBTTagShort) {
            return itemStack.field_77990_d.func_74765_d(keyName);
        }
        return null;
    }

    public static void setShort(ItemStack itemStack, String keyName, short keyValue) {
        if (itemStack != null && keyName != null && !keyName.isEmpty()) {
            NBTHelper.initNBTTagCompound(itemStack);
            itemStack.field_77990_d.func_74777_a(keyName, keyValue);
        }
    }

    public static Integer getInteger(ItemStack itemStack, String keyName) {
        if (NBTHelper.hasKey(itemStack, keyName) && itemStack.func_77978_p().func_74781_a(keyName) instanceof NBTTagInt) {
            return itemStack.field_77990_d.func_74762_e(keyName);
        }
        return null;
    }

    public static void setInteger(ItemStack itemStack, String keyName, int keyValue) {
        if (itemStack != null && keyName != null && !keyName.isEmpty()) {
            NBTHelper.initNBTTagCompound(itemStack);
            itemStack.field_77990_d.func_74768_a(keyName, keyValue);
        }
    }

    public static Long getLong(ItemStack itemStack, String keyName) {
        if (NBTHelper.hasKey(itemStack, keyName) && itemStack.func_77978_p().func_74781_a(keyName) instanceof NBTTagLong) {
            return itemStack.field_77990_d.func_74763_f(keyName);
        }
        return null;
    }

    public static void setLong(ItemStack itemStack, String keyName, long keyValue) {
        if (itemStack != null && keyName != null && !keyName.isEmpty()) {
            NBTHelper.initNBTTagCompound(itemStack);
            itemStack.field_77990_d.func_74772_a(keyName, keyValue);
        }
    }

    public static Float getFloat(ItemStack itemStack, String keyName) {
        if (NBTHelper.hasKey(itemStack, keyName) && itemStack.func_77978_p().func_74781_a(keyName) instanceof NBTTagFloat) {
            return Float.valueOf(itemStack.field_77990_d.func_74760_g(keyName));
        }
        return null;
    }

    public static void setFloat(ItemStack itemStack, String keyName, float keyValue) {
        if (itemStack != null && keyName != null && !keyName.isEmpty()) {
            NBTHelper.initNBTTagCompound(itemStack);
            itemStack.field_77990_d.func_74776_a(keyName, keyValue);
        }
    }

    public static Double getDouble(ItemStack itemStack, String keyName) {
        if (NBTHelper.hasKey(itemStack, keyName) && itemStack.func_77978_p().func_74781_a(keyName) instanceof NBTTagDouble) {
            return itemStack.field_77990_d.func_74769_h(keyName);
        }
        return null;
    }

    public static void setDouble(ItemStack itemStack, String keyName, double keyValue) {
        if (itemStack != null && keyName != null && !keyName.isEmpty()) {
            NBTHelper.initNBTTagCompound(itemStack);
            itemStack.field_77990_d.func_74780_a(keyName, keyValue);
        }
    }

    public static NBTTagList getTagList(ItemStack itemStack, String keyName, int nbtBaseType) {
        if (NBTHelper.hasKey(itemStack, keyName) && itemStack.func_77978_p().func_74781_a(keyName) instanceof NBTTagList) {
            return itemStack.field_77990_d.func_150295_c(keyName, nbtBaseType);
        }
        return null;
    }

    public static void setTagList(ItemStack itemStack, String keyName, NBTTagList nbtTagList) {
        if (itemStack != null && keyName != null && !keyName.isEmpty()) {
            NBTHelper.initNBTTagCompound(itemStack);
            itemStack.field_77990_d.func_74782_a(keyName, (NBTBase)nbtTagList);
        }
    }

    public static NBTTagCompound getTagCompound(ItemStack itemStack, String keyName) {
        if (NBTHelper.hasKey(itemStack, keyName) && itemStack.func_77978_p().func_74781_a(keyName) instanceof NBTTagCompound) {
            return itemStack.field_77990_d.func_74775_l(keyName);
        }
        return null;
    }

    public static void setTagCompound(ItemStack itemStack, String keyName, NBTTagCompound nbtTagCompound) {
        if (itemStack != null && keyName != null && !keyName.isEmpty()) {
            NBTHelper.initNBTTagCompound(itemStack);
            itemStack.field_77990_d.func_74782_a(keyName, (NBTBase)nbtTagCompound);
        }
    }
}

