/*
 * Decompiled with CFR 0.152.
 */
package com.pahimar.ee3.util;

import com.pahimar.ee3.reference.Comparators;
import com.pahimar.ee3.util.NBTHelper;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;

public class ItemStackUtils {
    public static ItemStack clone(ItemStack itemStack, int stackSize) {
        if (itemStack != null) {
            ItemStack clonedItemStack = itemStack.func_77946_l();
            clonedItemStack.field_77994_a = stackSize;
            return clonedItemStack;
        }
        return null;
    }

    public static boolean equals(ItemStack first, ItemStack second) {
        return Comparators.ID_COMPARATOR.compare(first, second) == 0;
    }

    public static boolean equalsIgnoreStackSize(ItemStack itemStack1, ItemStack itemStack2) {
        return ItemStackUtils.equals(ItemStackUtils.clone(itemStack1, 1), ItemStackUtils.clone(itemStack2, 1));
    }

    public static int compare(ItemStack itemStack1, ItemStack itemStack2) {
        return Comparators.ID_COMPARATOR.compare(itemStack1, itemStack2);
    }

    public static String toString(ItemStack itemStack) {
        if (itemStack != null) {
            if (itemStack.func_77942_o()) {
                return String.format("%sxitemStack[%s@%s:%s]", itemStack.field_77994_a, itemStack.func_77977_a(), itemStack.func_77960_j(), itemStack.func_77978_p());
            }
            return String.format("%sxitemStack[%s@%s]", itemStack.field_77994_a, itemStack.func_77977_a(), itemStack.func_77960_j());
        }
        return "null";
    }

    public static void setOwner(ItemStack itemStack, EntityPlayer entityPlayer) {
        ItemStackUtils.setOwnerName(itemStack, entityPlayer);
        ItemStackUtils.setOwnerUUID(itemStack, entityPlayer);
    }

    public static String getOwnerName(ItemStack itemStack) {
        return NBTHelper.getString(itemStack, "owner");
    }

    public static UUID getOwnerUUID(ItemStack itemStack) {
        if (NBTHelper.getLong(itemStack, "ownerUUIDMostSig") != null && NBTHelper.getLong(itemStack, "ownerUUIDLeastSig") != null) {
            return new UUID(NBTHelper.getLong(itemStack, "ownerUUIDMostSig"), NBTHelper.getLong(itemStack, "ownerUUIDLeastSig"));
        }
        return null;
    }

    public static void setOwnerUUID(ItemStack itemStack, EntityPlayer entityPlayer) {
        NBTHelper.setLong(itemStack, "ownerUUIDMostSig", entityPlayer.func_110124_au().getMostSignificantBits());
        NBTHelper.setLong(itemStack, "ownerUUIDLeastSig", entityPlayer.func_110124_au().getLeastSignificantBits());
    }

    public static void setOwnerName(ItemStack itemStack, EntityPlayer entityPlayer) {
        NBTHelper.setString(itemStack, "owner", entityPlayer.getDisplayName());
    }
}

