/*
 * Decompiled with CFR 0.152.
 */
package com.pahimar.ee3.recipe;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.TreeMultimap;
import com.pahimar.ee3.exchange.WrappedStack;
import com.pahimar.ee3.recipe.RecipesFluidContainers;
import com.pahimar.ee3.recipe.RecipesPotions;
import com.pahimar.ee3.recipe.RecipesVanilla;
import com.pahimar.ee3.reference.Comparators;
import com.pahimar.ee3.util.LoaderHelper;
import com.pahimar.ee3.util.LogHelper;
import cpw.mods.fml.common.Loader;
import java.util.Collection;
import java.util.Set;
import java.util.TreeSet;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public class RecipeRegistry {
    public static final Marker RECIPE_MARKER = MarkerManager.getMarker((String)"EE3_RECIPE", (Marker)LogHelper.MOD_MARKER);
    public static final RecipeRegistry INSTANCE = new RecipeRegistry();
    private Multimap<WrappedStack, Set<WrappedStack>> recipeMap = TreeMultimap.create(WrappedStack.COMPARATOR, Comparators.WRAPPED_STACK_SET_COMPARATOR);
    private ImmutableMultimap<WrappedStack, Set<WrappedStack>> immutableRecipeMap;

    private RecipeRegistry() {
    }

    public void addRecipe(Object recipeOutput, Collection<?> recipeInputList) {
        WrappedStack wrappedRecipeOutput = WrappedStack.wrap(recipeOutput);
        if (wrappedRecipeOutput == null) {
            return;
        }
        TreeSet<WrappedStack> wrappedRecipeInputList = new TreeSet<WrappedStack>();
        StringBuilder stringBuilder = new StringBuilder();
        for (Object recipeInputObject : recipeInputList) {
            WrappedStack wrappedInputObject = WrappedStack.wrap(recipeInputObject);
            if (wrappedInputObject != null) {
                wrappedRecipeInputList.add(wrappedInputObject);
                stringBuilder.append(wrappedInputObject);
                stringBuilder.append(" ");
                continue;
            }
            return;
        }
        boolean existsAlready = false;
        for (Set recipeInputs : this.recipeMap.get((Object)wrappedRecipeOutput)) {
            if (!recipeInputs.containsAll(wrappedRecipeInputList) || !wrappedRecipeInputList.containsAll(recipeInputs)) continue;
            existsAlready = true;
        }
        if (!existsAlready) {
            LogHelper.trace(RECIPE_MARKER, "[{}] Mod with ID '{}' added recipe (Output: {}, Inputs: {})", LoaderHelper.getLoaderState(), Loader.instance().activeModContainer().getModId(), wrappedRecipeOutput, stringBuilder.toString().trim());
            this.recipeMap.put((Object)wrappedRecipeOutput, wrappedRecipeInputList);
        }
    }

    public void registerVanillaRecipes() {
        new RecipesVanilla().registerRecipes();
        new RecipesFluidContainers().registerRecipes();
        new RecipesPotions().registerRecipes();
    }

    public Multimap<WrappedStack, Set<WrappedStack>> getRecipeMappings() {
        if (this.immutableRecipeMap == null) {
            this.immutableRecipeMap = ImmutableMultimap.copyOf(RecipeRegistry.INSTANCE.recipeMap);
        }
        return this.immutableRecipeMap;
    }

    public void dumpRecipeRegistryToLog() {
        for (WrappedStack wrappedStack : this.getRecipeMappings().keySet()) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(String.format("Output: %s, Inputs: ", wrappedStack.toString()));
            for (Set listStacks : this.getRecipeMappings().get((Object)wrappedStack)) {
                for (WrappedStack listStack : listStacks) {
                    stringBuilder.append(listStack.toString() + " ");
                }
            }
            LogHelper.info(RECIPE_MARKER, stringBuilder.toString());
        }
    }
}

