/*
 * Decompiled with CFR 0.152.
 */
package com.pahimar.ee3.knowledge;

import com.pahimar.ee3.reference.Comparators;
import com.pahimar.ee3.util.ItemStackUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import net.minecraft.item.ItemStack;

public class PlayerKnowledge {
    private Set<ItemStack> knownItemStacks = new TreeSet<ItemStack>(Comparators.ID_COMPARATOR);

    public PlayerKnowledge() {
        this(Collections.EMPTY_SET);
    }

    public PlayerKnowledge(PlayerKnowledge playerKnowledge) {
        this(playerKnowledge.knownItemStacks);
    }

    public PlayerKnowledge(Collection<?> objects) {
        if (objects != null) {
            for (Object object : objects) {
                this.learn(object);
            }
        }
    }

    public boolean isKnown(Object object) {
        if (object instanceof ItemStack) {
            return this.knownItemStacks.contains(ItemStackUtils.clone((ItemStack)object, 1));
        }
        return false;
    }

    public Set<ItemStack> getKnownItemStacks() {
        return this.knownItemStacks;
    }

    public void learn(Object object) {
        if (object instanceof ItemStack) {
            ItemStack unitItemStack = ItemStackUtils.clone((ItemStack)object, 1);
            this.knownItemStacks.add(unitItemStack);
        }
    }

    public void learn(Collection<?> objects) {
        if (objects != null) {
            for (Object object : objects) {
                this.learn(object);
            }
        }
    }

    public void forget(Object object) {
        if (object instanceof ItemStack) {
            ItemStack unitItemStack = ItemStackUtils.clone((ItemStack)object, 1);
            this.knownItemStacks.remove(unitItemStack);
        }
    }

    public void forget(Collection<?> objects) {
        if (objects != null) {
            for (Object object : objects) {
                this.forget(object);
            }
        }
    }

    public void forgetAll() {
        this.knownItemStacks.clear();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        for (ItemStack itemStack : this.knownItemStacks) {
            stringBuilder.append(String.format("%s, ", ItemStackUtils.toString(itemStack)));
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

