/*
 * Decompiled with CFR 0.152.
 */
package com.pahimar.ee3.item;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.pahimar.ee3.creativetab.CreativeTab;
import com.pahimar.ee3.item.ItemToolModalEE;
import com.pahimar.ee3.reference.Key;
import com.pahimar.ee3.reference.Material;
import com.pahimar.ee3.reference.ToolMode;
import com.pahimar.ee3.util.CommonSoundHelper;
import com.pahimar.ee3.util.IChargeable;
import com.pahimar.ee3.util.IKeyBound;
import com.pahimar.ee3.util.LogHelper;
import com.pahimar.ee3.util.NBTHelper;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;

public class ItemDarkMatterPickAxe
extends ItemToolModalEE
implements IKeyBound,
IChargeable {
    private static final Set blocksEffectiveAgainst = Sets.newHashSet((Object[])new Block[]{Blocks.field_150347_e, Blocks.field_150334_T, Blocks.field_150333_U, Blocks.field_150348_b, Blocks.field_150322_A, Blocks.field_150341_Y, Blocks.field_150366_p, Blocks.field_150339_S, Blocks.field_150365_q, Blocks.field_150340_R, Blocks.field_150352_o, Blocks.field_150482_ag, Blocks.field_150484_ah, Blocks.field_150432_aD, Blocks.field_150424_aL, Blocks.field_150369_x, Blocks.field_150368_y, Blocks.field_150450_ax, Blocks.field_150439_ay, Blocks.field_150448_aq, Blocks.field_150319_E, Blocks.field_150318_D, Blocks.field_150408_cc});

    public ItemDarkMatterPickAxe() {
        super(2.0f, Material.Tools.DARK_MATTER, blocksEffectiveAgainst);
        this.func_77637_a(CreativeTab.EE3_TAB);
        this.setNoRepair();
        this.func_77655_b("pickAxeDarkMatter");
    }

    public boolean func_150897_b(Block block) {
        return block == Blocks.field_150343_Z ? this.field_77862_b.func_77996_d() == 3 : (block != Blocks.field_150484_ah && block != Blocks.field_150482_ag ? (block != Blocks.field_150412_bA && block != Blocks.field_150475_bE ? (block != Blocks.field_150340_R && block != Blocks.field_150352_o ? (block != Blocks.field_150339_S && block != Blocks.field_150366_p ? (block != Blocks.field_150368_y && block != Blocks.field_150369_x ? (block != Blocks.field_150450_ax && block != Blocks.field_150439_ay ? block.func_149688_o() == Material.field_151576_e || block.func_149688_o() == Material.field_151573_f || block.func_149688_o() == Material.field_151574_g : this.field_77862_b.func_77996_d() >= 2) : this.field_77862_b.func_77996_d() >= 1) : this.field_77862_b.func_77996_d() >= 1) : this.field_77862_b.func_77996_d() >= 2) : this.field_77862_b.func_77996_d() >= 2) : this.field_77862_b.func_77996_d() >= 2);
    }

    public float func_150893_a(ItemStack itemStack, Block block) {
        return block.func_149688_o() != Material.field_151573_f && block.func_149688_o() != Material.field_151574_g && block.func_149688_o() != Material.field_151576_e ? super.func_150893_a(itemStack, block) : this.field_77864_a;
    }

    public Set<String> getToolClasses(ItemStack itemStack) {
        return ImmutableSet.of((Object)"pickaxe");
    }

    public float getDigSpeed(ItemStack itemStack, Block block, int meta) {
        if ((ForgeHooks.isToolEffective((ItemStack)itemStack, (Block)block, (int)meta) || block == Blocks.field_150343_Z || block == Blocks.field_150450_ax || block == Blocks.field_150439_ay) && itemStack.func_77973_b() instanceof IChargeable) {
            return super.getDigSpeed(itemStack, block, meta) + (float)((IChargeable)itemStack.func_77973_b()).getChargeLevel(itemStack) * 12.0f;
        }
        return super.getDigSpeed(itemStack, block, meta);
    }

    public boolean func_77648_a(ItemStack itemStack, EntityPlayer entityPlayer, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K) {
            LogHelper.info("Right click with the Dark Matter Pickaxe");
        }
        return false;
    }

    @Override
    public short getMaxChargeLevel() {
        return 3;
    }

    @Override
    public short getChargeLevel(ItemStack itemStack) {
        if (NBTHelper.getShort(itemStack, "chargeLevel") != null) {
            return NBTHelper.getShort(itemStack, "chargeLevel");
        }
        return 0;
    }

    @Override
    public void setChargeLevel(ItemStack itemStack, short chargeLevel) {
        if (chargeLevel <= this.getMaxChargeLevel()) {
            NBTHelper.setShort(itemStack, "chargeLevel", chargeLevel);
        }
    }

    @Override
    public void increaseChargeLevel(ItemStack itemStack) {
        if (this.getChargeLevel(itemStack) < this.getMaxChargeLevel()) {
            NBTHelper.setShort(itemStack, "chargeLevel", (short)(this.getChargeLevel(itemStack) + 1));
        }
    }

    @Override
    public void decreaseChargeLevel(ItemStack itemStack) {
        if (this.getChargeLevel(itemStack) > 0) {
            NBTHelper.setShort(itemStack, "chargeLevel", (short)(this.getChargeLevel(itemStack) - 1));
        }
    }

    @Override
    public void doKeyBindingAction(EntityPlayer entityPlayer, ItemStack itemStack, Key key) {
        if (key == Key.CHARGE) {
            if (!entityPlayer.func_70093_af()) {
                if (this.getChargeLevel(itemStack) == this.getMaxChargeLevel()) {
                    CommonSoundHelper.playSoundAtPlayer(entityPlayer, "fail", 1.5f, 1.5f);
                } else {
                    this.increaseChargeLevel(itemStack);
                    CommonSoundHelper.playSoundAtPlayer(entityPlayer, "chargeUp", 0.5f, 0.5f + 0.5f * ((float)this.getChargeLevel(itemStack) * 1.0f / (float)this.getMaxChargeLevel()));
                }
            } else if (this.getChargeLevel(itemStack) == 0) {
                CommonSoundHelper.playSoundAtPlayer(entityPlayer, "fail", 1.5f, 1.5f);
            } else {
                this.decreaseChargeLevel(itemStack);
                CommonSoundHelper.playSoundAtPlayer(entityPlayer, "chargeDown", 0.5f, 1.0f - (0.5f - 0.5f * ((float)this.getChargeLevel(itemStack) * 1.0f / (float)this.getMaxChargeLevel())));
            }
        } else if (key == Key.EXTRA) {
            CommonSoundHelper.playSoundAtPlayer(entityPlayer, "tock", 0.5f, 1.5f);
            this.changeToolMode(itemStack);
        }
    }

    @Override
    public List<ToolMode> getAvailableToolModes() {
        return Arrays.asList(ToolMode.STANDARD, ToolMode.WIDE, ToolMode.TALL);
    }
}

