/*
 * Decompiled with CFR 0.152.
 */
package com.pahimar.ee3.exchange;

import com.pahimar.ee3.exchange.OreStack;
import com.pahimar.ee3.util.FluidHelper;
import com.pahimar.ee3.util.ItemStackUtils;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public final class WrappedStack
implements Comparable<WrappedStack> {
    private final Object wrappedStack;
    private int stackSize;
    public static final Comparator<WrappedStack> COMPARATOR = new Comparator<WrappedStack>(){

        @Override
        public int compare(WrappedStack wrappedStack1, WrappedStack wrappedStack2) {
            if (wrappedStack1.wrappedStack instanceof ItemStack) {
                if (wrappedStack2.wrappedStack instanceof ItemStack) {
                    int compareResult = ItemStackUtils.compare((ItemStack)wrappedStack1.wrappedStack, (ItemStack)wrappedStack2.wrappedStack);
                    if (compareResult == 0) {
                        return wrappedStack1.stackSize - wrappedStack2.stackSize;
                    }
                    return compareResult;
                }
                return 1;
            }
            if (wrappedStack1.wrappedStack instanceof OreStack) {
                if (wrappedStack2.wrappedStack instanceof ItemStack) {
                    return -1;
                }
                if (wrappedStack2.wrappedStack instanceof OreStack) {
                    int compareResult = OreStack.compare((OreStack)wrappedStack1.wrappedStack, (OreStack)wrappedStack2.wrappedStack);
                    if (compareResult == 0) {
                        return wrappedStack1.stackSize - wrappedStack2.stackSize;
                    }
                    return compareResult;
                }
                return 1;
            }
            if (wrappedStack1.wrappedStack instanceof FluidStack) {
                if (wrappedStack2.wrappedStack instanceof ItemStack || wrappedStack2.wrappedStack instanceof OreStack) {
                    return -1;
                }
                if (wrappedStack2.wrappedStack instanceof FluidStack) {
                    int compareResult = FluidHelper.compare((FluidStack)wrappedStack1.wrappedStack, (FluidStack)wrappedStack2.wrappedStack);
                    if (compareResult == 0) {
                        return wrappedStack1.stackSize - wrappedStack2.stackSize;
                    }
                    return compareResult;
                }
                return 1;
            }
            if (wrappedStack1.wrappedStack == null) {
                if (wrappedStack2.wrappedStack != null) {
                    return -1;
                }
                return 0;
            }
            return 0;
        }
    };

    public WrappedStack() {
        this.stackSize = -1;
        this.wrappedStack = null;
    }

    private WrappedStack(Object object) {
        if (object instanceof Item) {
            object = new ItemStack((Item)object);
        } else if (object instanceof Block) {
            object = new ItemStack((Block)object);
        } else if (object instanceof Fluid) {
            object = new FluidStack((Fluid)object, 1000);
        }
        if (object instanceof ItemStack) {
            if (((ItemStack)object).func_77973_b() != null) {
                this.stackSize = ((ItemStack)object).field_77994_a;
                this.wrappedStack = ItemStackUtils.clone((ItemStack)object, 1);
            } else {
                this.stackSize = -1;
                this.wrappedStack = null;
            }
        } else if (object instanceof OreStack) {
            OreStack oreStack = new OreStack((OreStack)object);
            this.stackSize = oreStack.stackSize;
            oreStack.stackSize = 1;
            this.wrappedStack = oreStack;
        } else if (object instanceof ArrayList) {
            ArrayList objectList = (ArrayList)object;
            OreStack possibleOreStack = OreStack.getOreStackFrom(objectList);
            if (possibleOreStack != null) {
                this.stackSize = possibleOreStack.stackSize;
                possibleOreStack.stackSize = 1;
                this.wrappedStack = possibleOreStack;
            } else {
                this.stackSize = -1;
                this.wrappedStack = null;
            }
        } else if (object instanceof FluidStack) {
            FluidStack fluidStack = ((FluidStack)object).copy();
            this.stackSize = fluidStack.amount;
            fluidStack.amount = 1;
            this.wrappedStack = fluidStack;
        } else if (object instanceof WrappedStack) {
            WrappedStack wrappedStackObject = (WrappedStack)object;
            if (wrappedStackObject.getWrappedObject() != null) {
                this.stackSize = wrappedStackObject.stackSize;
                this.wrappedStack = wrappedStackObject.wrappedStack;
            } else {
                this.stackSize = -1;
                this.wrappedStack = null;
            }
        } else {
            this.stackSize = -1;
            this.wrappedStack = null;
        }
    }

    private WrappedStack(Object object, int stackSize) {
        if (object instanceof Item) {
            object = new ItemStack((Item)object);
        } else if (object instanceof Block) {
            object = new ItemStack((Block)object);
        } else if (object instanceof Fluid) {
            object = new FluidStack((Fluid)object, 1000);
        }
        if (object instanceof ItemStack) {
            this.stackSize = stackSize;
            this.wrappedStack = ItemStackUtils.clone((ItemStack)object, 1);
        } else if (object instanceof OreStack) {
            OreStack oreStack = new OreStack((OreStack)object);
            this.stackSize = stackSize;
            oreStack.stackSize = 1;
            this.wrappedStack = oreStack;
        } else if (object instanceof ArrayList) {
            OreStack possibleOreStack = OreStack.getOreStackFrom((ArrayList)object);
            if (possibleOreStack != null) {
                this.stackSize = stackSize;
                possibleOreStack.stackSize = 1;
                this.wrappedStack = possibleOreStack;
            } else {
                this.stackSize = -1;
                this.wrappedStack = null;
            }
        } else if (object instanceof FluidStack) {
            FluidStack fluidStack = ((FluidStack)object).copy();
            this.stackSize = stackSize;
            fluidStack.amount = 1;
            this.wrappedStack = fluidStack;
        } else if (object instanceof WrappedStack) {
            WrappedStack wrappedStackObject = (WrappedStack)object;
            if (wrappedStackObject.getWrappedObject() != null) {
                this.stackSize = stackSize;
                this.wrappedStack = wrappedStackObject.wrappedStack;
            } else {
                this.stackSize = -1;
                this.wrappedStack = null;
            }
        } else {
            this.stackSize = -1;
            this.wrappedStack = null;
        }
    }

    public Object getWrappedObject() {
        return this.wrappedStack;
    }

    public static boolean canBeWrapped(Object object) {
        if (object instanceof WrappedStack) {
            return true;
        }
        if (object instanceof Item || object instanceof Block) {
            return true;
        }
        if (object instanceof ItemStack) {
            if (((ItemStack)object).func_77973_b() != null) {
                return true;
            }
        } else {
            if (object instanceof OreStack) {
                return true;
            }
            if (object instanceof List ? OreStack.getOreStackFrom((List)object) != null : object instanceof Fluid || object instanceof FluidStack) {
                return true;
            }
        }
        return false;
    }

    public int getStackSize() {
        return this.stackSize;
    }

    public void setStackSize(int stackSize) {
        this.stackSize = stackSize;
    }

    public static WrappedStack wrap(Object object) {
        if (WrappedStack.canBeWrapped(object)) {
            return new WrappedStack(object);
        }
        return null;
    }

    public static WrappedStack wrap(Object object, int stackSize) {
        if (WrappedStack.canBeWrapped(object)) {
            return new WrappedStack(object, stackSize);
        }
        return null;
    }

    public boolean equals(Object object) {
        return object instanceof WrappedStack && this.compareTo((WrappedStack)object) == 0;
    }

    @Override
    public int compareTo(WrappedStack wrappedStack) {
        return COMPARATOR.compare(this, wrappedStack);
    }

    public String toString() {
        if (this.wrappedStack instanceof ItemStack) {
            ItemStack itemStack = (ItemStack)this.wrappedStack;
            String unlocalizedName = null;
            try {
                if (itemStack.func_77973_b() != null) {
                    unlocalizedName = Item.field_150901_e.func_148750_c((Object)itemStack.func_77973_b());
                }
                if (unlocalizedName == null) {
                    unlocalizedName = itemStack.func_77977_a();
                }
            }
            catch (ArrayIndexOutOfBoundsException e) {
                unlocalizedName = "no-name";
            }
            if (itemStack.func_77942_o()) {
                return String.format("%sxitemStack[%s@%s:%s]", this.stackSize, unlocalizedName, itemStack.func_77960_j(), itemStack.func_77978_p());
            }
            return String.format("%sxitemStack[%s@%s]", this.stackSize, unlocalizedName, itemStack.func_77960_j());
        }
        if (this.wrappedStack instanceof OreStack) {
            OreStack oreStack = (OreStack)this.wrappedStack;
            return String.format("%sxoreStack[%s]", this.stackSize, oreStack.oreName);
        }
        if (this.wrappedStack instanceof FluidStack) {
            FluidStack fluidStack = (FluidStack)this.wrappedStack;
            return String.format("%sxfluidStack[%s]", this.stackSize, fluidStack.getFluid().getName());
        }
        return "null-wrappedstack";
    }
}

