/*
 * Decompiled with CFR 0.152.
 */
package com.pahimar.ee3.exchange;

import com.pahimar.ee3.reference.Comparators;
import com.pahimar.ee3.util.FilterUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.oredict.OreDictionary;

public final class OreStack
implements Comparable<OreStack> {
    public String oreName;
    public int stackSize;
    public static Comparator<OreStack> comparator = (oreStack1, oreStack2) -> {
        if (oreStack1 != null && oreStack1.oreName != null) {
            if (oreStack2 != null && oreStack2.oreName != null) {
                if (oreStack1.oreName.equalsIgnoreCase(oreStack2.oreName)) {
                    return oreStack1.stackSize - oreStack2.stackSize;
                }
                return oreStack1.oreName.compareToIgnoreCase(oreStack2.oreName);
            }
            return -1;
        }
        if (oreStack2 != null) {
            return 1;
        }
        return 0;
    };

    private OreStack() {
    }

    public OreStack(String oreName) {
        this(oreName, 1);
    }

    public OreStack(String oreName, int stackSize) {
        this.oreName = oreName;
        this.stackSize = stackSize;
    }

    public OreStack(OreStack oreStack) {
        this.oreName = oreStack.oreName;
        this.stackSize = oreStack.stackSize;
    }

    public static boolean compareOreNames(OreStack oreStack1, OreStack oreStack2) {
        if (oreStack1 != null && oreStack2 != null && oreStack1.oreName != null && oreStack2.oreName != null) {
            return oreStack1.oreName.equalsIgnoreCase(oreStack2.oreName);
        }
        return false;
    }

    public static OreStack getOreStackFrom(Object ... objects) {
        return OreStack.getOreStackFrom(Arrays.asList(objects));
    }

    public static OreStack getOreStackFrom(Collection<?> objects) {
        for (String oreName : OreDictionary.getOreNames()) {
            if (Comparators.ITEM_STACK_COLLECTION_COMPARATOR.compare(FilterUtils.filterForItemStacks(objects), OreDictionary.getOres((String)oreName)) != 0) continue;
            return new OreStack(oreName, 1);
        }
        return null;
    }

    public static int compare(OreStack oreStack1, OreStack oreStack2) {
        return comparator.compare(oreStack1, oreStack2);
    }

    public boolean equals(Object object) {
        return object instanceof OreStack && comparator.compare(this, (OreStack)object) == 0;
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbtTagCompound) {
        nbtTagCompound.func_74778_a("oreName", this.oreName);
        nbtTagCompound.func_74768_a("stackSize", this.stackSize);
        return nbtTagCompound;
    }

    public void readFromNBT(NBTTagCompound nbtTagCompound) {
        this.oreName = nbtTagCompound.func_74779_i("oreName");
        this.stackSize = nbtTagCompound.func_74762_e("stackSize");
    }

    public static OreStack loadOreStackFromNBT(NBTTagCompound nbtTagCompound) {
        OreStack oreStack = new OreStack();
        oreStack.readFromNBT(nbtTagCompound);
        return oreStack.oreName != null ? oreStack : null;
    }

    public String toString() {
        return String.format("%sxoreStack.%s", this.stackSize, this.oreName);
    }

    @Override
    public int compareTo(OreStack oreStack) {
        return comparator.compare(this, oreStack);
    }
}

